/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import loci.common.Location;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.in.CellWorxReader;
import loci.formats.in.MetamorphReader;
import loci.formats.meta.MetadataStore;

public class MetaxpressTiffReader
extends CellWorxReader {
    public MetaxpressTiffReader() {
        super("MetaXpress TIFF", new String[]{"htd", "tif"});
        this.datasetDescription = "One .htd file plus one or more .tif files";
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (MetaxpressTiffReader.checkSuffix((String)name, (String)"htd")) {
            return true;
        }
        if (!open) {
            return false;
        }
        return this.foundHTDFile(name);
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        ArrayList<String> files = new ArrayList<String>();
        files.add(this.currentId);
        int row = this.getWellRow(this.getSeries());
        int col = this.getWellColumn(this.getSeries());
        if (!noPixels) {
            for (String f : this.wellFiles[row][col]) {
                if (!new Location(f).exists()) continue;
                files.add(f);
            }
        }
        return files.toArray(new String[files.size()]);
    }

    public String[] getUsedFiles(boolean noPixels) {
        String[] files = super.getUsedFiles(noPixels);
        ArrayList<String> allFiles = new ArrayList<String>();
        for (String f : files) {
            allFiles.add(f);
        }
        if (this.directoryList != null) {
            Location root = new Location(this.currentId).getParentFile();
            for (String f : this.directoryList) {
                String path;
                if (f.toLowerCase().indexOf("_thumb") <= 0 || allFiles.contains(path = new Location(root, f).getAbsolutePath())) continue;
                allFiles.add(path);
            }
        }
        return allFiles.toArray(new String[allFiles.size()]);
    }

    @Override
    protected void findPixelsFiles() throws FormatException {
        String plateName = this.getPlateName(this.currentId);
        for (int row = 0; row < this.wellFiles.length; ++row) {
            for (int col = 0; col < this.wellFiles[row].length; ++col) {
                if (this.wellFiles[row][col] == null) continue;
                ++this.wellCount;
                char rowLetter = (char)(row + 65);
                this.wellFiles[row][col] = this.getTiffFiles(plateName, rowLetter, col, this.wavelengths.length, this.nTimepoints, this.zSteps);
            }
        }
    }

    @Override
    protected void parseWellLogFile(int wellIndex, MetadataStore store) throws IOException {
    }

    @Override
    protected IFormatReader getReader(String file, boolean omexml) throws FormatException, IOException {
        MetamorphReader reader = new MetamorphReader();
        this.initReader((IFormatReader)reader, file, omexml);
        return reader;
    }

    private String[] getTiffFiles(String plateName, char rowLetter, int col, int channels, int nTimepoints, int zSteps) throws FormatException {
        String well = rowLetter + String.format("%02d", col + 1);
        String base = plateName + well;
        String[] files = new String[this.fieldCount * channels * nTimepoints * zSteps];
        int nextFile = 0;
        for (int field = 0; field < this.fieldCount; ++field) {
            for (int channel = 0; channel < channels; ++channel) {
                int t = 0;
                while (t < nTimepoints) {
                    String file = base;
                    if (this.fieldCount > 1) {
                        file = file + "_s" + (field + 1);
                    }
                    if (this.doChannels || channels > 1) {
                        file = file + "_w" + (channel + 1);
                    }
                    if (nTimepoints > 1) {
                        file = file + "_t" + nTimepoints;
                    }
                    files[nextFile] = file + ".tif";
                    if (!new Location(files[nextFile]).exists()) {
                        files[nextFile] = file + ".TIF";
                    }
                    ++t;
                    ++nextFile;
                }
            }
        }
        boolean noneExist = true;
        for (String file : files) {
            if (file == null || !new Location(file).exists()) continue;
            noneExist = false;
            break;
        }
        if (noneExist) {
            nextFile = 0;
            Location parent = new Location(this.currentId).getAbsoluteFile().getParentFile();
            if (this.directoryList == null) {
                this.directoryList = parent.list(true);
                Arrays.sort(this.directoryList);
            }
            for (String f : this.directoryList) {
                String path;
                if (!MetaxpressTiffReader.checkSuffix((String)f, (String[])new String[]{"tif", "tiff"}) || !(path = new Location(parent, f).getAbsolutePath()).startsWith(base) || path.toLowerCase().indexOf("_thumb") >= 0) continue;
                files[nextFile++] = path;
                noneExist = false;
            }
            if (noneExist) {
                this.subdirectories = true;
                base = base.substring(base.lastIndexOf(File.separator) + 1);
                LOGGER.debug("expected file prefix = {}", (Object)base);
                nextFile = 0;
                for (int i = 0; i < nTimepoints; ++i) {
                    Location dir = new Location(parent, "TimePoint_" + (i + 1));
                    if (!dir.exists() || !dir.isDirectory()) continue;
                    for (int z = 0; z < zSteps; ++z) {
                        Location file = new Location(dir, "ZStep_" + (z + 1));
                        Object[] zList = null;
                        if (file.exists() && file.isDirectory()) {
                            zList = file.list(true);
                        } else if (zSteps == 1) {
                            file = dir;
                            zList = file.list(true);
                        }
                        LOGGER.debug("parent directory = {}", (Object)file);
                        if (zList == null) continue;
                        Arrays.sort(zList);
                        for (Object f : zList) {
                            LOGGER.debug("  checking relative path = {}", f);
                            String path = new Location(file, (String)f).getAbsolutePath();
                            if (!((String)f).startsWith(base) || path.toLowerCase().indexOf("_thumb") >= 0) continue;
                            if (nextFile < files.length) {
                                files[nextFile] = path;
                            }
                            ++nextFile;
                        }
                    }
                }
                if (nextFile != files.length) {
                    LOGGER.warn("Well {} expected {} files; found {}", new Object[]{well, files.length, nextFile});
                }
            }
        }
        return files;
    }
}

