/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.xml;

import java.io.IOException;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.xml.model.OME;
import ome.xml.model.Plate;
import ome.xml.model.Well;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BackReferenceTest {
    private OMEXMLService service;
    private OMEXMLMetadata metadata;

    @BeforeMethod
    public void setUp() throws DependencyException, ServiceException, IOException {
        ServiceFactory sf = new ServiceFactory();
        this.service = (OMEXMLService)sf.getInstance(OMEXMLService.class);
        this.metadata = this.service.createOMEXMLMetadata();
    }

    @Test
    public void testPlateWellReferences() {
        this.metadata.setPlateID("Plate:0", 0);
        this.metadata.setWellID("Well:0:0", 0, 0);
        OME root = (OME)this.metadata.getRoot();
        Plate plate = root.getPlate(0);
        Well well = plate.getWell(0);
        AssertJUnit.assertNotNull((Object)plate);
        AssertJUnit.assertNotNull((Object)well);
        AssertJUnit.assertEquals((Object)plate, (Object)well.getPlate());
    }
}

