/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests.providers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import loci.common.BZip2Handle;
import loci.common.IRandomAccess;
import loci.common.NIOFileHandle;
import loci.common.utests.providers.IRandomAccessProvider;

class BZip2HandleProvider
implements IRandomAccessProvider {
    BZip2HandleProvider() {
    }

    @Override
    public IRandomAccess createMock(byte[] page, String mode, int bufferSize) throws IOException {
        File pageFile = File.createTempFile("page", ".dat");
        pageFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(pageFile);
        out.write(page);
        out.close();
        try {
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(new String[]{"bzip2", pageFile.getAbsolutePath()});
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            pageFile = new File(pageFile.getAbsolutePath() + ".bz2");
            pageFile.deleteOnExit();
            return new BZip2Handle(pageFile.getAbsolutePath());
        }
        catch (IOException iOException) {
            return new NIOFileHandle(pageFile, "r");
        }
    }
}

