/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.ImageReader;

public class SubResolutionExample {
    public static void main(String[] args) throws FormatException, IOException {
        if (args.length != 1) {
            System.err.println("Usage: java SubResolutionExample imageFile");
            System.exit(1);
        }
        String id = args[0];
        ImageReader reader = new ImageReader();
        reader.setFlattenedResolutions(false);
        System.out.println("Initializing file: " + id);
        reader.setId(id);
        int seriesCount = reader.getSeriesCount();
        System.out.println("  Series count = " + seriesCount);
        for (int series = 0; series < seriesCount; ++series) {
            reader.setSeries(series);
            int resolutionCount = reader.getResolutionCount();
            System.out.println("    Resolution count for series #" + series + " = " + resolutionCount);
            for (int r = 0; r < resolutionCount; ++r) {
                reader.setResolution(r);
                System.out.println("      Resolution #" + r + " dimensions = " + reader.getSizeX() + " x " + reader.getSizeY());
            }
        }
        reader.close();
    }
}

