/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.services;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import loci.common.RandomAccessInputStream;
import loci.common.services.AbstractService;
import loci.formats.services.POIService;
import loci.poi.poifs.filesystem.DirectoryEntry;
import loci.poi.poifs.filesystem.DocumentEntry;
import loci.poi.poifs.filesystem.DocumentInputStream;
import loci.poi.poifs.filesystem.Entry;
import loci.poi.poifs.filesystem.POIFSFileSystem;

public class POIServiceImpl
extends AbstractService
implements POIService {
    private static final int MAX_BLOCK_SIZE = 4096;
    public static final int POI_MAGIC_BYTES = -791735840;
    private POIFSFileSystem fileSystem;
    private DirectoryEntry root;
    private RandomAccessInputStream stream;
    private Vector<String> filePath;
    private Hashtable<String, Integer> fileSizes;
    private Hashtable<String, DocumentEntry> files;

    public POIServiceImpl() {
        this.checkClassDependency(DirectoryEntry.class);
    }

    @Override
    public void initialize(String file2) throws IOException {
        this.initialize(new RandomAccessInputStream(file2, 4096));
    }

    @Override
    public void initialize(RandomAccessInputStream s) throws IOException {
        this.stream = s;
        this.stream.order(true);
        this.stream.seek(30L);
        int size = (int)Math.pow(2.0, this.stream.readShort());
        this.stream.seek(0L);
        this.fileSystem = new POIFSFileSystem(this.stream, size);
        this.root = this.fileSystem.getRoot();
        this.filePath = new Vector();
        this.fileSizes = new Hashtable();
        this.files = new Hashtable();
        this.parseFile(this.root);
    }

    @Override
    public InputStream getInputStream(String file2) throws IOException {
        return new DocumentInputStream(this.files.get(file2), this.stream);
    }

    @Override
    public RandomAccessInputStream getDocumentStream(String file2) throws IOException {
        return new RandomAccessInputStream(this.getDocumentBytes(file2));
    }

    @Override
    public byte[] getDocumentBytes(String file2) throws IOException {
        return this.getDocumentBytes(file2, this.getFileSize(file2));
    }

    @Override
    public byte[] getDocumentBytes(String file2, int length) throws IOException {
        int size = this.getFileSize(file2);
        int len = length > size ? size : length;
        byte[] buf = new byte[len];
        InputStream s = this.getInputStream(file2);
        s.read(buf);
        s.close();
        return buf;
    }

    @Override
    public int getFileSize(String file2) {
        if (this.fileSizes.containsKey(file2)) {
            return this.fileSizes.get(file2);
        }
        return -1;
    }

    @Override
    public Vector<String> getDocumentList() {
        Vector<String> list = new Vector<String>();
        list.addAll(this.fileSizes.keySet());
        return list;
    }

    @Override
    public void close() throws IOException {
        this.fileSystem = null;
        this.root = null;
        if (this.stream != null) {
            this.stream.close();
        }
        this.stream = null;
        this.filePath = null;
        this.fileSizes = null;
        this.files = null;
    }

    private void parseFile(DirectoryEntry r) throws IOException {
        this.filePath.add(r.getName());
        Iterator iter = r.getEntries();
        while (iter.hasNext()) {
            Entry o = (Entry)iter.next();
            boolean isInstance = o.isDirectoryEntry();
            boolean isDocument = o.isDocumentEntry();
            if (isInstance) {
                this.parseFile((DirectoryEntry)o);
                continue;
            }
            if (!isDocument) continue;
            StringBuilder path = new StringBuilder();
            for (String p : this.filePath) {
                path.append(p);
                path.append(File.separator);
            }
            path.append(o.getName());
            DocumentInputStream s = new DocumentInputStream((DocumentEntry)o, this.stream);
            this.fileSizes.put(path.toString(), s.available());
            this.files.put(path.toString(), (DocumentEntry)o);
            s.close();
        }
        this.filePath.removeElementAt(this.filePath.size() - 1);
    }
}

