/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Parameter
implements Serializable {
    private final String name;
    private final String valueS;
    private final double[] valueD;
    private final boolean isString;

    public Parameter(String name, Parameter from) {
        this.name = name;
        this.valueS = from.valueS;
        this.valueD = from.valueD;
        this.isString = from.isString;
    }

    public Parameter(String name, String val) {
        this.name = name;
        this.valueS = val;
        this.valueD = null;
        this.isString = true;
    }

    public Parameter(String name, double value) {
        this.name = name;
        this.valueD = new double[1];
        this.valueD[0] = value;
        this.isString = false;
        this.valueS = null;
    }

    public Parameter(String name, double[] value) {
        this.name = name;
        this.valueD = (double[])value.clone();
        this.isString = false;
        this.valueS = null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isString() {
        return this.isString;
    }

    @Nullable
    public String getStringValue() {
        return this.valueS;
    }

    public double getNumericValue() {
        return this.valueD[0];
    }

    public double getNumericValue(int i) {
        return this.valueD[i];
    }

    public int getLength() {
        return this.isString ? 0 : this.valueD.length;
    }

    @Nullable
    public double[] getNumericValues() {
        return this.valueD;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        if (this.isString != parameter.isString) {
            return false;
        }
        if (!this.name.equals(parameter.name)) {
            return false;
        }
        if (!Objects.equals(this.valueS, parameter.valueS)) {
            return false;
        }
        return Arrays.equals(this.valueD, parameter.valueD);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.valueS != null ? this.valueS.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.valueD);
        result = 31 * result + (this.isString ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.getName());
        if (this.isString()) {
            buff.append(" = ");
            buff.append(this.valueS);
        } else {
            buff.append(" = ");
            for (int i = 0; i < this.getLength(); ++i) {
                if (i != 0) {
                    buff.append(", ");
                }
                buff.append(this.getNumericValue(i));
            }
        }
        return buff.toString();
    }
}

