/*
 * Decompiled with CFR 0.152.
 */
package ome.specification;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import ome.xml.model.OME;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLWriter {
    public static final String ID_ATTRIBUTE = "ID";
    public static final String NAME_ATTRIBUTE = "Name";
    public static final String DIMENSION_ORDER_ATTRIBUTE = "DimensionOrder";
    public static final String PIXELS_TYPE_ATTRIBUTE = "PixelType";
    public static final String SIZE_C_ATTRIBUTE = "SizeC";
    public static final String SIZE_T_ATTRIBUTE = "SizeT";
    public static final String SIZE_Z_ATTRIBUTE = "SizeZ";
    public static final String SIZE_X_ATTRIBUTE = "SizeX";
    public static final String SIZE_Y_ATTRIBUTE = "SizeY";
    public static final String COMPRESSION_ATTRIBUTE = "Compression";
    public static final String BIG_ENDIAN_ATTRIBUTE = "BigEndian";
    public static final String LENGTH_ATTRIBUTE = "Length";
    public static final String OME_TAG = "OME";
    public static final String IMAGE_TAG = "Image";
    public static final String PIXELS_TAG = "Pixels";
    public static final String BIN_DATA_TAG = "BinData";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String[] SCHEMAS = new String[]{"http://www.openmicroscopy.org/Schemas/OME/2016-06/ome.xsd"};
    private static final String XML_NS = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String SCHEMA_LOCATION = "http://www.openmicroscopy.org/Schemas/OME/2016-06/ome.xsd";
    private static final String PLANE = "ZrXEfwslJ9N1nDrbtxxWh4fRHo4w8nZ2N0I74Lgj9oIKN9qrPbBK24z+w+9zYzRQWJXfEwwAKXgV4Z1jCPhE9woGjJaarHTsFwy21nF2IoJDkd3L/zSWMSVk508+jpxV4t5p93HE1uE4K34WCVEeeZ1dSRli/b7/6RhF56DjdB6KboGly3zuN2/eZt9uJ2MhHZtktzpjFtn2mhf4i7iggpQyWx74xvFs9VxXQf1QoxN1KcTGXbdfPNoj3qmzz7Wm8/iXXw7wpOrC2MRcbt98VH4UaQxFgu6VPer73JAS+r2Kd2C67ZFbweyR/LCoUiich866SrwJk3IrTD9AlnGO6SjHIz27yWVh1omr36H1qOuD4ULSknM2txm4FrB02gxHWHbgaJWGT02eT1nwGNXygHe7gdYVP8o6Ms9sT/nBwhoMK8NuQINx7KJP/jTP0p5gNjEHZeAN1To9Qp3AF3jaWK2671Dyy/l9BBRMhD3gEqXJ12ZXZ0par2pvqVtMcbpAZk96GKsSWDQP48yDkNYTG7RDBMzRJxiem7eifg1gpUP1rmmaNEu12+0wclsGBUeH1d9HiN+rDnppycrVQIgvKbXKlUkQH230IYHDESKnlLCZALLJuRuAT5qsNri5950OlphUxeYAnNfUkXYRUHGGnGXw58nmnBCp7iuHDC8AJdCRyK+0wk/xtt6EeADkPs9Qq90H2kXvvGVbcL03IV1mb0PkdqWg2ovrkSLXKhLXb65ruPPz43TAT9xv4QJdmFqJbaMHta8Wd1Fs9cffChHWJT3RS9U8VrhGlBB5+1D9PMlqLruYtp7ulUpMSJFOKkboyXoECSzJuzknqP2Cj1KWrNk+gSsnAlq5zko6KUyPXWMBVgPGNrXR+ivtIXmyQGu5jSTuA+S+ogaPraRPQELmmuQ2wcoWI7O9Vpht1tFmgXkrdqCTD7+JwdXlbHSoRz3ti9dpJY+LyKBisuKcDgdxWulwtydNliNSKKyt7qGC2B90VLo+XsYLLEYU+w95l2ZOumqBquStdKntlReWtCDu8HfbK6AryfZXL5hqMTdqFubcXl4n5ZfBNtHaru8/LswNVGua9VJUsvZV9rMniNwoU7Ev+oLc/0SZkJrwL/r+9Jl5k02DRymhE4XISJ3UXcnt2K57w/OmIJK3HzznrIXgPJA9Nq7M6XjXDDXuBF08709iSEfOWWZ0Yz5ySoszOlSO0OGoRYv8X9xUeOfWi4oizQeSOj2ZTXegqZLxj/g8Y7ykyDkG4NsMS0Kx2fZvxqKE9EdUAXMvDN09X0fKdurqYqPBsRq79Id8YIJhamEP969OjHs9VXIETMmCkoUz2//7BfeaCUzv5c61/asdOR6CJ4ANUX7hQA7hlTk8qllaaLIEWQyGeaDoaw9b5xq0AdhwOZSeCKNIyQVpApdCOnXYuZVoTBNDdW7/7OPZD2uyS9gZ+7JGmuoV9/gRZT72oAQs4++/GpC5h6uOx9Rt5265siOZjfYYX++/qUX8M5Fs9whPwL8NqrJ4qZrUbTYUzQaI";

    private void copyValues(File file, byte[] values) throws Exception {
        FileOutputStream stream = new FileOutputStream(file);
        ((OutputStream)stream).write(values);
        ((OutputStream)stream).close();
    }

    private String createXMLDocument(OME ome, boolean binaryData) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.newDocument();
        Element root = ome.asXMLElement(document);
        root.setAttribute("xmlns", XML_NS);
        root.setAttribute("xmlns:xsi", XSI_NS);
        root.setAttribute("xsi:schemaLocation", "http://www.openmicroscopy.org/Schemas/OME/2016-06 http://www.openmicroscopy.org/Schemas/OME/2016-06/ome.xsd");
        document.appendChild(root);
        if (binaryData) {
            NodeList nodes = document.getElementsByTagName(BIN_DATA_TAG);
            for (int i = 0; i < nodes.getLength(); ++i) {
                nodes.item(i).setTextContent(PLANE);
            }
        }
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(document);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8));
        transformer.transform(source, result);
        return os.toString();
    }

    private void validate(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        factory.setAttribute(JAXP_SCHEMA_LANGUAGE, SCHEMAS);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.parse(file);
    }

    public void writeFile(File file, OME ome) throws Exception {
        this.writeFile(file, ome, true);
    }

    public void writeFile(File file, OME ome, boolean binaryData) throws Exception {
        String values = this.createXMLDocument(ome, binaryData);
        this.copyValues(file, values.getBytes());
    }
}

