/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import loci.common.Location;
import loci.formats.FilePattern;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FilePatternTest {
    private static final String SEPARATOR = FileSystems.getDefault().getSeparator();

    @DataProvider(name="booleanStates")
    public Object[][] createBooleans() {
        return new Object[][]{{true}, {false}};
    }

    @DataProvider(name="badPatterns")
    public Object[][] createBadPatterns() {
        return new Object[][]{{"<0-2><3-4"}, {"0-2><3-4>"}, {"<<0-2>>"}, {"<0-2<3-4>>"}};
    }

    private static String resolveToString(Path head, String tail) {
        return head.toString() + SEPARATOR + tail;
    }

    private static String mkPattern(String[] prefixes, String[] blocks, String suffix) {
        if (prefixes.length != blocks.length) {
            throw new RuntimeException("arrays must have the same length");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < prefixes.length; ++i) {
            sb.append(prefixes[i]);
            sb.append(blocks[i]);
        }
        sb.append(suffix);
        return sb.toString();
    }

    private static String[] mkFiles(Path dir, String[] basenames) throws IOException {
        Path[] paths = FilePatternTest.mkPaths(dir, basenames);
        String[] fullNames = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            fullNames[i] = paths[i].toString();
        }
        return fullNames;
    }

    private static Path[] mkPaths(Path dir, String[] basenames) throws IOException {
        Path[] paths = new Path[basenames.length];
        for (int i = 0; i < basenames.length; ++i) {
            paths[i] = Files.createFile(dir.resolve(basenames[i]), new FileAttribute[0]);
            paths[i].toFile().deleteOnExit();
        }
        return paths;
    }

    private static String[] resolveAll(Path dir, String[] basenames) {
        String[] resolved = new String[basenames.length];
        for (int i = 0; i < basenames.length; ++i) {
            resolved[i] = FilePatternTest.resolveToString(dir, basenames[i]);
        }
        return resolved;
    }

    @Test
    public void testNonRegex() {
        int i;
        Object[] prefixes = new String[]{"z", "c", "t"};
        Object[] blocks = new String[]{"<0-1>", "<R,G,B>", "<10-30:10>"};
        String suffix = ".tif";
        String pattern = FilePatternTest.mkPattern((String[])prefixes, (String[])blocks, suffix);
        FilePattern fp = new FilePattern(pattern);
        Assert.assertTrue((boolean)fp.isValid());
        Assert.assertFalse((boolean)fp.isRegex());
        Assert.assertEquals((String)fp.getPattern(), (String)pattern);
        Assert.assertEquals((Object[])fp.getPrefixes(), (Object[])prefixes);
        for (i = 0; i < prefixes.length; ++i) {
            Assert.assertEquals((String)fp.getPrefix(i), (String)prefixes[i]);
        }
        Assert.assertEquals((String)fp.getPrefix(), (String)prefixes[0]);
        Assert.assertEquals((Object[])fp.getBlocks(), (Object[])blocks);
        for (i = 0; i < blocks.length; ++i) {
            Assert.assertEquals((String)fp.getBlock(i), (String)blocks[i]);
        }
        Assert.assertEquals((String)fp.getSuffix(), (String)suffix);
        Assert.assertEquals((Object)fp.getCount(), (Object)new int[]{2, 3, 3});
        Assert.assertEquals((Object[])fp.getElements(), (Object[])new String[][]{{"0", "1"}, {"R", "G", "B"}, {"10", "20", "30"}});
        Assert.assertEqualsNoOrder((Object[])fp.getFiles(), (Object[])new String[]{"z0cRt10.tif", "z0cRt20.tif", "z0cRt30.tif", "z0cGt10.tif", "z0cGt20.tif", "z0cGt30.tif", "z0cBt10.tif", "z0cBt20.tif", "z0cBt30.tif", "z1cRt10.tif", "z1cRt20.tif", "z1cRt30.tif", "z1cGt10.tif", "z1cGt20.tif", "z1cGt30.tif", "z1cBt10.tif", "z1cBt20.tif", "z1cBt30.tif"});
        Assert.assertEquals((Object[])fp.getFirst(), (Object[])new BigInteger[]{new BigInteger("0"), null, new BigInteger("10")});
        Assert.assertEquals((Object[])fp.getLast(), (Object[])new BigInteger[]{new BigInteger("1"), null, new BigInteger("30")});
        Assert.assertEquals((Object[])fp.getStep(), (Object[])new BigInteger[]{new BigInteger("1"), null, new BigInteger("10")});
    }

    @Test(dataProvider="booleanStates")
    public void testRegex(Boolean createFiles) throws IOException {
        String[] names = new String[]{"z0.tif", "z1.tif"};
        Path wd = Files.createTempDirectory("", new FileAttribute[0]);
        wd.toFile().deleteOnExit();
        String pattern = FilePatternTest.resolveToString(wd, "z.*.tif");
        FilePattern fp = new FilePattern(pattern);
        Assert.assertTrue((boolean)fp.isValid());
        Assert.assertTrue((boolean)fp.isRegex());
        Assert.assertEquals((String)fp.getPattern(), (String)pattern);
        if (!createFiles.booleanValue()) {
            Assert.assertEquals((Object[])fp.getFiles(), (Object[])new String[]{pattern});
            return;
        }
        Object[] fullNames = FilePatternTest.mkFiles(wd, names);
        Assert.assertEqualsNoOrder((Object[])new FilePattern(pattern).getFiles(), (Object[])fullNames);
    }

    @Test
    public void testSingleFile() {
        String pattern = "test.fake";
        FilePattern fp = new FilePattern(pattern);
        Assert.assertTrue((boolean)fp.isValid());
        Assert.assertTrue((boolean)fp.isRegex());
        Assert.assertEquals((String)fp.getPattern(), (String)pattern);
        Assert.assertEquals((Object[])fp.getFiles(), (Object[])new String[]{pattern});
    }

    @Test(dataProvider="booleanStates")
    public void testFindPattern(Boolean createFiles) throws IOException {
        int minZ = 1;
        int maxZ = 2;
        int minT = 1;
        int maxT = 12;
        int minC = 9;
        int maxC = 11;
        String[] prefixes = new String[]{"foo_", "", "c"};
        String[] formats = new String[]{"%d", "%02d", "%d"};
        String[] blocks = new String[]{String.format("<%d-%d>", minZ, maxZ), String.format("<%02d-%02d>", minT, maxT), String.format("<%d-%d>", minC, maxC)};
        String suffix = ".ext";
        String pattern = FilePatternTest.mkPattern(prefixes, blocks, suffix);
        ArrayList<String> names = new ArrayList<String>();
        names.add("outlier.ext");
        for (int z = minZ; z <= maxZ; ++z) {
            for (int t = minT; t <= maxT; ++t) {
                for (int c = minC; c <= maxC; ++c) {
                    names.add(FilePatternTest.mkPattern(prefixes, new String[]{String.format(formats[0], z), String.format(formats[1], t), String.format(formats[2], c)}, suffix));
                }
            }
        }
        String[] namesA = names.toArray(new String[names.size()]);
        if (!createFiles.booleanValue()) {
            Assert.assertEquals((String)FilePattern.findPattern((String)namesA[1], null, (String[])namesA), (String)pattern);
            String[] minCBlocks = new String[]{blocks[0], blocks[1], Integer.toString(minC)};
            int[] excl = new int[]{3};
            Assert.assertEquals((String)FilePattern.findPattern((String)namesA[1], null, (String[])namesA, (int[])excl), (String)FilePatternTest.mkPattern(prefixes, minCBlocks, suffix));
            return;
        }
        Path wd = Files.createTempDirectory("", new FileAttribute[0]);
        wd.toFile().deleteOnExit();
        String absPattern = FilePatternTest.resolveToString(wd, pattern);
        String[] fullNames = FilePatternTest.mkFiles(wd, namesA);
        Assert.assertEquals((String)FilePattern.findPattern((String)fullNames[1]), (String)absPattern);
        Assert.assertEquals((String)FilePattern.findPattern((String)namesA[1], (String)wd.toString()), (String)absPattern);
        Assert.assertEquals((String)FilePattern.findPattern((File)new File(fullNames[1])), (String)absPattern);
        Assert.assertEquals((String)FilePattern.findPattern((Location)new Location(fullNames[1])), (String)absPattern);
        FilePattern fp = new FilePattern(new Location(fullNames[1]));
        Assert.assertEquals((String)fp.getPattern(), (String)absPattern);
        fp = new FilePattern(namesA[1], wd.toString());
        Assert.assertEquals((String)fp.getPattern(), (String)absPattern);
    }

    @Test(dataProvider="booleanStates")
    public void testFindSeriesPattern(boolean createFiles) throws IOException {
        String[] names = new String[]{"foo_s1_z1.fake", "foo_s1_z2.fake", "foo_s2_z1.fake", "foo_s2_z2.fake", "foo_s1_z1.ini", "foo_s1_z2.ini", "foo_s2_z1.ini", "foo_s2_z2.ini"};
        Object[] fakePatterns = new String[]{"foo_s1_z<1-2>.fake", "foo_s2_z<1-2>.fake"};
        Object[] iniPatterns = new String[]{"foo_s1_z<1-2>.ini", "foo_s2_z<1-2>.ini"};
        if (!createFiles) {
            Assert.assertEqualsNoOrder((Object[])FilePattern.findSeriesPatterns((String)names[0], null, (String[])names), (Object[])fakePatterns);
            Assert.assertEqualsNoOrder((Object[])FilePattern.findSeriesPatterns((String)names[4], null, (String[])names), (Object[])iniPatterns);
            return;
        }
        Path wd = Files.createTempDirectory("", new FileAttribute[0]);
        wd.toFile().deleteOnExit();
        String[] fullNames = FilePatternTest.mkFiles(wd, names);
        Assert.assertEqualsNoOrder((Object[])FilePattern.findSeriesPatterns((String)fullNames[0]), (Object[])FilePatternTest.resolveAll(wd, (String[])fakePatterns));
        Assert.assertEqualsNoOrder((Object[])FilePattern.findSeriesPatterns((String)fullNames[4]), (Object[])FilePatternTest.resolveAll(wd, (String[])iniPatterns));
    }

    @Test(dataProvider="badPatterns")
    public void testBadPatterns(String pattern) {
        FilePattern fp = new FilePattern(pattern);
        Assert.assertFalse((boolean)fp.isValid());
        Assert.assertNotNull((Object)fp.getErrorMessage());
    }

    @Test
    public void testVarDir() {
        int i;
        Object[] prefixes = new String[]{"z"};
        Object[] blocks = new String[]{"<0-1>"};
        String suffix = SEPARATOR + "foo.tif";
        String pattern = FilePatternTest.mkPattern((String[])prefixes, (String[])blocks, suffix);
        FilePattern fp = new FilePattern(pattern);
        Assert.assertTrue((boolean)fp.isValid());
        Assert.assertFalse((boolean)fp.isRegex());
        Assert.assertEquals((String)fp.getPattern(), (String)pattern);
        Assert.assertEquals((Object[])fp.getPrefixes(), (Object[])prefixes);
        for (i = 0; i < prefixes.length; ++i) {
            Assert.assertEquals((String)fp.getPrefix(i), (String)prefixes[i]);
        }
        Assert.assertEquals((String)fp.getPrefix(), (String)prefixes[0]);
        Assert.assertEquals((Object[])fp.getBlocks(), (Object[])blocks);
        for (i = 0; i < blocks.length; ++i) {
            Assert.assertEquals((String)fp.getBlock(i), (String)blocks[i]);
        }
        Assert.assertEquals((String)fp.getSuffix(), (String)suffix);
        Assert.assertEquals((Object)fp.getCount(), (Object)new int[]{2});
        Assert.assertEquals((Object[])fp.getElements(), (Object[])new String[][]{{"0", "1"}});
        Assert.assertEqualsNoOrder((Object[])fp.getFiles(), (Object[])new String[]{"z0" + suffix, "z1" + suffix});
        Assert.assertEquals((Object[])fp.getFirst(), (Object[])new BigInteger[]{BigInteger.ZERO});
        Assert.assertEquals((Object[])fp.getLast(), (Object[])new BigInteger[]{BigInteger.ONE});
        Assert.assertEquals((Object[])fp.getStep(), (Object[])new BigInteger[]{BigInteger.ONE});
    }
}

