/*
 * Decompiled with CFR 0.152.
 */
package com.bc.zarr.storage;

import com.bc.zarr.ZarrUtils;
import com.bc.zarr.storage.Store;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InMemoryStore
implements Store {
    private final Map<String, byte[]> map = new HashMap<String, byte[]>();

    @Override
    public InputStream getInputStream(String key) {
        byte[] bytes = this.map.get(key);
        if (bytes != null) {
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream(final String key) {
        return new ByteArrayOutputStream(){

            @Override
            public void close() {
                InMemoryStore.this.map.remove(key);
                InMemoryStore.this.map.put(key, this.toByteArray());
            }
        };
    }

    @Override
    public void delete(String key) {
        this.map.remove(key);
    }

    @Override
    public TreeSet<String> getArrayKeys() {
        return this.getParentsOf(".zarray");
    }

    @Override
    public TreeSet<String> getGroupKeys() {
        return this.getParentsOf(".zgroup");
    }

    private TreeSet<String> getParentsOf(String suffix) {
        return this.getKeysEndingWith(suffix).stream().map(s2 -> {
            String relKey = s2.replace(suffix, "");
            while (relKey.endsWith("/")) {
                relKey = relKey.substring(0, relKey.length() - 1);
            }
            return relKey;
        }).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public TreeSet<String> getKeysEndingWith(String suffix) {
        Set<String> keySet = this.map.keySet();
        TreeSet<String> arrayKeys = new TreeSet<String>();
        for (String key : keySet) {
            if (!key.endsWith(suffix)) continue;
            arrayKeys.add(key);
        }
        return arrayKeys;
    }

    @Override
    public Stream<String> getRelativeLeafKeys(String key) throws IOException {
        Set<String> keySet = this.map.keySet();
        return keySet.stream().filter(s2 -> !s2.equals(key) && s2.startsWith(key)).map(s2 -> s2.replace(key, "")).map(ZarrUtils::normalizeStoragePath);
    }
}

