/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.CoordSysEvaluator;
import ucar.nc2.ft.point.standard.TableConfigurer;

public abstract class TableConfigurerImpl
implements TableConfigurer {
    private String convName;
    private String convUsed;

    @Override
    public String getConvName() {
        return this.convName;
    }

    @Override
    public void setConvName(String convName) {
        this.convName = convName;
    }

    @Override
    public String getConvUsed() {
        return this.convUsed;
    }

    @Override
    public void setConvUsed(String convUsed) {
        this.convUsed = convUsed;
    }

    protected String matchAxisTypeAndDimension(NetcdfDataset ds, AxisType type, Dimension outer, Dimension inner) {
        CoordinateAxis var = CoordSysEvaluator.findCoordByType(ds, type, axis -> axis.getRank() == 2 && outer.equals(axis.getDimension(0)) && inner.equals(axis.getDimension(1)));
        if (var == null) {
            return null;
        }
        return var.getShortName();
    }

    protected String matchAxisTypeAndDimension(NetcdfDataset ds, AxisType type, Dimension outer, Dimension middle, Dimension inner) {
        CoordinateAxis var = CoordSysEvaluator.findCoordByType(ds, type, axis -> axis.getRank() == 3 && outer.equals(axis.getDimension(0)) && middle.equals(axis.getDimension(1)) && inner.equals(axis.getDimension(2)));
        if (var == null) {
            return null;
        }
        return var.getShortName();
    }

    protected CoordinateAxis findZAxisNotStationAlt(NetcdfDataset ds) {
        CoordinateAxis z = CoordSysEvaluator.findCoordByType(ds, AxisType.Height, (CoordSysEvaluator.Predicate)new NotStationAlt());
        if (z != null) {
            return z;
        }
        z = CoordSysEvaluator.findCoordByType(ds, AxisType.Pressure, (CoordSysEvaluator.Predicate)new NotStationAlt());
        if (z != null) {
            return z;
        }
        z = CoordSysEvaluator.findCoordByType(ds, AxisType.GeoZ, (CoordSysEvaluator.Predicate)new NotStationAlt());
        return z;
    }

    private static class NotStationAlt
    implements CoordSysEvaluator.Predicate {
        private NotStationAlt() {
        }

        @Override
        public boolean match(CoordinateAxis axis) {
            Attribute stdName = axis.findAttribute("standard_name");
            if (stdName == null) {
                return true;
            }
            String val = stdName.getStringValue();
            return !"surface_altitude".equals(val) && !"station_altitude".equals(val);
        }
    }
}

