/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.base.unix.Unix;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

class GroupCache {
    private final Unix.Password userOrNull;
    private final Map<Integer, Boolean> gidMap = new HashMap<Integer, Boolean>();

    GroupCache() {
        this.userOrNull = Unix.isOperational() ? Unix.tryGetUserByUid(Unix.getUid()) : null;
    }

    boolean isUserInGroup(int gid) {
        if (this.userOrNull == null) {
            return false;
        }
        Boolean cached = this.gidMap.get(gid);
        if (cached != null) {
            return cached;
        }
        Unix.Group groupOrNull = Unix.tryGetGroupByGid(gid);
        if (groupOrNull != null) {
            int idx = ArrayUtils.indexOf(groupOrNull.getGroupMembers(), this.userOrNull.getUserName());
            Boolean found = idx != -1 ? Boolean.TRUE : Boolean.FALSE;
            this.gidMap.put(gid, found);
            return found;
        }
        this.gidMap.put(gid, Boolean.FALSE);
        return false;
    }
}

