/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class EncodingTest {
    private static final String MAC = EncodingTest.getMacEncoding();
    private static final String WINDOWS = "Windows-1252";
    private static final String ENGLISH_ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String UMLAUTS = "\u00e4\u00eb\u00fc\u00f6\u00ef\u00c4\u00cb\u00d6\u00dc\u00cf";
    private static final String ESZETT = "\u00df";
    private static final String ASSORTED_LETTERS = "\u00e5\u00c5\u00f1\u00d1\u00e7\u00c7\u00f8\u00d8";
    private static final String ACUTE_ACCENTS = "\u00e1\u00e9\u00fa\u00ed\u00f3\u00c1\u00c9\u00cd\u00d3\u00da";
    private static final String SUPERSCRIPTS = "\u00b9\u00b2\u00b3";
    private static final String MATH = "+=-\u00d7\u00f7";
    private static final String FRACTIONS = "\u00bc\u00bd\u00be";
    private static final String CURRENCY = "\u20ac$\u00a5\u00a3\u00a2";
    private static final String PUNCTUATION = ",.?':;\"\u00b6\u00bf\u201c\u201d\\!\u02dd\u00b8-\u02d8\u2018\u2019`\u02c7\u00a7";
    private static final String SQUARE_BRACKETS = "[]";
    private static final String CURLY_BRACKETS = "{}";
    private static final String ANGLE_BRACKETS = "<>";
    private static final String ROUND_BRACKETS = "()";
    private static final String DOUBLE_ANGLE_BRACKETS = "\u00ab\u00bb";

    static String getMacEncoding() {
        if (Charset.isSupported("MacRoman")) {
            return "MacRoman";
        }
        if (Charset.isSupported("x-MacRoman")) {
            return "x-MacRoman";
        }
        return "macintosh";
    }

    @Test
    public void testAlphabetMac() {
        try {
            AssertJUnit.assertTrue((boolean)ENGLISH_ALPHABET.equals(new String(ENGLISH_ALPHABET.getBytes(MAC), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testAlphabetWindows() {
        try {
            AssertJUnit.assertTrue((boolean)ENGLISH_ALPHABET.equals(new String(ENGLISH_ALPHABET.getBytes(WINDOWS), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testUmlautsMac() {
        try {
            AssertJUnit.assertTrue((boolean)UMLAUTS.equals(new String(UMLAUTS.getBytes(MAC), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testUmlautsWindows() {
        try {
            AssertJUnit.assertTrue((boolean)UMLAUTS.equals(new String(UMLAUTS.getBytes(WINDOWS), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testEszettLettersMac() {
        try {
            AssertJUnit.assertTrue((boolean)ESZETT.equals(new String(ESZETT.getBytes(MAC), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testEszettLettersWindows() {
        try {
            AssertJUnit.assertTrue((boolean)ESZETT.equals(new String(ESZETT.getBytes(WINDOWS), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testAssortedLettersMac() {
        try {
            AssertJUnit.assertTrue((boolean)ASSORTED_LETTERS.equals(new String(ASSORTED_LETTERS.getBytes(MAC), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testAssortedLettersWindows() {
        try {
            AssertJUnit.assertTrue((boolean)ASSORTED_LETTERS.equals(new String(ASSORTED_LETTERS.getBytes(WINDOWS), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testAcuteAccentsMac() {
        try {
            AssertJUnit.assertTrue((boolean)ACUTE_ACCENTS.equals(new String(ACUTE_ACCENTS.getBytes(MAC), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testAcuteAccentsWindows() {
        try {
            AssertJUnit.assertTrue((boolean)ACUTE_ACCENTS.equals(new String(ACUTE_ACCENTS.getBytes(WINDOWS), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testSuperscriptsMac() {
        try {
            AssertJUnit.assertTrue((boolean)SUPERSCRIPTS.equals(new String(SUPERSCRIPTS.getBytes(MAC), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testSuperscriptsWindows() {
        try {
            AssertJUnit.assertTrue((boolean)SUPERSCRIPTS.equals(new String(SUPERSCRIPTS.getBytes(WINDOWS), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testMathMac() {
        try {
            AssertJUnit.assertTrue((boolean)MATH.equals(new String(MATH.getBytes(MAC), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testMathWindows() {
        try {
            AssertJUnit.assertTrue((boolean)MATH.equals(new String(MATH.getBytes(WINDOWS), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testFractionsMac() {
        try {
            AssertJUnit.assertTrue((boolean)FRACTIONS.equals(new String(FRACTIONS.getBytes(MAC), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testFractionsWindows() {
        try {
            AssertJUnit.assertTrue((boolean)FRACTIONS.equals(new String(FRACTIONS.getBytes(WINDOWS), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testCurrencyMac() {
        try {
            AssertJUnit.assertTrue((boolean)CURRENCY.equals(new String(CURRENCY.getBytes(MAC), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testCurrencyWindows() {
        try {
            AssertJUnit.assertTrue((boolean)CURRENCY.equals(new String(CURRENCY.getBytes(WINDOWS), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testPunctuationMac() {
        try {
            AssertJUnit.assertTrue((boolean)PUNCTUATION.equals(new String(PUNCTUATION.getBytes(MAC), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testPunctuationWindows() {
        try {
            AssertJUnit.assertTrue((boolean)PUNCTUATION.equals(new String(PUNCTUATION.getBytes(WINDOWS), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testSquareBracketsMac() {
        try {
            AssertJUnit.assertTrue((boolean)SQUARE_BRACKETS.equals(new String(SQUARE_BRACKETS.getBytes(MAC), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testSquareBracketsWindows() {
        try {
            AssertJUnit.assertTrue((boolean)SQUARE_BRACKETS.equals(new String(SQUARE_BRACKETS.getBytes(WINDOWS), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testCurlyBracketsMac() {
        try {
            AssertJUnit.assertTrue((boolean)CURLY_BRACKETS.equals(new String(CURLY_BRACKETS.getBytes(MAC), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testCurlyBracketsWindows() {
        try {
            AssertJUnit.assertTrue((boolean)CURLY_BRACKETS.equals(new String(CURLY_BRACKETS.getBytes(WINDOWS), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testAngleBracketsMac() {
        try {
            AssertJUnit.assertTrue((boolean)ANGLE_BRACKETS.equals(new String(ANGLE_BRACKETS.getBytes(MAC), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testAngleBracketsWindows() {
        try {
            AssertJUnit.assertTrue((boolean)ANGLE_BRACKETS.equals(new String(ANGLE_BRACKETS.getBytes(WINDOWS), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testDoubleAngleBracketsMac() {
        try {
            AssertJUnit.assertTrue((boolean)DOUBLE_ANGLE_BRACKETS.equals(new String(DOUBLE_ANGLE_BRACKETS.getBytes(MAC), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testDoubleAngleBracketsWindows() {
        try {
            AssertJUnit.assertTrue((boolean)DOUBLE_ANGLE_BRACKETS.equals(new String(DOUBLE_ANGLE_BRACKETS.getBytes(WINDOWS), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testRoundBracketsMac() {
        try {
            AssertJUnit.assertTrue((boolean)ROUND_BRACKETS.equals(new String(ROUND_BRACKETS.getBytes(MAC), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Test
    public void testRoundBracketsWindows() {
        try {
            AssertJUnit.assertTrue((boolean)ROUND_BRACKETS.equals(new String(ROUND_BRACKETS.getBytes(WINDOWS), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

