/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import com.bc.zarr.JZarrException;
import com.bc.zarr.ZarrUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataOptions;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.JZarrServiceImpl;
import loci.formats.services.OMEXMLService;
import loci.formats.services.ZarrService;
import ome.xml.meta.MetadataConverter;
import ome.xml.meta.MetadataRetrieve;
import ome.xml.meta.MetadataRoot;
import ome.xml.model.MapAnnotation;
import ome.xml.model.OME;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ZarrReader
extends FormatReader {
    public static final String QUICK_READ_KEY = "omezarr.quick_read";
    public static final boolean QUICK_READ_DEFAULT = false;
    public static final String SAVE_ANNOTATIONS_KEY = "omezarr.save_annotations";
    public static final boolean SAVE_ANNOTATIONS_DEFAULT = false;
    public static final String LIST_PIXELS_KEY = "omezarr.list_pixels";
    public static final boolean LIST_PIXELS_DEFAULT = true;
    public static final String LIST_PIXELS_ENV_KEY = "OME_ZARR_LIST_PIXELS";
    public static final String INCLUDE_LABELS_KEY = "omezarr.include_labels";
    public static final boolean INCLUDE_LABELS_DEFAULT = false;
    public static final String ALT_STORE_KEY = "omezarr.alt_store";
    public static final String ALT_STORE_DEFAULT = null;
    protected transient ZarrService zarrService;
    private ArrayList<String> arrayPaths = new ArrayList();
    private transient ArrayList<String> groupKeys = new ArrayList();
    private transient HashMap<Integer, ArrayList<String>> resSeries = new HashMap();
    private transient HashMap<String, Integer> resCounts = new HashMap();
    private transient HashSet<Integer> uniqueResCounts = new HashSet();
    private transient HashMap<String, Integer> resIndexes = new HashMap();
    private transient HashMap<String, ArrayList<String>> pathArrayDimensions = new HashMap();
    private String dimensionOrder = "XYZCT";
    private int wellCount = 0;
    private int wellSamplesCount = 0;
    private boolean planesPrePopulated = false;
    private boolean hasSPW = false;
    private transient int currentOpenZarr = -1;
    private static Comparator<String> keyComparator = (a, b) -> {
        String[] bParts;
        String[] aParts = a.split("/");
        int numParts = aParts.length - (bParts = b.split("/")).length;
        if (numParts != 0) {
            return numParts;
        }
        for (int i = 0; i < aParts.length; ++i) {
            String aPart = aParts[i];
            String bPart = bParts[i];
            boolean isAInt = ZarrReader.isInteger(aPart);
            boolean isBInt = ZarrReader.isInteger(bPart);
            if (isAInt && !isBInt) {
                return -1;
            }
            if (!isAInt && isBInt) {
                return 1;
            }
            if (isAInt) {
                int numResult = Integer.compare(Integer.valueOf(aPart), Integer.valueOf(bPart));
                if (numResult == 0) continue;
                return numResult;
            }
            int stringResult = aPart.compareTo(bPart);
            if (stringResult == 0) continue;
            return stringResult;
        }
        return 0;
    };

    public ZarrReader() {
        super("Zarr", "zarr");
        this.suffixSufficient = false;
        this.domains = new String[]{"Unknown"};
    }

    public int getRequiredDirectories(String[] files) throws FormatException, IOException {
        return 1;
    }

    public boolean isThisType(String name, boolean open) {
        Location zarrFolder = new Location(name);
        if (zarrFolder != null && zarrFolder.getAbsolutePath().toLowerCase().indexOf(".zarr") > 0) {
            return true;
        }
        return super.isThisType(name, open);
    }

    public void close() throws IOException {
        this.arrayPaths.clear();
        this.groupKeys.clear();
        this.resSeries.clear();
        this.resCounts.clear();
        this.uniqueResCounts.clear();
        this.resIndexes.clear();
        this.pathArrayDimensions.clear();
        if (this.zarrService != null) {
            this.zarrService.close();
        }
        this.planesPrePopulated = false;
        this.hasSPW = false;
        this.currentOpenZarr = -1;
        this.wellCount = 0;
        this.wellSamplesCount = 0;
        super.close();
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        int[] chunkSizes = this.zarrService.getChunkSize();
        return chunkSizes[chunkSizes.length - 2];
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        int[] chunkSizes = this.zarrService.getChunkSize();
        return chunkSizes[chunkSizes.length - 1];
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        String xml_id;
        String jsonAttr;
        Map<String, Object> attributes;
        super.initFile(id);
        LOGGER.debug("ZarrReader attempting to initialize file: {}", (Object)id);
        MetadataStore store = this.makeFilterMetadata();
        Location zarrFolder = new Location(id);
        String zarrPath = zarrFolder.getAbsolutePath();
        String zarrRootPath = zarrPath.substring(0, zarrPath.indexOf(".zarr") + 5);
        String name = zarrRootPath.substring(zarrRootPath.lastIndexOf(File.separator) + 1, zarrRootPath.length() - 5);
        Location omeMetaFile = new Location(zarrRootPath + File.separator + "OME", "METADATA.ome.xml");
        String canonicalPath = new Location(zarrRootPath).getCanonicalPath();
        this.initializeZarrService();
        this.reloadOptionsFile(zarrRootPath);
        ArrayList<String> omeSeriesOrder = new ArrayList<String>();
        if (omeMetaFile.exists()) {
            LOGGER.debug("ZarrReader parsing existing OME-XML");
            this.parseOMEXML(omeMetaFile, store, omeSeriesOrder);
        }
        Map<String, Object> attr = this.zarrService.getGroupAttr(canonicalPath);
        int attrIndex = 0;
        if (attr != null && !attr.isEmpty()) {
            this.parseResolutionCount(zarrRootPath, "", attr);
            this.parseOmeroMetadata(attr);
            if (this.saveAnnotations()) {
                try {
                    String jsonAttr2 = ZarrUtils.toJson(attr, (boolean)true);
                    store.setXMLAnnotationValue(jsonAttr2, attrIndex);
                    String xml_id2 = MetadataTools.createLSID((String)"Annotation", (int[])new int[]{attrIndex});
                    store.setXMLAnnotationID(xml_id2, attrIndex);
                }
                catch (JZarrException e) {
                    LOGGER.warn("Failed to convert attributes to JSON");
                    e.printStackTrace();
                }
            }
        }
        this.generateGroupKeys(attr, canonicalPath);
        if (this.groupKeys.isEmpty()) {
            LOGGER.debug("ZarrReader adding group keys from ZarrService");
            this.groupKeys.addAll(this.zarrService.getGroupKeys(canonicalPath));
        }
        List<String> orderedGroupKeys = this.reorderGroupKeys(this.groupKeys, omeSeriesOrder);
        for (String key : orderedGroupKeys) {
            attributes = this.zarrService.getGroupAttr(canonicalPath + File.separator + key);
            if (attributes == null || attributes.isEmpty()) continue;
            this.parseResolutionCount(zarrRootPath, key, attributes);
            this.parseLabels(zarrRootPath, attributes);
            this.parseImageLabels(zarrRootPath, attributes);
            ++attrIndex;
            if (!this.saveAnnotations()) continue;
            try {
                jsonAttr = ZarrUtils.toJson(attributes, (boolean)true);
                store.setXMLAnnotationValue(jsonAttr, attrIndex);
                xml_id = MetadataTools.createLSID((String)"Annotation", (int[])new int[]{attrIndex});
                store.setXMLAnnotationID(xml_id, attrIndex);
            }
            catch (JZarrException e) {
                LOGGER.warn("Failed to convert attributes to JSON");
                e.printStackTrace();
            }
        }
        this.generateArrayKeys(attr, canonicalPath);
        if (this.arrayPaths.isEmpty()) {
            LOGGER.debug("ZarrReader adding Array Keys from ZarrService");
            this.arrayPaths.addAll(this.zarrService.getArrayKeys(canonicalPath));
        }
        this.orderArrayPaths(zarrRootPath);
        if (this.saveAnnotations()) {
            for (String key : this.arrayPaths) {
                attributes = this.zarrService.getArrayAttr(zarrRootPath + File.separator + key);
                if (attributes == null || attributes.isEmpty()) continue;
                ++attrIndex;
                try {
                    jsonAttr = ZarrUtils.toJson(attributes, (boolean)true);
                    store.setXMLAnnotationValue(jsonAttr, attrIndex);
                    xml_id = MetadataTools.createLSID((String)"Annotation", (int[])new int[]{attrIndex});
                    store.setXMLAnnotationID(xml_id, attrIndex);
                }
                catch (JZarrException e) {
                    LOGGER.warn("Failed to convert attributes to JSON");
                    e.printStackTrace();
                }
            }
        }
        this.core.clear();
        int resolutionTotal = 0;
        HashMap<Integer, int[]> resShapes = new HashMap<Integer, int[]>();
        int pixelType = -1;
        for (i = 0; i < this.arrayPaths.size(); ++i) {
            int[] shape;
            int resolutionCount = 1;
            if (this.resCounts.get(this.arrayPaths.get(i)) != null) {
                resolutionCount = this.resCounts.get(this.arrayPaths.get(i));
            }
            int resolutionIndex = 0;
            if (this.resIndexes.get(this.arrayPaths.get(i)) != null) {
                resolutionIndex = this.resIndexes.get(this.arrayPaths.get(i));
            }
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            boolean openZarr = true;
            if (this.quickRead() && resShapes.containsKey(resolutionIndex) && !this.arrayPaths.get(i).toLowerCase().contains("label")) {
                openZarr = false;
            }
            if (this.hasFlattenedResolutions()) {
                this.setSeries(i, openZarr);
            } else {
                this.setSeries(this.coreIndexToSeries(i), openZarr);
                this.setResolution(resolutionIndex, openZarr);
                if (i == resolutionTotal + resolutionCount - 1) {
                    resolutionTotal += resolutionCount;
                }
            }
            if (openZarr) {
                LOGGER.debug("ZarrReader opening Zarr to get Shape");
                ms.pixelType = pixelType = this.zarrService.getPixelType();
                shape = this.zarrService.getShape();
                if (shape.length < 5) {
                    shape = this.get5DShape(shape);
                }
                resShapes.put(resolutionIndex, shape);
            } else {
                ms.pixelType = pixelType;
                shape = (int[])resShapes.get(resolutionIndex);
            }
            ms.sizeX = shape[4];
            ms.sizeY = shape[3];
            ms.sizeT = shape[0];
            ms.sizeZ = shape[2];
            ms.sizeC = shape[1];
            ArrayList<String> pathDimensions = this.pathArrayDimensions.get(this.arrayPaths.get(i));
            if (pathDimensions != null && !pathDimensions.isEmpty()) {
                ms.sizeX = shape[pathDimensions.indexOf("x")];
                ms.sizeY = shape[pathDimensions.indexOf("y")];
                ms.sizeT = shape[pathDimensions.indexOf("t")];
                ms.sizeZ = shape[pathDimensions.indexOf("z")];
                ms.sizeC = shape[pathDimensions.indexOf("c")];
                String newDimOrder = "";
                for (int d = 1; d < pathDimensions.size() + 1; ++d) {
                    newDimOrder = newDimOrder + pathDimensions.get(pathDimensions.size() - d).toUpperCase();
                }
                this.dimensionOrder = newDimOrder;
            }
            ms.dimensionOrder = this.dimensionOrder;
            ms.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            ms.littleEndian = this.zarrService.isLittleEndian();
            ms.rgb = false;
            ms.interleaved = false;
            ms.resolutionCount = resolutionCount;
        }
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (!this.planesPrePopulated ? 1 : 0) != 0);
        for (i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName(this.arrayPaths.get(this.seriesToCoreIndex(i)), i);
            store.setImageID(MetadataTools.createLSID((String)"Image", (int[])new int[]{i}), i);
        }
        this.parsePlate(attr, zarrRootPath, "", store);
        this.setSeries(0);
        LOGGER.debug("ZarrReader initialization complete");
    }

    private List<String> reorderGroupKeys(ArrayList<String> groupKeys, List<String> originalKeys) {
        if (originalKeys.isEmpty() || !groupKeys.containsAll(originalKeys)) {
            LOGGER.warn("Mismatch with group key paths and original OME-XML metadata, original ordering wont be maintained");
            return this.reorderGroupKeys(groupKeys);
        }
        ArrayList<String> groupKeysList = new ArrayList<String>();
        groupKeys.removeAll(originalKeys);
        groupKeysList.addAll(originalKeys);
        groupKeysList.addAll(groupKeys);
        return groupKeysList;
    }

    private List<String> reorderGroupKeys(ArrayList<String> groupKeys) {
        ArrayList<String> groupKeysList = new ArrayList<String>();
        groupKeysList.addAll(groupKeys);
        Collections.sort(groupKeysList, keyComparator);
        return groupKeysList;
    }

    private static boolean isInteger(String s) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!(i == 0 && s.charAt(i) == '-' ? s.length() == 1 : Character.digit(s.charAt(i), 10) < 0)) continue;
            return false;
        }
        return true;
    }

    private int[] get5DShape(int[] originalShape) {
        int[] shape = new int[]{1, 1, 1, 1, 1};
        int shapeIndex = 4;
        for (int s = originalShape.length - 1; s >= 0; --s) {
            shape[shapeIndex] = originalShape[s];
            --shapeIndex;
        }
        return shape;
    }

    private static int[] getOriginalShape(int[] shape5D, int size) {
        int[] shape = new int[size];
        int shape5DIndex = 4;
        for (int s = shape.length - 1; s >= 0; --s) {
            shape[s] = shape5D[shape5DIndex];
            --shape5DIndex;
        }
        return shape;
    }

    public void reopenFile() throws IOException {
        try {
            String canonicalPath = new Location(this.currentId).getCanonicalPath();
            this.initializeZarrService();
        }
        catch (FormatException e) {
            throw new IOException(e);
        }
    }

    protected void initializeZarrService() throws IOException, FormatException {
        this.zarrService = new JZarrServiceImpl(this.altStore());
        this.openZarr();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        block12: {
            int bpp;
            boolean little;
            Object image;
            block15: {
                block14: {
                    block13: {
                        block11: {
                            FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
                            this.openZarr();
                            int[] coordinates = this.getZCTCoords(no);
                            int[] shape = new int[]{1, 1, 1, h, w};
                            int zarrArrayShapeSize = this.zarrService.getShape().length;
                            if (zarrArrayShapeSize < 5) {
                                shape = ZarrReader.getOriginalShape(shape, zarrArrayShapeSize);
                            }
                            int zIndex = 4 - this.dimensionOrder.indexOf("Z");
                            int cIndex = 4 - this.dimensionOrder.indexOf("C");
                            int tIndex = 4 - this.dimensionOrder.indexOf("T");
                            int[] offsets = new int[]{1, 1, 1, y, x};
                            offsets[zIndex] = coordinates[0];
                            offsets[cIndex] = coordinates[1];
                            offsets[tIndex] = coordinates[2];
                            if (zarrArrayShapeSize < 5) {
                                offsets = ZarrReader.getOriginalShape(offsets, zarrArrayShapeSize);
                            }
                            image = this.zarrService.readBytes(shape, offsets);
                            little = this.zarrService.isLittleEndian();
                            bpp = FormatTools.getBytesPerPixel((int)this.zarrService.getPixelType());
                            if (!(image instanceof byte[])) break block11;
                            byte[] data = (byte[])image;
                            for (int i = 0; i < data.length; ++i) {
                                DataTools.unpackBytes((long)data[i], (byte[])buf, (int)i, (int)1, (boolean)little);
                            }
                            break block12;
                        }
                        if (!(image instanceof short[])) break block13;
                        short[] data = (short[])image;
                        for (int row = 0; row < h; ++row) {
                            int base = row * w * bpp;
                            for (int i = 0; i < w; ++i) {
                                DataTools.unpackBytes((long)data[row * w + i], (byte[])buf, (int)(base + 2 * i), (int)2, (boolean)little);
                            }
                        }
                        break block12;
                    }
                    if (!(image instanceof int[])) break block14;
                    int[] data = (int[])image;
                    for (int row = 0; row < h; ++row) {
                        int base = row * w * bpp;
                        for (int i = 0; i < w; ++i) {
                            DataTools.unpackBytes((long)data[row * w + i], (byte[])buf, (int)(base + 4 * i), (int)4, (boolean)little);
                        }
                    }
                    break block12;
                }
                if (!(image instanceof float[])) break block15;
                float[] data = (float[])image;
                for (int row = 0; row < h; ++row) {
                    int base = row * w * bpp;
                    for (int i = 0; i < w; ++i) {
                        int value = Float.floatToIntBits(data[row * w + i]);
                        DataTools.unpackBytes((long)value, (byte[])buf, (int)(base + 4 * i), (int)4, (boolean)little);
                    }
                }
                break block12;
            }
            if (!(image instanceof double[])) break block12;
            double[] data = (double[])image;
            for (int row = 0; row < h; ++row) {
                int base = row * w * bpp;
                for (int i = 0; i < w; ++i) {
                    long value = Double.doubleToLongBits(data[row * w + i]);
                    DataTools.unpackBytes((long)value, (byte[])buf, (int)(base + 8 * i), (int)8, (boolean)little);
                }
            }
        }
        return buf;
    }

    public void setSeries(int no) {
        this.setSeries(no, false);
    }

    public void setSeries(int no, boolean openZarr) {
        super.setSeries(no);
        if (openZarr) {
            this.openZarr();
        }
    }

    public void setResolution(int no) {
        this.setResolution(no, false);
    }

    public void setResolution(int no, boolean openZarr) {
        super.setResolution(no);
        if (openZarr) {
            this.openZarr();
        }
    }

    private void openZarr() {
        try {
            if (this.currentId != null && this.zarrService != null) {
                String zarrRootPath;
                String newZarrPath = zarrRootPath = this.currentId.substring(0, this.currentId.indexOf(".zarr") + 5);
                if (this.arrayPaths != null && !this.arrayPaths.isEmpty()) {
                    int seriesIndex = this.seriesToCoreIndex(this.series);
                    if (!this.hasFlattenedResolutions()) {
                        seriesIndex += this.resolution;
                    }
                    if (seriesIndex != this.currentOpenZarr) {
                        newZarrPath = newZarrPath + File.separator + this.arrayPaths.get(seriesIndex);
                        String canonicalPath = new Location(newZarrPath).getCanonicalPath();
                        LOGGER.debug("Opening zarr for series {} at path: {}", (Object)seriesIndex, (Object)canonicalPath);
                        this.zarrService.open(canonicalPath);
                        this.currentOpenZarr = seriesIndex;
                    }
                }
            }
        }
        catch (IOException | FormatException e) {
            e.printStackTrace();
        }
    }

    private void orderArrayPaths(String root) {
        for (int i = 0; i < this.resSeries.size(); ++i) {
            for (String arrayPath : this.resSeries.get(i)) {
                this.arrayPaths.remove(arrayPath);
            }
            for (String arrayPath : this.resSeries.get(i)) {
                if (!this.includeLabels() && arrayPath.toLowerCase().contains("labels")) continue;
                this.arrayPaths.add(arrayPath);
            }
        }
    }

    private void parseResolutionCount(String root, String key, Map<String, Object> attr) throws IOException, FormatException {
        ArrayList multiscales = (ArrayList)attr.get("multiscales");
        if (multiscales != null) {
            for (int x = 0; x < multiscales.size(); ++x) {
                Map datasets = (Map)multiscales.get(x);
                List multiscaleAxes = (List)datasets.get("axes");
                ArrayList<String> pathDimensions = new ArrayList<String>();
                if (multiscaleAxes != null) {
                    for (int i = 0; i < multiscaleAxes.size(); ++i) {
                        Object axis;
                        if (multiscaleAxes.get(i) instanceof String) {
                            axis = (String)multiscaleAxes.get(i);
                            this.addGlobalMeta(MetadataTools.createLSID((String)"Axis", (int[])new int[]{x, i}), axis);
                            pathDimensions.add(((String)axis).toLowerCase());
                            continue;
                        }
                        if (!(multiscaleAxes.get(i) instanceof HashMap)) continue;
                        axis = (HashMap)multiscaleAxes.get(i);
                        String type = (String)((HashMap)axis).get("type");
                        this.addGlobalMeta(MetadataTools.createLSID((String)"Axis type", (int[])new int[]{x, i}), type);
                        String name = (String)((HashMap)axis).get("name");
                        this.addGlobalMeta(MetadataTools.createLSID((String)"Axis name", (int[])new int[]{x, i}), name);
                        String units = (String)((HashMap)axis).get("units");
                        this.addGlobalMeta(MetadataTools.createLSID((String)"Axis units", (int[])new int[]{x, i}), units);
                        pathDimensions.add(name.toLowerCase());
                    }
                    if (pathDimensions.size() < 5) {
                        if (!pathDimensions.contains("x")) {
                            pathDimensions.add(0, "x");
                        }
                        if (!pathDimensions.contains("y")) {
                            pathDimensions.add(0, "y");
                        }
                        if (!pathDimensions.contains("c")) {
                            pathDimensions.add(0, "c");
                        }
                        if (!pathDimensions.contains("t")) {
                            pathDimensions.add(0, "t");
                        }
                        if (!pathDimensions.contains("z")) {
                            pathDimensions.add(0, "z");
                        }
                    }
                }
                ArrayList multiscalePaths = (ArrayList)datasets.get("datasets");
                this.resSeries.put(this.resCounts.size(), new ArrayList());
                for (int i = 0; i < multiscalePaths.size(); ++i) {
                    Map multiScale = (Map)multiscalePaths.get(i);
                    String scalePath = (String)multiScale.get("path");
                    int numRes = multiscalePaths.size();
                    if (i == 0) {
                        this.resCounts.put(key.isEmpty() ? scalePath : key + File.separator + scalePath, numRes);
                        this.uniqueResCounts.add(numRes);
                    }
                    this.resIndexes.put(key.isEmpty() ? scalePath : key + File.separator + scalePath, i);
                    ArrayList<String> list = this.resSeries.get(this.resCounts.size() - 1);
                    list.add(key.isEmpty() ? scalePath : key + File.separator + scalePath);
                    this.resSeries.put(this.resCounts.size() - 1, list);
                    this.pathArrayDimensions.put(key.isEmpty() ? scalePath : key + File.separator + scalePath, pathDimensions);
                }
                List coordinateTransformations = (List)datasets.get("coordinateTransformations");
                if (coordinateTransformations == null) continue;
                for (int i = 0; i < coordinateTransformations.size(); ++i) {
                    ArrayList translation;
                    HashMap transformation = (HashMap)coordinateTransformations.get(i);
                    String type = (String)transformation.get("type");
                    this.addGlobalMeta(MetadataTools.createLSID((String)"Coordinate Transformation type", (int[])new int[]{x, i}), type);
                    ArrayList scale = (ArrayList)transformation.get("scale");
                    if (scale != null) {
                        this.addGlobalMeta(MetadataTools.createLSID((String)"Coordinate Transformation scale", (int[])new int[]{x, i}), scale);
                    }
                    if ((translation = (ArrayList)transformation.get("translation")) == null) continue;
                    this.addGlobalMeta(MetadataTools.createLSID((String)"Coordinate Transformation translation", (int[])new int[]{x, i}), translation);
                }
            }
        }
    }

    private void generateArrayKeys(Map<String, Object> attr, String canonicalPath) {
        Map plates;
        if (this.uniqueResCounts.size() != 1) {
            LOGGER.debug("Cannout automatically generate ArrayKeys as resolution counts differ");
        }
        if ((plates = (Map)attr.get("plate")) != null) {
            ArrayList columns = (ArrayList)plates.get("columns");
            ArrayList rows = (ArrayList)plates.get("rows");
            Integer fieldCount = (Integer)plates.get("field_count");
            for (Object row : rows) {
                String rowName = (String)((Map)row).get("name");
                for (Object column : columns) {
                    String columnName = (String)((Map)column).get("name");
                    for (int i = 0; i < fieldCount; ++i) {
                        int resolutionCount = (Integer)this.uniqueResCounts.toArray()[0];
                        for (int j = 0; j < resolutionCount; ++j) {
                            String key = rowName + File.separator + columnName + File.separator + i + File.separator + j;
                            if (Files.isDirectory(Paths.get(canonicalPath + File.separator + key, new String[0]), new LinkOption[0])) {
                                this.arrayPaths.add(rowName + File.separator + columnName + File.separator + i + File.separator + j);
                                continue;
                            }
                            LOGGER.debug("Skipping array path as sparse data: {}", (Object)key);
                        }
                    }
                }
            }
        }
    }

    private void generateGroupKeys(Map<String, Object> attr, String canonicalPath) {
        Map plates = (Map)attr.get("plate");
        if (plates != null) {
            ArrayList columns = (ArrayList)plates.get("columns");
            ArrayList rows = (ArrayList)plates.get("rows");
            Integer fieldCount = (Integer)plates.get("field_count");
            for (Object row : rows) {
                String rowName = (String)((Map)row).get("name");
                if (Files.isDirectory(Paths.get(canonicalPath + File.separator + rowName, new String[0]), new LinkOption[0])) {
                    this.groupKeys.add(rowName);
                } else {
                    LOGGER.debug("Skipping group key as sparse data: {}", (Object)rowName);
                }
                for (Object column : columns) {
                    String columnName = (String)((Map)column).get("name");
                    String columnKey = rowName + File.separator + columnName;
                    if (Files.isDirectory(Paths.get(canonicalPath + File.separator + columnKey, new String[0]), new LinkOption[0])) {
                        this.groupKeys.add(columnKey);
                    } else {
                        LOGGER.debug("Skipping group key as sparse data: {}", (Object)columnKey);
                    }
                    for (int i = 0; i < fieldCount; ++i) {
                        String key = rowName + File.separator + columnName + File.separator + i;
                        if (Files.isDirectory(Paths.get(canonicalPath + File.separator + key, new String[0]), new LinkOption[0])) {
                            this.groupKeys.add(key);
                            continue;
                        }
                        LOGGER.debug("Skipping group key as sparse data: {}", (Object)key);
                    }
                }
            }
        }
    }

    private void parsePlate(Map<String, Object> attr, String root, String key, MetadataStore store) throws IOException, FormatException {
        Map plates = (Map)attr.get("plate");
        if (plates != null) {
            ArrayList columns = (ArrayList)plates.get("columns");
            ArrayList rows = (ArrayList)plates.get("rows");
            ArrayList wells = (ArrayList)plates.get("wells");
            ArrayList acquisitions = (ArrayList)plates.get("acquisitions");
            String plateName = (String)plates.get("name");
            Integer fieldCount = (Integer)plates.get("field_count");
            String plate_id = MetadataTools.createLSID((String)"Plate", (int[])new int[]{0});
            store.setPlateID(plate_id, 0);
            store.setPlateName(plateName, 0);
            HashMap<Integer, Integer> acqIdsIndexMap = new HashMap<Integer, Integer>();
            if (acquisitions != null) {
                for (int a = 0; a < acquisitions.size(); ++a) {
                    Map acquistion = (Map)acquisitions.get(a);
                    Integer acqId = (Integer)acquistion.get("id");
                    String acqName = (String)acquistion.get("name");
                    String acqDescription = (String)acquistion.get("description");
                    Integer acqStartTime = (Integer)acquistion.get("starttime");
                    Integer acqEndTime = (Integer)acquistion.get("endtime");
                    Integer maximumfieldcount = (Integer)acquistion.get("maximumfieldcount");
                    acqIdsIndexMap.put(acqId, a);
                    store.setPlateAcquisitionID(MetadataTools.createLSID((String)"PlateAcquisition", (int[])new int[]{0, acqId}), 0, a);
                    if (acqName != null) {
                        store.setPlateAcquisitionName(acqName, 0, a);
                    }
                    if (acqDescription != null) {
                        store.setPlateAcquisitionDescription(acqDescription, 0, a);
                    }
                    if (maximumfieldcount != null) {
                        store.setPlateAcquisitionMaximumFieldCount(new PositiveInteger(maximumfieldcount), 0, a);
                    }
                    if (acqStartTime != null) {
                        store.setPlateAcquisitionStartTime(new Timestamp(acqStartTime.toString()), 0, a);
                    }
                    if (acqEndTime == null) continue;
                    store.setPlateAcquisitionEndTime(new Timestamp(acqEndTime.toString()), 0, a);
                }
            }
            this.wellCount = rows.size() * columns.size();
            for (int r = 0; r < rows.size(); ++r) {
                for (int c = 0; c < columns.size(); ++c) {
                    int wellIndex = r * columns.size() + c;
                    String well_id = MetadataTools.createLSID((String)"Well", (int[])new int[]{0, wellIndex});
                    store.setWellID(well_id, 0, wellIndex);
                    store.setWellRow(new NonNegativeInteger(Integer.valueOf(r)), 0, wellIndex);
                    store.setWellColumn(new NonNegativeInteger(Integer.valueOf(c)), 0, wellIndex);
                }
            }
            for (int w = 0; w < wells.size(); ++w) {
                Map well = (Map)wells.get(w);
                String wellPath = (String)well.get("path");
                Integer wellColIndex = (Integer)well.get("column_index");
                Integer wellRowIndex = (Integer)well.get("row_index");
                if (wellColIndex == null && wellRowIndex == null) {
                    wellColIndex = (Integer)well.get("columnIndex");
                    wellRowIndex = (Integer)well.get("rowIndex");
                }
                if (wellColIndex == null || wellRowIndex == null) {
                    String[] parts = wellPath.split("/");
                    String wellRow = parts[parts.length - 2];
                    String wellCol = parts[parts.length - 1];
                    wellRowIndex = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(wellRow.toUpperCase());
                    if (wellRowIndex == -1) {
                        wellRowIndex = Integer.parseInt(wellRow);
                    }
                    if ((wellColIndex = Integer.valueOf("ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(wellCol.toUpperCase()))) == -1) {
                        wellColIndex = Integer.parseInt(wellCol);
                    }
                }
                int wellIndex = wellRowIndex * columns.size() + wellColIndex;
                store.setWellExternalIdentifier(wellPath, 0, wellIndex);
                this.parseWells(root, wellPath, store, 0, wellIndex, acqIdsIndexMap);
            }
        }
    }

    private void parseWells(String root, String key, MetadataStore store, int plateIndex, int wellIndex, HashMap<Integer, Integer> acqIdsIndexMap) throws IOException, FormatException {
        String path = key.isEmpty() ? root : root + File.separator + key;
        String canonicalPath = new Location(path).getCanonicalPath();
        Map<String, Object> attr = this.zarrService.getGroupAttr(canonicalPath);
        Map wells = (Map)attr.get("well");
        if (wells != null) {
            ArrayList images = (ArrayList)wells.get("images");
            for (int i = 0; i < images.size(); ++i) {
                Map image = (Map)images.get(i);
                String imagePath = (String)image.get("path");
                Integer acquisition = (Integer)image.get("acquisition");
                if (acqIdsIndexMap.containsKey(acquisition)) {
                    acquisition = acqIdsIndexMap.get(acquisition);
                }
                String site_id = MetadataTools.createLSID((String)"WellSample", (int[])new int[]{plateIndex, wellIndex, i});
                store.setWellSampleID(site_id, plateIndex, wellIndex, i);
                store.setWellSampleIndex(new NonNegativeInteger(Integer.valueOf(i)), plateIndex, wellIndex, i);
                String imageRefPath = "" + i;
                if (key != null && !key.isEmpty()) {
                    imageRefPath = key + File.separator + i;
                }
                if (this.resCounts.containsKey(imageRefPath + File.separator + "0")) {
                    imageRefPath = imageRefPath + File.separator + "0";
                }
                String imageID = MetadataTools.createLSID((String)"Image", (int[])new int[]{this.coreIndexToSeries(this.arrayPaths.indexOf(imageRefPath))});
                store.setWellSampleImageRef(imageID, plateIndex, wellIndex, i);
                if (acquisition != null && acquisition >= 0) {
                    store.setPlateAcquisitionWellSampleRef(site_id, plateIndex, acquisition.intValue(), i);
                }
                ++this.wellSamplesCount;
            }
        }
    }

    private void parseLabels(String root, Map<String, Object> attr) throws IOException, FormatException {
        ArrayList labels = (ArrayList)attr.get("labels");
        if (labels != null) {
            for (int l = 0; l < labels.size(); ++l) {
                String string = (String)labels.get(l);
            }
        }
    }

    private void parseImageLabels(String root, Map<String, Object> attr) throws IOException, FormatException {
        ArrayList sources;
        Object object;
        Map imageLabel = (Map)attr.get("image-label");
        if (imageLabel != null) {
            ArrayList properties;
            String version = (String)imageLabel.get("version");
            ArrayList colors = (ArrayList)imageLabel.get("colors");
            if (colors == null) {
                colors = (ArrayList)imageLabel.get("color");
            }
            if (colors != null) {
                for (int c = 0; c < colors.size(); ++c) {
                    Map color = (Map)colors.get(c);
                    Integer labelValue = (Integer)color.get("label-value");
                    object = (ArrayList)color.get("rgba");
                }
            }
            if ((properties = (ArrayList)imageLabel.get("properties")) != null) {
                for (int p = 0; p < properties.size(); ++p) {
                    Map prop = (Map)properties.get(p);
                    Integer labelValue = (Integer)prop.get("label-value");
                    Number area = (Number)prop.get("area (pixels)");
                    String string = (String)prop.get("class");
                }
            }
        }
        if ((sources = (ArrayList)attr.get("source")) != null) {
            for (int s = 0; s < sources.size(); ++s) {
                Map source = (Map)sources.get(s);
                ArrayList imagePaths = (ArrayList)source.get("image");
                for (int p = 0; p < imagePaths.size(); ++p) {
                    object = (String)imagePaths.get(p);
                }
            }
        }
    }

    public void parseOmeroMetadata(Map<String, Object> attr) throws IOException, FormatException {
        Map omeroMetadata = (Map)attr.get("omero");
        if (omeroMetadata != null) {
            Integer id = (Integer)omeroMetadata.get("id");
            String name = (String)omeroMetadata.get("name");
            String version = (String)omeroMetadata.get("version");
            ArrayList channels = (ArrayList)omeroMetadata.get("channels");
            for (int i = 0; i < channels.size(); ++i) {
                Map channel = (Map)channels.get(i);
                Boolean channelActive = (Boolean)channel.get("active");
                Number channelCoefficient = (Number)channel.get("coefficient");
                String channelColor = (String)channel.get("color");
                String channelFamily = (String)channel.get("family");
                Boolean channelInverted = (Boolean)channel.get("inverted");
                String channelLabel = (String)channel.get("label");
                Map window = (Map)channel.get("window");
                if (window == null) continue;
                Number windowStart = this.getDouble(window, "start");
                Number windowEnd = this.getDouble(window, "end");
                Number windowMin = this.getDouble(window, "min");
                Number number = this.getDouble(window, "max");
            }
            Map rdefs = (Map)omeroMetadata.get("rdefs");
            if (rdefs != null) {
                Integer defaultT = (Integer)rdefs.get("defaultT");
                Integer defaultZ = (Integer)rdefs.get("defaultZ");
                String string = (String)rdefs.get("model");
            }
        }
    }

    private void parseOMEXML(Location omeMetaFile, MetadataStore store, ArrayList<String> origSeries) throws IOException, FormatException {
        Document omeDocument = null;
        try (RandomAccessInputStream measurement = new RandomAccessInputStream(omeMetaFile.getAbsolutePath());){
            try {
                omeDocument = XMLTools.parseDOM((InputStream)measurement);
            }
            catch (ParserConfigurationException e) {
                throw new IOException(e);
            }
            catch (SAXException e) {
                throw new IOException(e);
            }
        }
        omeDocument.getDocumentElement().normalize();
        OMEXMLService service = null;
        String xml = null;
        try {
            xml = XMLTools.getXML((Document)omeDocument);
        }
        catch (TransformerException e2) {
            LOGGER.debug("", (Throwable)e2);
        }
        OMEXMLMetadata omexmlMeta = null;
        try {
            Hashtable originalMetadata;
            service = (OMEXMLService)new ServiceFactory().getInstance(OMEXMLService.class);
            omexmlMeta = service.createOMEXMLMetadata(xml);
            if (this.saveAnnotations() && (originalMetadata = service.getOriginalMetadata(omexmlMeta)) != null) {
                this.metadata = originalMetadata;
            }
            this.planesPrePopulated = true;
        }
        catch (NullPointerException | DependencyException | ServiceException e1) {
            LOGGER.debug("", e1);
        }
        int numDatasets = omexmlMeta.getImageCount();
        HashMap<String, String> imageRefPaths = new HashMap<String, String>();
        for (int plateIndex = 0; plateIndex < omexmlMeta.getPlateCount(); ++plateIndex) {
            for (int wellIndex = 0; wellIndex < omexmlMeta.getWellCount(plateIndex); ++wellIndex) {
                NonNegativeInteger col = omexmlMeta.getWellColumn(plateIndex, wellIndex);
                NonNegativeInteger row = omexmlMeta.getWellRow(plateIndex, wellIndex);
                String rowLetter = ZarrReader.getRowString((Integer)row.getValue());
                for (int wellSampleIndex = 0; wellSampleIndex < omexmlMeta.getWellSampleCount(plateIndex, wellIndex); ++wellSampleIndex) {
                    String expectedPath = rowLetter + File.separator + ((Integer)col.getValue() + 1) + File.separator + wellSampleIndex;
                    String imageRef = omexmlMeta.getWellSampleImageRef(plateIndex, wellIndex, wellSampleIndex);
                    imageRefPaths.put(imageRef, expectedPath);
                }
            }
        }
        int oldSeries = this.getSeries();
        this.core.clear();
        for (int i = 0; i < numDatasets; ++i) {
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            this.setSeries(i);
            Integer w = (Integer)omexmlMeta.getPixelsSizeX(i).getValue();
            Integer h = (Integer)omexmlMeta.getPixelsSizeY(i).getValue();
            Integer t = (Integer)omexmlMeta.getPixelsSizeT(i).getValue();
            Integer z = (Integer)omexmlMeta.getPixelsSizeZ(i).getValue();
            Integer c = (Integer)omexmlMeta.getPixelsSizeC(i).getValue();
            if (w == null || h == null || t == null || z == null | c == null) {
                throw new FormatException("Image dimensions not found");
            }
            String imageId = omexmlMeta.getImageID(i);
            if (!imageRefPaths.isEmpty() && imageRefPaths.containsKey(imageId)) {
                String expectedZarrPath = (String)imageRefPaths.get(imageId);
                origSeries.add(expectedZarrPath);
            }
            Boolean endian = this.zarrService.isLittleEndian();
            String pixType = omexmlMeta.getPixelsType(i).toString();
            ms.dimensionOrder = omexmlMeta.getPixelsDimensionOrder(i).toString();
            ms.sizeX = w;
            ms.sizeY = h;
            ms.sizeT = t;
            ms.sizeZ = z;
            ms.sizeC = c;
            ms.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            ms.littleEndian = endian == null ? false : endian == false;
            ms.rgb = false;
            ms.interleaved = false;
            ms.indexed = false;
            ms.falseColor = true;
            ms.pixelType = FormatTools.pixelTypeFromString((String)pixType);
            ms.orderCertain = true;
            if (omexmlMeta.getPixelsSignificantBits(i) == null) continue;
            ms.bitsPerPixel = (Integer)omexmlMeta.getPixelsSignificantBits(i).getValue();
        }
        this.setSeries(oldSeries);
        OME root = (OME)omexmlMeta.getRoot();
        if (!this.saveAnnotations()) {
            root.setStructuredAnnotations(null);
            omexmlMeta.setRoot((MetadataRoot)root);
        } else {
            StructuredAnnotations annotations = root.getStructuredAnnotations();
            if (annotations != null) {
                int numMapAnnotations = annotations.sizeOfMapAnnotationList();
                int index = 0;
                for (int i = 0; i < numMapAnnotations; ++i) {
                    MapAnnotation mapAnnotation = annotations.getMapAnnotation(index);
                    String namespace = mapAnnotation.getNamespace();
                    if (namespace != null && namespace.toLowerCase().contains("pyramidresolution")) {
                        annotations.removeMapAnnotation(mapAnnotation);
                        continue;
                    }
                    ++index;
                }
                root.setStructuredAnnotations(annotations);
                omexmlMeta.setRoot((MetadataRoot)root);
            }
        }
        int screenSize = root.sizeOfScreenList();
        for (int i = 0; i < screenSize; ++i) {
            root.removeScreen(root.getScreen(i));
        }
        int plateSize = root.sizeOfPlateList();
        for (int i = 0; i < plateSize; ++i) {
            root.removePlate(root.getPlate(i));
        }
        omexmlMeta.setRoot((MetadataRoot)root);
        MetadataConverter.convertMetadata((MetadataRetrieve)omexmlMeta, (ome.xml.meta.MetadataStore)store);
    }

    public static String getRowString(int rowIndex) {
        StringBuilder sb = new StringBuilder();
        if (rowIndex == 0) {
            sb.append('A');
        }
        while (rowIndex > 0) {
            sb.append((char)(65 + rowIndex % 26));
            rowIndex /= 26;
        }
        return sb.reverse().toString();
    }

    private Number getDouble(Map<String, Object> src, String key) {
        Number val = (Number)src.get(key);
        if (val == null) {
            return null;
        }
        return val.doubleValue();
    }

    public String[] getUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        String zarrRootPath = this.currentId.substring(0, this.currentId.indexOf(".zarr") + 5);
        int rootPathLength = zarrRootPath.length();
        ArrayList usedFiles = new ArrayList();
        this.reloadOptionsFile(zarrRootPath);
        boolean skipPixels = noPixels || !this.listPixels() || !this.systemEnvListPixels();
        boolean includeLabels = this.includeLabels();
        try (Stream<Path> paths = Files.walk(Paths.get(zarrRootPath, new String[0]), FileVisitOption.FOLLOW_LINKS);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                if (!skipPixels && includeLabels || !skipPixels && !includeLabels && path.toString().toLowerCase().lastIndexOf("labels") < rootPathLength || skipPixels && includeLabels && (path.endsWith(".zgroup") || path.endsWith(".zattrs") || path.endsWith(".xml")) || skipPixels && !includeLabels && path.toString().toLowerCase().lastIndexOf("labels") < rootPathLength && (path.endsWith(".zgroup") || path.endsWith(".zattrs") || path.endsWith(".xml"))) {
                    usedFiles.add(path.toFile().getAbsolutePath());
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] fileArr = new String[usedFiles.size()];
        fileArr = usedFiles.toArray(fileArr);
        return fileArr;
    }

    public String[] getDomains() {
        String[] stringArray;
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        if (this.hasSPW) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "High-Content Screening (HCS)";
        } else {
            stringArray = FormatTools.NON_SPECIAL_DOMAINS;
        }
        return stringArray;
    }

    protected ArrayList<String> getAvailableOptions() {
        ArrayList optionsList = super.getAvailableOptions();
        optionsList.add(SAVE_ANNOTATIONS_KEY);
        optionsList.add(LIST_PIXELS_KEY);
        optionsList.add(QUICK_READ_KEY);
        optionsList.add(INCLUDE_LABELS_KEY);
        optionsList.add(ALT_STORE_KEY);
        return optionsList;
    }

    public boolean saveAnnotations() {
        MetadataOptions options = this.getMetadataOptions();
        if (options instanceof DynamicMetadataOptions) {
            return ((DynamicMetadataOptions)options).getBoolean(SAVE_ANNOTATIONS_KEY, Boolean.valueOf(false));
        }
        return false;
    }

    public boolean listPixels() {
        MetadataOptions options = this.getMetadataOptions();
        if (options instanceof DynamicMetadataOptions) {
            return ((DynamicMetadataOptions)options).getBoolean(LIST_PIXELS_KEY, Boolean.valueOf(true));
        }
        return true;
    }

    public boolean quickRead() {
        MetadataOptions options = this.getMetadataOptions();
        if (options instanceof DynamicMetadataOptions) {
            return ((DynamicMetadataOptions)options).getBoolean(QUICK_READ_KEY, Boolean.valueOf(false));
        }
        return false;
    }

    public boolean includeLabels() {
        MetadataOptions options = this.getMetadataOptions();
        if (options instanceof DynamicMetadataOptions) {
            return ((DynamicMetadataOptions)options).getBoolean(INCLUDE_LABELS_KEY, Boolean.valueOf(false));
        }
        return false;
    }

    public String altStore() {
        MetadataOptions options = this.getMetadataOptions();
        if (options instanceof DynamicMetadataOptions) {
            return ((DynamicMetadataOptions)options).get(ALT_STORE_KEY, ALT_STORE_DEFAULT);
        }
        return ALT_STORE_DEFAULT;
    }

    private boolean systemEnvListPixels() {
        String value = System.getenv(LIST_PIXELS_ENV_KEY);
        if (value != null && value.equalsIgnoreCase("true")) {
            return true;
        }
        return value == null || !value.toLowerCase().equals("false");
    }

    private void reloadOptionsFile(String id) {
        MetadataOptions options;
        String optionsFile = DynamicMetadataOptions.getMetadataOptionsFile((String)id);
        if (optionsFile != null && (options = this.getMetadataOptions()) != null && options instanceof DynamicMetadataOptions) {
            try {
                ((DynamicMetadataOptions)options).loadOptions(optionsFile, this.getAvailableOptions());
            }
            catch (Exception e) {
                LOGGER.warn("Exception while attempting to read metadata options file", (Throwable)e);
            }
        }
    }
}

