/*
 * Decompiled with CFR 0.152.
 */
package com.bc.zarr;

import com.bc.zarr.ArrayParams;
import com.bc.zarr.Compressor;
import com.bc.zarr.CompressorFactory;
import com.bc.zarr.DataType;
import com.bc.zarr.DimensionSeparator;
import com.bc.zarr.ZarrHeader;
import com.bc.zarr.ZarrPath;
import com.bc.zarr.ZarrUtils;
import com.bc.zarr.chunk.ChunkReaderWriter;
import com.bc.zarr.storage.FileSystemStore;
import com.bc.zarr.storage.InMemoryStore;
import com.bc.zarr.storage.Store;
import com.bc.zarr.ucar.NetCDF_Util;
import com.bc.zarr.ucar.PartialDataCopier;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;

public class ZarrArray {
    private final int[] _shape;
    private final int[] _chunks;
    private final ZarrPath relativePath;
    private final ChunkReaderWriter _chunkReaderWriter;
    private final Map<String, String> _chunkFilenames;
    private final DataType _dataType;
    private final Number _fillValue;
    private final Compressor _compressor;
    private final Store _store;
    private final ByteOrder _byteOrder;
    private final DimensionSeparator _separator;

    private ZarrArray(ZarrPath relativePath, int[] shape, int[] chunkShape, DataType dataType, ByteOrder order, Number fillValue, Compressor compressor, DimensionSeparator separator, Store store) {
        this.relativePath = relativePath;
        this._shape = shape;
        this._chunks = chunkShape;
        this._dataType = dataType;
        this._fillValue = fillValue;
        this._compressor = compressor == null ? CompressorFactory.nullCompressor : compressor;
        this._store = store;
        this._chunkReaderWriter = ChunkReaderWriter.create(this._compressor, this._dataType, order, this._chunks, this._fillValue, this._store);
        this._chunkFilenames = new HashMap<String, String>();
        this._byteOrder = order;
        if (separator == null) {
            throw new IllegalArgumentException("separator must not be null");
        }
        this._separator = separator;
    }

    public static ZarrArray open(String path) throws IOException {
        return ZarrArray.open(Paths.get(path, new String[0]));
    }

    public static ZarrArray open(Path fileSystemPath) throws IOException {
        return ZarrArray.open(new FileSystemStore(fileSystemPath));
    }

    public static ZarrArray open(Store store) throws IOException {
        return ZarrArray.open(new ZarrPath(""), store);
    }

    public static ZarrArray open(ZarrPath relativePath, Store store) throws IOException {
        ZarrPath zarrHeaderPath = relativePath.resolve(".zarray");
        try (InputStream storageStream = store.getInputStream(zarrHeaderPath.storeKey);){
            ZarrArray zarrArray;
            if (storageStream == null) {
                throw new IOException("'.zarray' expected but is not readable or missing in store.");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(storageStream));){
                boolean nestedChunks;
                DimensionSeparator separator;
                ZarrHeader header = ZarrUtils.fromJson(reader, ZarrHeader.class);
                int[] shape = header.getShape();
                int[] chunks = header.getChunks();
                DataType dataType = header.getRawDataType();
                ByteOrder byteOrder = header.getByteOrder();
                Number fillValue = header.getFill_value();
                Compressor compressor = header.getCompressor();
                if (compressor == null) {
                    compressor = CompressorFactory.nullCompressor;
                }
                if ((separator = header.getDimensionSeparator()) == null && chunks.length > 1 && (nestedChunks = ZarrArray.findNestedChunks(relativePath, store, chunks))) {
                    separator = DimensionSeparator.SLASH;
                }
                if (separator == null) {
                    separator = DimensionSeparator.DOT;
                }
                zarrArray = new ZarrArray(relativePath, shape, chunks, dataType, byteOrder, fillValue, compressor, separator, store);
            }
            return zarrArray;
        }
    }

    public static ZarrArray create(ArrayParams arrayParams) throws IOException {
        return ZarrArray.create(new InMemoryStore(), arrayParams);
    }

    public static ZarrArray create(ArrayParams arrayParams, Map<String, Object> attributes) throws IOException {
        return ZarrArray.create(new InMemoryStore(), arrayParams, attributes);
    }

    public static ZarrArray create(String path, ArrayParams params) throws IOException {
        return ZarrArray.create(path, params, null);
    }

    public static ZarrArray create(String path, ArrayParams params, Map<String, Object> attributes) throws IOException {
        Path fsPath = Paths.get(path, new String[0]);
        return ZarrArray.create(fsPath, params, attributes);
    }

    public static ZarrArray create(Path fsPath, ArrayParams params) throws IOException {
        return ZarrArray.create(fsPath, params, null);
    }

    public static ZarrArray create(Path fsPath, ArrayParams params, Map<String, Object> attributes) throws IOException {
        FileSystemStore store = new FileSystemStore(fsPath);
        return ZarrArray.create(store, params, attributes);
    }

    public static ZarrArray create(Store store, ArrayParams params) throws IOException {
        return ZarrArray.create(store, params, null);
    }

    public static ZarrArray create(Store store, ArrayParams params, Map<String, Object> attributes) throws IOException {
        return ZarrArray.create(new ZarrPath(""), store, params, attributes);
    }

    public static ZarrArray create(ZarrPath relativePath, Store store, ArrayParams params) throws IOException {
        return ZarrArray.create(relativePath, store, params, null);
    }

    public static ZarrArray create(ZarrPath relativePath, Store store, ArrayParams arrayParams, Map<String, Object> attributes) throws IOException {
        store.delete(relativePath.storeKey);
        ArrayParams.Params params = arrayParams.build();
        int[] shape = params.getShape();
        int[] chunks = params.getChunks();
        DataType dataType = params.getDataType();
        Number fillValue = params.getFillValue();
        Compressor compressor = params.getCompressor();
        ByteOrder byteOrder = params.getByteOrder();
        DimensionSeparator separator = params.getDimensionSeparator();
        ZarrArray zarrArray = new ZarrArray(relativePath, shape, chunks, dataType, byteOrder, fillValue, compressor, separator, store);
        zarrArray.writeZArrayHeader();
        zarrArray.writeAttributes(attributes);
        return zarrArray;
    }

    public Compressor getCompressor() {
        return this._compressor;
    }

    public DataType getDataType() {
        return this._dataType;
    }

    public int[] getShape() {
        return Arrays.copyOf(this._shape, this._shape.length);
    }

    public int[] getChunks() {
        return Arrays.copyOf(this._chunks, this._chunks.length);
    }

    public Number getFillValue() {
        return this._fillValue;
    }

    public ByteOrder getByteOrder() {
        return this._byteOrder;
    }

    public DimensionSeparator getDimensionSeparator() {
        return this._separator;
    }

    public void write(Number value) throws IOException, InvalidRangeException {
        int[] shape = this.getShape();
        int[] offset = new int[shape.length];
        this.write(value, shape, offset);
    }

    public void write(Number value, int[] shape, int[] offset) throws IOException, InvalidRangeException {
        Object data = ZarrUtils.createDataBufferFilledWith(value, this.getDataType(), shape);
        this.write(data, shape, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object data, int[] dataShape, int[] offset) throws IOException, InvalidRangeException {
        int[][] chunkIndices = ZarrUtils.computeChunkIndices(this._shape, this._chunks, dataShape, offset);
        ucar.ma2.DataType dataType = ucar.ma2.DataType.getType(data.getClass().getComponentType(), false);
        Array source = Array.factory(dataType, dataShape, data);
        for (int[] chunkIndex : chunkIndices) {
            String chunkFilename = this.getChunkFilename(chunkIndex);
            ZarrPath chunkFilePath = this.relativePath.resolve(chunkFilename);
            int[] fromBufferPos = this.computeFrom(chunkIndex, offset, false);
            String string = chunkFilename;
            synchronized (string) {
                if (this.partialCopyingIsNotNeeded(dataShape, fromBufferPos)) {
                    this._chunkReaderWriter.write(chunkFilePath.storeKey, source);
                } else {
                    Array targetChunk = this._chunkReaderWriter.read(chunkFilePath.storeKey);
                    PartialDataCopier.copy(fromBufferPos, source, targetChunk);
                    this._chunkReaderWriter.write(chunkFilePath.storeKey, targetChunk);
                }
            }
        }
    }

    public Object read() throws IOException, InvalidRangeException {
        return this.read(this.getShape());
    }

    public Object read(int[] shape) throws IOException, InvalidRangeException {
        return this.read(shape, new int[shape.length]);
    }

    public Object read(int[] shape, int[] offset) throws IOException, InvalidRangeException {
        Object data = ZarrUtils.createDataBuffer(this.getDataType(), shape);
        this.read(data, shape, offset);
        return data;
    }

    public void read(Object buffer, int[] bufferShape) throws IOException, InvalidRangeException {
        this.read(buffer, bufferShape, new int[bufferShape.length]);
    }

    public void read(Object buffer, int[] bufferShape, int[] offset) throws IOException, InvalidRangeException {
        int[][] chunkIndices;
        long expectedSize;
        if (!buffer.getClass().isArray()) {
            throw new IOException("Target buffer object is not an array.");
        }
        int targetSize = java.lang.reflect.Array.getLength(buffer);
        if ((long)targetSize != (expectedSize = ZarrUtils.computeSize(bufferShape))) {
            throw new IOException("Expected target buffer size is " + expectedSize + " but was " + targetSize);
        }
        for (int[] chunkIndex : chunkIndices = ZarrUtils.computeChunkIndices(this._shape, this._chunks, bufferShape, offset)) {
            String chunkFilename = this.getChunkFilename(chunkIndex);
            ZarrPath chunkFilePath = this.relativePath.resolve(chunkFilename);
            int[] fromChunkPos = this.computeFrom(chunkIndex, offset, true);
            Array sourceChunk = this._chunkReaderWriter.read(chunkFilePath.storeKey);
            if (this.partialCopyingIsNotNeeded(bufferShape, fromChunkPos)) {
                System.arraycopy(sourceChunk.getStorage(), 0, buffer, 0, (int)sourceChunk.getSize());
                continue;
            }
            Array target = NetCDF_Util.createArrayWithGivenStorage(buffer, bufferShape);
            PartialDataCopier.copy(fromChunkPos, sourceChunk, target);
        }
    }

    private static boolean findNestedChunks(ZarrPath relativePath, Store store, int[] chunks) throws IOException {
        String oneOrMoreDigits = "\\d+";
        StringBuilder sb = new StringBuilder("\\d+");
        for (int i = 0; i < chunks.length - 1; ++i) {
            sb.append(DimensionSeparator.SLASH.getSeparatorChar());
            sb.append("\\d+");
        }
        String regex = sb.toString();
        try (Stream<String> keys = store.getRelativeLeafKeys(relativePath.storeKey);){
            boolean bl = keys.anyMatch(s2 -> s2.matches(regex));
            return bl;
        }
    }

    private synchronized String getChunkFilename(int[] chunkIndex) {
        String separatorChar = this._separator.getSeparatorChar();
        String chunkFilename = ZarrUtils.createChunkFilename(chunkIndex, separatorChar);
        if (this._chunkFilenames.containsKey(chunkFilename)) {
            return this._chunkFilenames.get(chunkFilename);
        }
        this._chunkFilenames.put(chunkFilename, chunkFilename);
        return chunkFilename;
    }

    private boolean partialCopyingIsNotNeeded(int[] bufferShape, int[] offset) {
        return this.isZeroOffset(offset) && this.isBufferShapeEqualChunkShape(bufferShape);
    }

    private boolean isBufferShapeEqualChunkShape(int[] bufferShape) {
        return Arrays.equals(bufferShape, this._chunks);
    }

    private boolean isZeroOffset(int[] offset) {
        return Arrays.equals(offset, new int[offset.length]);
    }

    public void writeAttributes(Map<String, Object> attributes) throws IOException {
        ZarrUtils.writeAttributes(attributes, this.relativePath, this._store);
    }

    public Map<String, Object> getAttributes() throws IOException {
        return ZarrUtils.readAttributes(this.relativePath, this._store);
    }

    public String toString() {
        return this.getClass().getCanonicalName() + "{'/" + this.relativePath.storeKey + "' shape=" + Arrays.toString(this._shape) + ", chunks=" + Arrays.toString(this._chunks) + ", dataType=" + (Object)((Object)this._dataType) + ", fillValue=" + this._fillValue + ", " + this._compressor.toString() + ", store=" + this._store.getClass().getSimpleName() + ", byteOrder=" + this._byteOrder + '}';
    }

    private int[] computeFrom(int[] chunkIndex, int[] to, boolean read) {
        int[] from = new int[chunkIndex.length];
        for (int i = 0; i < chunkIndex.length; ++i) {
            int index = chunkIndex[i];
            from[i] = index * this._chunks[i];
            int n = i;
            from[n] = from[n] - to[i];
        }
        if (read) {
            int i1 = 0;
            while (i1 < from.length) {
                int n = i1++;
                from[n] = from[n] * -1;
            }
        }
        return from;
    }

    private void writeZArrayHeader() throws IOException {
        ZarrHeader zarrHeader = new ZarrHeader(this._shape, this._chunks, this._dataType.toString(), this._byteOrder, this._fillValue, this._compressor, this._separator.getSeparatorChar());
        ZarrPath zArray = this.relativePath.resolve(".zarray");
        try (OutputStream os = this._store.getOutputStream(zArray.storeKey);
             OutputStreamWriter writer = new OutputStreamWriter(os);){
            ZarrUtils.toJson(zarrHeader, writer, true);
        }
    }
}

