/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.Index;
import ucar.ma2.Index0D;
import ucar.ma2.Index1D;
import ucar.ma2.Index2D;
import ucar.ma2.Index3D;
import ucar.ma2.Index4D;
import ucar.ma2.Index5D;
import ucar.ma2.Index6D;
import ucar.ma2.Index7D;
import ucar.ma2.IndexIterator;

public class ArrayByte
extends Array {
    protected byte[] storage;

    static ArrayByte factory(Index index, boolean isUnsigned) {
        return ArrayByte.factory(index, isUnsigned, null);
    }

    static ArrayByte factory(Index index, boolean isUnsigned, byte[] storage) {
        if (index instanceof Index0D) {
            return new D0(index, isUnsigned, storage);
        }
        if (index instanceof Index1D) {
            return new D1(index, isUnsigned, storage);
        }
        if (index instanceof Index2D) {
            return new D2(index, isUnsigned, storage);
        }
        if (index instanceof Index3D) {
            return new D3(index, isUnsigned, storage);
        }
        if (index instanceof Index4D) {
            return new D4(index, isUnsigned, storage);
        }
        if (index instanceof Index5D) {
            return new D5(index, isUnsigned, storage);
        }
        if (index instanceof Index6D) {
            return new D6(index, isUnsigned, storage);
        }
        if (index instanceof Index7D) {
            return new D7(index, isUnsigned, storage);
        }
        return new ArrayByte(index, isUnsigned, storage);
    }

    public ArrayByte(int[] dimensions, boolean isUnsigned) {
        super(isUnsigned ? DataType.UBYTE : DataType.BYTE, dimensions);
        this.storage = new byte[(int)this.indexCalc.getSize()];
    }

    ArrayByte(Index ima, boolean isUnsigned, byte[] data) {
        super(isUnsigned ? DataType.UBYTE : DataType.BYTE, ima);
        this.storage = data != null ? data : new byte[(int)ima.getSize()];
    }

    @Override
    protected Array createView(Index index) {
        return ArrayByte.factory(index, this.isUnsigned(), this.storage);
    }

    @Override
    public Object getStorage() {
        return this.storage;
    }

    @Override
    protected void copyFrom1DJavaArray(IndexIterator iter, Object javaArray) {
        byte[] ja;
        for (byte aJa : ja = (byte[])javaArray) {
            iter.setByteNext(aJa);
        }
    }

    @Override
    protected void copyTo1DJavaArray(IndexIterator iter, Object javaArray) {
        byte[] ja = (byte[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            ja[i] = iter.getByteNext();
        }
    }

    @Override
    public ByteBuffer getDataAsByteBuffer() {
        return this.getDataAsByteBuffer(null);
    }

    @Override
    public ByteBuffer getDataAsByteBuffer(ByteOrder order) {
        return ByteBuffer.wrap((byte[])this.get1DJavaArray(this.getDataType()));
    }

    @Override
    public Class getElementType() {
        return Byte.TYPE;
    }

    public byte get(Index i) {
        return this.storage[i.currentElement()];
    }

    public void set(Index i, byte value) {
        this.storage[i.currentElement()] = value;
    }

    @Override
    public double getDouble(Index i) {
        byte val = this.storage[i.currentElement()];
        return this.isUnsigned() ? DataType.unsignedByteToShort(val) : (short)val;
    }

    @Override
    public void setDouble(Index i, double value) {
        this.storage[i.currentElement()] = (byte)value;
    }

    @Override
    public float getFloat(Index i) {
        byte val = this.storage[i.currentElement()];
        return this.isUnsigned() ? DataType.unsignedByteToShort(val) : (short)val;
    }

    @Override
    public void setFloat(Index i, float value) {
        this.storage[i.currentElement()] = (byte)value;
    }

    @Override
    public long getLong(Index i) {
        byte val = this.storage[i.currentElement()];
        return this.isUnsigned() ? DataType.unsignedByteToShort(val) : (short)val;
    }

    @Override
    public void setLong(Index i, long value) {
        this.storage[i.currentElement()] = (byte)value;
    }

    @Override
    public int getInt(Index i) {
        byte val = this.storage[i.currentElement()];
        return this.isUnsigned() ? DataType.unsignedByteToShort(val) : (short)val;
    }

    @Override
    public void setInt(Index i, int value) {
        this.storage[i.currentElement()] = (byte)value;
    }

    @Override
    public short getShort(Index i) {
        byte val = this.storage[i.currentElement()];
        return this.isUnsigned() ? DataType.unsignedByteToShort(val) : (short)val;
    }

    @Override
    public void setShort(Index i, short value) {
        this.storage[i.currentElement()] = (byte)value;
    }

    @Override
    public byte getByte(Index i) {
        return this.storage[i.currentElement()];
    }

    @Override
    public void setByte(Index i, byte value) {
        this.storage[i.currentElement()] = value;
    }

    @Override
    public char getChar(Index i) {
        byte val = this.storage[i.currentElement()];
        return (char)(this.isUnsigned() ? DataType.unsignedByteToShort(val) : (short)val);
    }

    @Override
    public void setChar(Index i, char value) {
        this.storage[i.currentElement()] = (byte)value;
    }

    @Override
    public boolean getBoolean(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setBoolean(Index i, boolean value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public Object getObject(Index i) {
        return this.storage[i.currentElement()];
    }

    @Override
    public void setObject(Index i, Object value) {
        this.storage[i.currentElement()] = ((Number)value).byteValue();
    }

    @Override
    public double getDouble(int index) {
        byte val = this.storage[index];
        return this.isUnsigned() ? DataType.unsignedByteToShort(val) : (short)val;
    }

    @Override
    public void setDouble(int index, double value) {
        this.storage[index] = (byte)value;
    }

    @Override
    public float getFloat(int index) {
        byte val = this.storage[index];
        return this.isUnsigned() ? DataType.unsignedByteToShort(val) : (short)val;
    }

    @Override
    public void setFloat(int index, float value) {
        this.storage[index] = (byte)value;
    }

    @Override
    public long getLong(int index) {
        byte val = this.storage[index];
        return this.isUnsigned() ? DataType.unsignedByteToShort(val) : (short)val;
    }

    @Override
    public void setLong(int index, long value) {
        this.storage[index] = (byte)value;
    }

    @Override
    public int getInt(int index) {
        byte val = this.storage[index];
        return this.isUnsigned() ? DataType.unsignedByteToShort(val) : (short)val;
    }

    @Override
    public void setInt(int index, int value) {
        this.storage[index] = (byte)value;
    }

    @Override
    public short getShort(int index) {
        byte val = this.storage[index];
        return this.isUnsigned() ? DataType.unsignedByteToShort(val) : (short)val;
    }

    @Override
    public void setShort(int index, short value) {
        this.storage[index] = (byte)value;
    }

    @Override
    public byte getByte(int index) {
        return this.storage[index];
    }

    @Override
    public void setByte(int index, byte value) {
        this.storage[index] = value;
    }

    @Override
    public char getChar(int index) {
        byte val = this.storage[index];
        return (char)(this.isUnsigned() ? DataType.unsignedByteToShort(val) : (short)val);
    }

    @Override
    public void setChar(int index, char value) {
        this.storage[index] = (byte)value;
    }

    @Override
    public boolean getBoolean(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setBoolean(int index, boolean value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public Object getObject(int index) {
        return this.getByte(index);
    }

    @Override
    public void setObject(int index, Object value) {
        this.storage[index] = ((Number)value).byteValue();
    }

    public static class D7
    extends ArrayByte {
        protected Index7D ix;

        public D7(int len0, int len1, int len2, int len3, int len4, int len5, int len6, boolean isUnsigned) {
            super(new int[]{len0, len1, len2, len3, len4, len5, len6}, isUnsigned);
            this.ix = (Index7D)this.indexCalc;
        }

        private D7(Index i, boolean isUnsigned, byte[] store) {
            super(i, isUnsigned, store);
            this.ix = (Index7D)this.indexCalc;
        }

        public byte get(int i, int j, int k, int l, int m4, int n, int o) {
            return this.storage[this.ix.setDirect(i, j, k, l, m4, n, o)];
        }

        public void set(int i, int j, int k, int l, int m4, int n, int o, byte value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m4, (int)n, (int)o)] = value;
        }
    }

    public static class D6
    extends ArrayByte {
        private Index6D ix;

        public D6(int len0, int len1, int len2, int len3, int len4, int len5, boolean isUnsigned) {
            super(new int[]{len0, len1, len2, len3, len4, len5}, isUnsigned);
            this.ix = (Index6D)this.indexCalc;
        }

        private D6(Index i, boolean isUnsigned, byte[] store) {
            super(i, isUnsigned, store);
            this.ix = (Index6D)this.indexCalc;
        }

        public byte get(int i, int j, int k, int l, int m4, int n) {
            return this.storage[this.ix.setDirect(i, j, k, l, m4, n)];
        }

        public void set(int i, int j, int k, int l, int m4, int n, byte value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m4, (int)n)] = value;
        }
    }

    public static class D5
    extends ArrayByte {
        private Index5D ix;

        public D5(int len0, int len1, int len2, int len3, int len4, boolean isUnsigned) {
            super(new int[]{len0, len1, len2, len3, len4}, isUnsigned);
            this.ix = (Index5D)this.indexCalc;
        }

        private D5(Index i, boolean isUnsigned, byte[] store) {
            super(i, isUnsigned, store);
            this.ix = (Index5D)this.indexCalc;
        }

        public byte get(int i, int j, int k, int l, int m4) {
            return this.storage[this.ix.setDirect(i, j, k, l, m4)];
        }

        public void set(int i, int j, int k, int l, int m4, byte value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m4)] = value;
        }
    }

    public static class D4
    extends ArrayByte {
        private Index4D ix;

        public D4(int len0, int len1, int len2, int len3, boolean isUnsigned) {
            super(new int[]{len0, len1, len2, len3}, isUnsigned);
            this.ix = (Index4D)this.indexCalc;
        }

        private D4(Index i, boolean isUnsigned, byte[] store) {
            super(i, isUnsigned, store);
            this.ix = (Index4D)this.indexCalc;
        }

        public byte get(int i, int j, int k, int l) {
            return this.storage[this.ix.setDirect(i, j, k, l)];
        }

        public void set(int i, int j, int k, int l, byte value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l)] = value;
        }
    }

    public static class D3
    extends ArrayByte {
        private Index3D ix;

        public D3(int len0, int len1, int len2, boolean isUnsigned) {
            super(new int[]{len0, len1, len2}, isUnsigned);
            this.ix = (Index3D)this.indexCalc;
        }

        private D3(Index i, boolean isUnsigned, byte[] store) {
            super(i, isUnsigned, store);
            this.ix = (Index3D)this.indexCalc;
        }

        public byte get(int i, int j, int k) {
            return this.storage[this.ix.setDirect(i, j, k)];
        }

        public void set(int i, int j, int k, byte value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k)] = value;
        }
    }

    public static class D2
    extends ArrayByte {
        private Index2D ix;

        public D2(int len0, int len1, boolean isUnsigned) {
            super(new int[]{len0, len1}, isUnsigned);
            this.ix = (Index2D)this.indexCalc;
        }

        private D2(Index i, boolean isUnsigned, byte[] store) {
            super(i, isUnsigned, store);
            this.ix = (Index2D)this.indexCalc;
        }

        public byte get(int i, int j) {
            return this.storage[this.ix.setDirect(i, j)];
        }

        public void set(int i, int j, byte value) {
            this.storage[this.ix.setDirect((int)i, (int)j)] = value;
        }
    }

    public static class D1
    extends ArrayByte {
        private Index1D ix;

        public D1(int len0, boolean isUnsigned) {
            super(new int[]{len0}, isUnsigned);
            this.ix = (Index1D)this.indexCalc;
        }

        private D1(Index i, boolean isUnsigned, byte[] store) {
            super(i, isUnsigned, store);
            this.ix = (Index1D)this.indexCalc;
        }

        public byte get(int i) {
            return this.storage[this.ix.setDirect(i)];
        }

        public void set(int i, byte value) {
            this.storage[this.ix.setDirect((int)i)] = value;
        }
    }

    public static class D0
    extends ArrayByte {
        private Index0D ix;

        public D0(boolean isUnsigned) {
            super(new int[0], isUnsigned);
            this.ix = (Index0D)this.indexCalc;
        }

        private D0(Index i, boolean isUnsigned, byte[] store) {
            super(i, isUnsigned, store);
            this.ix = (Index0D)this.indexCalc;
        }

        public byte get() {
            return this.storage[this.ix.currentElement()];
        }

        public void set(byte value) {
            this.storage[this.ix.currentElement()] = value;
        }
    }
}

