/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;

public enum Immersion implements Enumeration
{
    OIL("Oil"),
    WATER("Water"),
    WATERDIPPING("WaterDipping"),
    AIR("Air"),
    MULTI("Multi"),
    GLYCEROL("Glycerol"),
    OTHER("Other");

    private final String value;

    private Immersion(String value) {
        this.value = value;
    }

    public static Immersion fromString(String value) throws EnumerationException {
        if ("Oil".equals(value)) {
            return OIL;
        }
        if ("Water".equals(value)) {
            return WATER;
        }
        if ("WaterDipping".equals(value)) {
            return WATERDIPPING;
        }
        if ("Air".equals(value)) {
            return AIR;
        }
        if ("Multi".equals(value)) {
            return MULTI;
        }
        if ("Glycerol".equals(value)) {
            return GLYCEROL;
        }
        if ("Other".equals(value)) {
            return OTHER;
        }
        String s2 = String.format("'%s' not a supported value of '%s'", value, Immersion.class);
        throw new EnumerationException(s2);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

