/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.partition;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import thredds.inventory.CollectionSingleFile;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.partition.DirectoryCollection;
import thredds.inventory.partition.PartitionManager;
import ucar.nc2.util.CloseableIterator;

public class FilePartition
extends DirectoryCollection
implements PartitionManager {
    private List<String> removed;

    public FilePartition(String topCollectionName, Path topDir, boolean isTop, String olderThan, Logger logger) {
        super(topCollectionName, topDir, isTop, olderThan, logger);
    }

    @Override
    public Iterable<MCollection> makePartitions(CollectionUpdateType forceCollection) throws IOException {
        ArrayList<MCollection> result = new ArrayList<MCollection>(100);
        try (CloseableIterator<MFile> iter = this.getFileIterator();){
            while (iter.hasNext()) {
                CollectionSingleFile part = new CollectionSingleFile((MFile)iter.next(), this.logger);
                if (!this.wasRemoved(part)) {
                    result.add(part);
                }
                this.lastModified = Math.max(this.lastModified, part.getLastModified());
            }
        }
        return result;
    }

    @Override
    public void removePartition(MCollection partition) {
        if (this.removed == null) {
            this.removed = new ArrayList<String>();
        }
        this.removed.add(partition.getCollectionName());
    }

    private boolean wasRemoved(MCollection partition) {
        return this.removed != null && this.removed.contains(partition.getCollectionName());
    }
}

