/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.ClassList;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.UnknownFormatException;
import loci.formats.UnsupportedCompressionException;
import loci.formats.in.DefaultMetadataOptions;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;

public class NRRDReader
extends FormatReader {
    public static final String NRRD_MAGIC_STRING = "NRRD";
    private ImageReader helper;
    private String dataFile;
    private String encoding;
    private long offset;
    private String[] pixelSizes;
    private boolean initializeHelper = false;
    private transient GZIPInputStream gzip;
    private transient int lastPlane = -1;

    public NRRDReader() {
        super(NRRD_MAGIC_STRING, new String[]{"nrrd", "nhdr"});
        this.domains = new String[]{"Unknown"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "A single .nrrd file or one .nhdr file and one other file containing the pixels";
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getSizeY();
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return NRRDReader.checkSuffix(id, "nrrd");
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (super.isThisType(name, open)) {
            return true;
        }
        if (!open) {
            return false;
        }
        Location header = new Location(name + ".nhdr");
        if (header.exists()) {
            return true;
        }
        if (name.indexOf(46) >= 0) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        header = new Location(name + ".nhdr");
        return header.exists();
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = NRRD_MAGIC_STRING.length();
        if (!FormatTools.validStream(stream, blockLen, false)) {
            return false;
        }
        return stream.readString(blockLen).startsWith(NRRD_MAGIC_STRING);
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            if (this.dataFile == null) {
                return null;
            }
            return new String[]{this.currentId};
        }
        if (this.dataFile == null) {
            return new String[]{this.currentId};
        }
        return new String[]{this.currentId, this.dataFile};
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        if (this.initializeHelper && this.dataFile != null && this.helper.getCurrentFile() == null) {
            try {
                this.helper.setId(this.dataFile);
            }
            catch (UnknownFormatException e) {
                this.initializeHelper = false;
            }
        }
        if (this.dataFile == null) {
            long planeSize = FormatTools.getPlaneSize(this);
            if (this.encoding.equals("raw")) {
                this.in.seek(this.offset + (long)no * planeSize);
                this.readPlane(this.in, x, y, w, h2, buf);
            } else if (this.encoding.equals("gzip")) {
                this.readGZIPPlane(this.getCurrentFile(), no, buf, x, y, w, h2);
            } else {
                throw new UnsupportedCompressionException("Unsupported encoding: " + this.encoding);
            }
            return buf;
        }
        if (!this.initializeHelper) {
            if (this.encoding.equals("raw")) {
                try (RandomAccessInputStream s2 = new RandomAccessInputStream(this.dataFile);){
                    s2.seek(this.offset + (long)(no * FormatTools.getPlaneSize(this)));
                    this.readPlane(s2, x, y, w, h2, buf);
                }
            } else if (this.encoding.equals("gzip")) {
                this.readGZIPPlane(this.dataFile, no, buf, x, y, w, h2);
            }
            return buf;
        }
        return this.helper.openBytes(no, buf, x, y, w, h2);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.helper != null) {
            this.helper.close(fileOnly);
        }
        if (!fileOnly) {
            this.helper = null;
            this.encoding = null;
            this.dataFile = null;
            this.offset = 0L;
            this.pixelSizes = null;
            this.initializeHelper = false;
            if (this.gzip != null) {
                this.gzip.close();
            }
            this.gzip = null;
            this.lastPlane = -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void initFile(String id) throws FormatException, IOException {
        if (!NRRDReader.checkSuffix(id, "nhdr") && !NRRDReader.checkSuffix(id, "nrrd")) {
            if (!new Location(id = id + ".nhdr").exists()) {
                id = id.substring(0, id.lastIndexOf("."));
                id = id.substring(0, id.lastIndexOf("."));
                id = id + ".nhdr";
            }
            id = new Location(id).getAbsolutePath();
        }
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        ClassList<IFormatReader> classes = ImageReader.getDefaultReaderClasses();
        Class<IFormatReader>[] classArray = classes.getClasses();
        ClassList<IFormatReader> newClasses = new ClassList<IFormatReader>(IFormatReader.class);
        for (Class<IFormatReader> c : classArray) {
            if (c.equals(NRRDReader.class)) continue;
            newClasses.addClass(c);
        }
        this.helper = new ImageReader(newClasses);
        this.helper.setMetadataOptions(new DefaultMetadataOptions(MetadataLevel.MINIMUM));
        String[] pixelSizeUnits = null;
        int numDimensions = 0;
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        m4.sizeX = 1;
        m4.sizeY = 1;
        m4.sizeZ = 1;
        m4.sizeC = 1;
        m4.sizeT = 1;
        m4.dimensionOrder = "XYCZT";
        String line = this.in.readLine();
        while (line != null && line.length() > 0) {
            if (!line.startsWith("#") && !line.startsWith(NRRD_MAGIC_STRING)) {
                String key = line.substring(0, line.indexOf(58)).trim();
                String v = line.substring(line.indexOf(58) + 1).trim();
                this.addGlobalMeta(key, v);
                if (key.equals("type")) {
                    if (v.indexOf("char") != -1 || v.indexOf(56) != -1) {
                        m4.pixelType = 1;
                    } else if (v.indexOf("short") != -1 || v.indexOf("16") != -1) {
                        m4.pixelType = 3;
                    } else if (v.equals("int") || v.equals("signed int") || v.equals("int32") || v.equals("int32_t") || v.equals("uint") || v.equals("unsigned int") || v.equals("uint32") || v.equals("uint32_t")) {
                        m4.pixelType = 5;
                    } else if (v.equals("float")) {
                        m4.pixelType = 6;
                    } else {
                        if (!v.equals("double")) throw new FormatException("Unsupported data type: " + v);
                        m4.pixelType = 7;
                    }
                } else if (key.equals("dimension")) {
                    numDimensions = Integer.parseInt(v);
                } else if (key.equals("sizes")) {
                    String[] tokens = v.split(" ");
                    for (int i = 0; i < numDimensions; ++i) {
                        int size = Integer.parseInt(tokens[i]);
                        if (numDimensions >= 3 && i == 0 && size > 1 && size <= 16) {
                            m4.sizeC = size;
                            continue;
                        }
                        if (i == 0 || this.getSizeC() > 1 && i == 1) {
                            m4.sizeX = size;
                            continue;
                        }
                        if (i == 1 || this.getSizeC() > 1 && i == 2) {
                            m4.sizeY = size;
                            continue;
                        }
                        if (i == 2 || this.getSizeC() > 1 && i == 3) {
                            m4.sizeZ = size;
                            continue;
                        }
                        if (i != 3 && (this.getSizeC() <= 1 || i != 4)) continue;
                        m4.sizeT = size;
                    }
                } else if (key.equals("data file") || key.equals("datafile")) {
                    this.dataFile = v;
                } else if (key.equals("encoding")) {
                    this.encoding = v;
                } else if (key.equals("endian")) {
                    m4.littleEndian = v.equals("little");
                } else if (key.equals("spacings") || key.equals("space directions")) {
                    this.pixelSizes = v.split(" ");
                } else if (key.equals("space units")) {
                    pixelSizeUnits = v.split(" ");
                } else if (key.equals("byte skip") || key.equals("byteskip")) {
                    this.offset = Long.parseLong(v);
                }
            }
            if ((line = this.in.readLine()) == null) continue;
            line = line.trim();
        }
        if (this.dataFile == null) {
            this.offset = this.in.getFilePointer();
        } else {
            Location f = new Location(this.currentId).getAbsoluteFile();
            Location parent = f.getParentFile();
            if (f.exists() && parent != null) {
                this.dataFile = this.dataFile.substring(this.dataFile.indexOf(File.separator) + 1);
                this.dataFile = new Location(parent, this.dataFile).getAbsolutePath();
            }
            this.initializeHelper = !this.encoding.equals("raw") && this.offset >= 0L && this.helper.isThisType(this.dataFile);
        }
        m4.rgb = this.getSizeC() > 1;
        m4.interleaved = true;
        m4.imageCount = this.getSizeZ() * this.getSizeT();
        m4.indexed = false;
        m4.falseColor = false;
        m4.metadataComplete = true;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM || this.pixelSizes == null) return;
        for (int i = 0; i < this.pixelSizes.length; ++i) {
            if (this.pixelSizes[i] == null) continue;
            try {
                Length z;
                String unit;
                Double d = this.parsePixelSize(i);
                String string = unit = pixelSizeUnits == null || i >= pixelSizeUnits.length ? null : pixelSizeUnits[i].replaceAll("\"", "");
                if (i == 0) {
                    Length x = FormatTools.getPhysicalSizeX(d, unit);
                    if (x == null) continue;
                    store.setPixelsPhysicalSizeX(x, 0);
                    continue;
                }
                if (i == 1) {
                    Length y = FormatTools.getPhysicalSizeY(d, unit);
                    if (y == null) continue;
                    store.setPixelsPhysicalSizeY(y, 0);
                    continue;
                }
                if (i != 2 || (z = FormatTools.getPhysicalSizeZ(d, unit)) == null) continue;
                store.setPixelsPhysicalSizeZ(z, 0);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void safeSkip(InputStream stream, long skip) throws IOException {
        while (skip > 0L) {
            skip -= stream.skip((int)Math.min(skip, Integer.MAX_VALUE));
        }
    }

    private void readGZIPPlane(String file2, int no, byte[] buf, int x, int y, int w, int h2) throws IOException {
        if (this.gzip == null || no <= this.lastPlane) {
            if (this.gzip != null) {
                this.gzip.close();
            }
            FileInputStream fis = new FileInputStream(file2);
            this.safeSkip(fis, this.offset);
            this.gzip = new GZIPInputStream(fis);
            this.lastPlane = -1;
        }
        int bpp = this.getRGBChannelCount() * FormatTools.getBytesPerPixel(this.getPixelType());
        int rowLen = this.getSizeX() * bpp;
        int diff = no - (this.lastPlane + 1);
        long planeSize = FormatTools.getPlaneSize(this);
        this.safeSkip(this.gzip, planeSize * (long)diff + (long)(y * rowLen));
        int readLen = w * bpp;
        for (int row = 0; row < h2; ++row) {
            this.safeSkip(this.gzip, x * bpp);
            for (int toRead = readLen; toRead > 0; toRead -= this.gzip.read(buf, (row + y) * readLen + (readLen - toRead), toRead)) {
            }
            this.safeSkip(this.gzip, (this.getSizeX() - w - x) * bpp);
        }
        this.lastPlane = no;
    }

    private Double parsePixelSize(int index) {
        String[] vector;
        String size = this.pixelSizes[index].trim();
        if (size.startsWith("(") && index < (vector = (size = size.substring(1, size.length() - 1)).split(",")).length) {
            return DataTools.parseDouble(vector[index].trim());
        }
        return DataTools.parseDouble(size);
    }
}

