/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import ome.codecs.JPEG2000CodecOptions;
import ome.codecs.services.JAIIIOService;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JAIIIOServiceTest {
    private static final int SIZE_X = 64;
    private static final int SIZE_Y = 96;
    private static final int[] CODE_BLOCK = new int[]{4, 4};
    private static final int IMAGE_TYPE = 2;
    private JAIIIOService service;

    @BeforeMethod
    public void setUp() throws DependencyException {
        ServiceFactory sf = new ServiceFactory();
        this.service = (JAIIIOService)sf.getInstance(JAIIIOService.class);
    }

    private ByteArrayOutputStream writeImage(JPEG2000CodecOptions options) throws IOException, ServiceException {
        BufferedImage image = new BufferedImage(64, 96, 2);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.service.writeImage((OutputStream)stream, image, options);
        return stream;
    }

    private ByteArrayOutputStream assertWriteImageLossy() throws IOException, ServiceException {
        JPEG2000CodecOptions options = JPEG2000CodecOptions.getDefaultOptions();
        options.lossless = false;
        options.codeBlockSize = CODE_BLOCK;
        options.quality = 1.0;
        ByteArrayOutputStream stream = this.writeImage(options);
        AssertJUnit.assertTrue((stream.size() > 0 ? 1 : 0) != 0);
        return stream;
    }

    private ByteArrayOutputStream assertWriteImageLossless() throws IOException, ServiceException {
        JPEG2000CodecOptions options = JPEG2000CodecOptions.getDefaultOptions();
        options.lossless = true;
        options.codeBlockSize = CODE_BLOCK;
        options.quality = 1.0;
        ByteArrayOutputStream stream = this.writeImage(options);
        AssertJUnit.assertTrue((stream.size() > 0 ? 1 : 0) != 0);
        return stream;
    }

    @Test
    public void testWriteTiledImageLossy() throws IOException, ServiceException {
        JPEG2000CodecOptions options = JPEG2000CodecOptions.getDefaultOptions();
        options.lossless = false;
        options.codeBlockSize = CODE_BLOCK;
        options.quality = 1.0;
        options.tileWidth = 32;
        options.tileHeight = 32;
        options.tileGridXOffset = 0;
        options.tileGridYOffset = 0;
        ByteArrayOutputStream stream = this.writeImage(options);
        AssertJUnit.assertTrue((stream.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testWriteTiledImageLossless() throws IOException, ServiceException {
        JPEG2000CodecOptions options = JPEG2000CodecOptions.getDefaultOptions();
        options.lossless = true;
        options.codeBlockSize = CODE_BLOCK;
        options.quality = 1.0;
        options.tileWidth = 32;
        options.tileHeight = 32;
        options.tileGridXOffset = 0;
        options.tileGridYOffset = 0;
        ByteArrayOutputStream stream = this.writeImage(options);
        AssertJUnit.assertTrue((stream.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReadImageLossy() throws IOException, ServiceException {
        ByteArrayOutputStream outputStream = this.assertWriteImageLossy();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        BufferedImage image = this.service.readImage((InputStream)inputStream);
        AssertJUnit.assertNotNull((Object)image);
        AssertJUnit.assertEquals((int)64, (int)image.getWidth());
        AssertJUnit.assertEquals((int)96, (int)image.getHeight());
    }

    @Test
    public void testReadImageLossless() throws IOException, ServiceException {
        ByteArrayOutputStream outputStream = this.assertWriteImageLossless();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        BufferedImage image = this.service.readImage((InputStream)inputStream);
        AssertJUnit.assertNotNull((Object)image);
        AssertJUnit.assertEquals((int)64, (int)image.getWidth());
        AssertJUnit.assertEquals((int)96, (int)image.getHeight());
    }

    @Test
    public void testReadRasterLossy() throws IOException, ServiceException {
        ByteArrayOutputStream outputStream = this.assertWriteImageLossy();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        Raster image = this.service.readRaster((InputStream)inputStream);
        AssertJUnit.assertNotNull((Object)image);
        AssertJUnit.assertEquals((int)64, (int)image.getWidth());
        AssertJUnit.assertEquals((int)96, (int)image.getHeight());
    }

    @Test
    public void testReadRasterLossless() throws IOException, ServiceException {
        ByteArrayOutputStream outputStream = this.assertWriteImageLossless();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        Raster image = this.service.readRaster((InputStream)inputStream);
        AssertJUnit.assertNotNull((Object)image);
        AssertJUnit.assertEquals((int)64, (int)image.getWidth());
        AssertJUnit.assertEquals((int)96, (int)image.getHeight());
    }

    @Test
    public void testReadImageLevel0Lossy() throws IOException, ServiceException {
        ByteArrayOutputStream outputStream = this.assertWriteImageLossy();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        JPEG2000CodecOptions options = JPEG2000CodecOptions.getDefaultOptions();
        options.resolution = 0;
        BufferedImage image = this.service.readImage((InputStream)inputStream, options);
        AssertJUnit.assertNotNull((Object)image);
        AssertJUnit.assertEquals((int)2, (int)image.getWidth());
        AssertJUnit.assertEquals((int)3, (int)image.getHeight());
    }

    @Test
    public void testReadImageLevel0Lossless() throws IOException, ServiceException {
        ByteArrayOutputStream outputStream = this.assertWriteImageLossless();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        JPEG2000CodecOptions options = JPEG2000CodecOptions.getDefaultOptions();
        options.resolution = 0;
        BufferedImage image = this.service.readImage((InputStream)inputStream, options);
        AssertJUnit.assertNotNull((Object)image);
        AssertJUnit.assertEquals((int)2, (int)image.getWidth());
        AssertJUnit.assertEquals((int)3, (int)image.getHeight());
    }

    @Test
    public void testReadRasterLevel0Lossy() throws IOException, ServiceException {
        ByteArrayOutputStream outputStream = this.assertWriteImageLossy();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        JPEG2000CodecOptions options = JPEG2000CodecOptions.getDefaultOptions();
        options.resolution = 0;
        Raster image = this.service.readRaster((InputStream)inputStream, options);
        AssertJUnit.assertNotNull((Object)image);
        AssertJUnit.assertEquals((int)2, (int)image.getWidth());
        AssertJUnit.assertEquals((int)3, (int)image.getHeight());
    }

    @Test
    public void testReadRasterLevel0Lossless() throws IOException, ServiceException {
        ByteArrayOutputStream outputStream = this.assertWriteImageLossless();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        JPEG2000CodecOptions options = JPEG2000CodecOptions.getDefaultOptions();
        options.resolution = 0;
        Raster image = this.service.readRaster((InputStream)inputStream, options);
        AssertJUnit.assertNotNull((Object)image);
        AssertJUnit.assertEquals((int)2, (int)image.getWidth());
        AssertJUnit.assertEquals((int)3, (int)image.getHeight());
    }

    @Test
    public void testNumDecompositionLevelsLossy() throws IOException, ServiceException {
        JPEG2000CodecOptions options = JPEG2000CodecOptions.getDefaultOptions();
        options.numDecompositionLevels = 2;
        options.resolution = 2;
        options.lossless = false;
        options.codeBlockSize = CODE_BLOCK;
        options.quality = 1.0;
        ByteArrayOutputStream outputStream = this.writeImage(options);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        BufferedImage image = this.service.readImage((InputStream)inputStream, options);
        AssertJUnit.assertNotNull((Object)image);
        AssertJUnit.assertEquals((int)64, (int)image.getWidth());
        AssertJUnit.assertEquals((int)96, (int)image.getHeight());
    }

    @Test
    public void testNumDecompositionLevelsLossless() throws IOException, ServiceException {
        JPEG2000CodecOptions options = JPEG2000CodecOptions.getDefaultOptions();
        options.numDecompositionLevels = 2;
        options.resolution = 2;
        options.lossless = true;
        options.codeBlockSize = CODE_BLOCK;
        options.quality = 1.0;
        ByteArrayOutputStream outputStream = this.writeImage(options);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        BufferedImage image = this.service.readImage((InputStream)inputStream, options);
        AssertJUnit.assertNotNull((Object)image);
        AssertJUnit.assertEquals((int)64, (int)image.getWidth());
        AssertJUnit.assertEquals((int)96, (int)image.getHeight());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testWriteFloatingPointLossy() throws Exception {
        JPEG2000CodecOptions options = JPEG2000CodecOptions.getDefaultOptions();
        options.lossless = false;
        options.codeBlockSize = CODE_BLOCK;
        options.quality = 1.0;
        ComponentSampleModel sm = new ComponentSampleModel(4, 64, 96, 1, 64, new int[]{0});
        DataBufferFloat db = new DataBufferFloat(6144);
        WritableRaster wr = Raster.createWritableRaster(sm, db, null);
        ColorSpace cs = ColorSpace.getInstance(1003);
        ComponentColorModel cm = new ComponentColorModel(cs, false, true, 1, 4);
        BufferedImage image = new BufferedImage(cm, wr, true, null);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.service.writeImage((OutputStream)stream, image, options);
    }
}

