/*
 * Decompiled with CFR 0.152.
 */
package ome.metakit.utests;

import java.io.IOException;
import java.lang.reflect.Array;
import ome.metakit.MetakitException;
import ome.metakit.MetakitReader;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RowTest {
    private static final String FILENAME = "src/test/resources/test.mk";
    private static final String INVALID_TABLE = "this cannot be a valid table";
    private MetakitReader reader;

    @BeforeMethod
    public void setUp() throws IOException, MetakitException {
        this.reader = new MetakitReader(System.getProperty("filename", FILENAME));
    }

    @Test
    public void testDataTypes() {
        int tableCount = this.reader.getTableCount();
        for (int table = 0; table < tableCount; ++table) {
            Object[][] data = this.reader.getTableData(table);
            Class[] columnTypes = this.reader.getColumnTypes(table);
            for (int row = 0; row < data.length; ++row) {
                for (int col = 0; col < data[row].length; ++col) {
                    AssertJUnit.assertTrue((data[row][col] == null || columnTypes[col].isInstance(data[row][col]) || Array.getLength(data[row][col]) == 0 || columnTypes[col].isInstance(Array.get(data[row][col], 0)) ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void testTableDataConsistentByIndex() {
        int tableCount = this.reader.getTableCount();
        for (int table = 0; table < tableCount; ++table) {
            Object[][] bulkData = this.reader.getTableData(table);
            for (int row = 0; row < bulkData.length; ++row) {
                Object[] rowData = this.reader.getRowData(row, table);
                AssertJUnit.assertNotNull((Object)rowData);
                AssertJUnit.assertEquals((int)bulkData[row].length, (int)rowData.length);
                for (int col = 0; col < bulkData[row].length; ++col) {
                    AssertJUnit.assertEquals((Object)bulkData[row][col], (Object)rowData[col]);
                }
            }
        }
    }

    @Test
    public void testTableDataConsistentByName() {
        String[] tableNames = this.reader.getTableNames();
        for (int table = 0; table < tableNames.length; ++table) {
            String name = tableNames[table];
            Object[][] bulkData = this.reader.getTableData(name);
            for (int row = 0; row < bulkData.length; ++row) {
                Object[] rowData = this.reader.getRowData(row, name);
                AssertJUnit.assertNotNull((Object)rowData);
                AssertJUnit.assertEquals((int)bulkData[row].length, (int)rowData.length);
                for (int col = 0; col < bulkData[row].length; ++col) {
                    AssertJUnit.assertEquals((Object)bulkData[row][col], (Object)rowData[col]);
                }
            }
        }
    }

    @Test
    public void testTableDataConsistentByRow() {
        String[] tableNames = this.reader.getTableNames();
        for (int table = 0; table < tableNames.length; ++table) {
            int rowCount = this.reader.getRowCount(table);
            AssertJUnit.assertEquals((int)rowCount, (int)this.reader.getRowCount(tableNames[table]));
            for (int row = 0; row < rowCount; ++row) {
                Object[] rowByIndex = this.reader.getRowData(row, table);
                Object[] rowByName = this.reader.getRowData(row, tableNames[table]);
                AssertJUnit.assertNotNull((Object)rowByIndex);
                AssertJUnit.assertNotNull((Object)rowByName);
                AssertJUnit.assertEquals((int)rowByIndex.length, (int)rowByName.length);
                for (int col = 0; col < rowByIndex.length; ++col) {
                    AssertJUnit.assertEquals((Object)rowByIndex[col], (Object)rowByName[col]);
                }
            }
        }
    }

    @Test(expectedExceptions={ArrayIndexOutOfBoundsException.class})
    public void testRowDataTableIndexTooSmall() {
        this.reader.getRowData(0, -1);
    }

    @Test(expectedExceptions={ArrayIndexOutOfBoundsException.class})
    public void testRowDataTableIndexTooLarge() {
        this.reader.getRowData(0, this.reader.getTableCount());
    }

    @Test
    public void testRowDataInvalidTableNames() {
        AssertJUnit.assertNull((Object)this.reader.getRowData(0, null));
        AssertJUnit.assertNull((Object)this.reader.getRowData(0, INVALID_TABLE));
    }

    @Test(expectedExceptions={ArrayIndexOutOfBoundsException.class})
    public void testRowDataByIndexIndexTooSmall() {
        this.reader.getRowData(-1, 0);
    }

    @Test(expectedExceptions={ArrayIndexOutOfBoundsException.class})
    public void testRowDataByIndexIndexTooLarge() {
        this.reader.getRowData(this.reader.getRowCount(0), 0);
    }

    @Test(expectedExceptions={ArrayIndexOutOfBoundsException.class})
    public void testRowDataByNameIndexTooSmall() {
        String tableName = this.reader.getTableNames()[0];
        this.reader.getRowData(-1, tableName);
    }

    @Test(expectedExceptions={ArrayIndexOutOfBoundsException.class})
    public void testRowDataByNameIndexTooLarge() {
        String tableName = this.reader.getTableNames()[0];
        this.reader.getRowData(this.reader.getRowCount(tableName), tableName);
    }

    @Test(expectedExceptions={ArrayIndexOutOfBoundsException.class})
    public void testDataTableIndexTooSmall() {
        this.reader.getTableData(-1);
    }

    @Test(expectedExceptions={ArrayIndexOutOfBoundsException.class})
    public void testDataTableIndexTooLarge() {
        this.reader.getTableData(this.reader.getTableCount());
    }

    @Test
    public void testDataInvalidTableNames() {
        AssertJUnit.assertNull((Object)this.reader.getTableData(null));
        AssertJUnit.assertNull((Object)this.reader.getTableData(INVALID_TABLE));
    }
}

