/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in.LeicaMicrosystemsMetadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import loci.common.DateTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.LeicaMicrosystemsMetadata.LMSFileReader;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.Timestamp;

public class MetadataStoreInitializer {
    private LMSFileReader r;
    MetadataStore store;
    private int nextChannel = 0;

    public MetadataStoreInitializer(LMSFileReader reader) {
        this.r = reader;
        this.store = this.r.makeFilterMetadata();
    }

    public void initStandDetails(int series) throws FormatException {
        String instrumentID = MetadataTools.createLSID("Instrument", series);
        this.store.setInstrumentID(instrumentID, series);
        int index = this.getTileIndex(series);
        this.store.setMicroscopeModel(this.r.metaTemp.microscopeModels[index], series);
        this.store.setMicroscopeType(MetadataTools.getMicroscopeType("Other"), series);
        String objectiveID = MetadataTools.createLSID("Objective", series, 0);
        this.store.setObjectiveID(objectiveID, series, 0);
        this.store.setObjectiveLensNA(this.r.metaTemp.lensNA[index], series, 0);
        this.store.setObjectiveSerialNumber(this.r.metaTemp.serialNumber[index], series, 0);
        if (this.r.metaTemp.magnification[index] != null) {
            this.store.setObjectiveNominalMagnification(this.r.metaTemp.magnification[index], series, 0);
        }
        if (this.r.metaTemp.immersions[index] != null) {
            this.store.setObjectiveImmersion(MetadataTools.getImmersion(this.r.metaTemp.immersions[index]), series, 0);
        }
        if (this.r.metaTemp.corrections[index] != null) {
            this.store.setObjectiveCorrection(MetadataTools.getCorrection(this.r.metaTemp.corrections[index]), series, 0);
        }
        this.store.setObjectiveModel(this.r.metaTemp.objectiveModels[index], series, 0);
        this.store.setImageInstrumentRef(instrumentID, series);
        this.store.setObjectiveSettingsID(objectiveID, series);
        this.store.setObjectiveSettingsRefractiveIndex(this.r.metaTemp.refractiveIndex[index], series);
    }

    public void initFilterModels(int series) {
        int index = this.getTileIndex(series);
        if (this.r.metaTemp.cutIns.get(index) != null && this.r.metaTemp.filterModels.get(index) != null) {
            if (this.r.metaTemp.cutIns.get(index).size() >= this.r.metaTemp.filterModels.get(index).size() * 2) {
                int diff = this.r.metaTemp.cutIns.get(index).size() - this.r.metaTemp.filterModels.get(index).size();
                for (int q = 0; q < diff; ++q) {
                    this.r.metaTemp.cutIns.get(index).remove(this.r.metaTemp.filterModels.get(index).size());
                }
            }
            for (int filter = 0; filter < this.r.metaTemp.cutIns.get(index).size(); ++filter) {
                String filterID = MetadataTools.createLSID("Filter", series, filter);
                this.store.setFilterID(filterID, series, filter);
                if (this.r.metaTemp.filterModels.get(index) != null && filter < this.r.metaTemp.filterModels.get(index).size()) {
                    this.store.setFilterModel(this.r.metaTemp.filterModels.get(index).get(filter), series, filter);
                }
                this.store.setTransmittanceRangeCutIn(this.r.metaTemp.cutIns.get(index).get(filter), series, filter);
                this.store.setTransmittanceRangeCutOut(this.r.metaTemp.cutOuts.get(index).get(filter), series, filter);
            }
        }
    }

    public void initLasers(int series) {
        List frap;
        int index = this.getTileIndex(series);
        List lasers = this.r.metaTemp.laserWavelength.size() > index ? (List)this.r.metaTemp.laserWavelength.get(index) : null;
        List laserIntensities = this.r.metaTemp.laserIntensity.size() > index ? (List)this.r.metaTemp.laserIntensity.get(index) : null;
        List active = this.r.metaTemp.laserActive.size() > index ? (List)this.r.metaTemp.laserActive.get(index) : null;
        List list = frap = this.r.metaTemp.laserFrap.size() > index ? (List)this.r.metaTemp.laserFrap.get(index) : null;
        if (lasers != null) {
            int laserIndex = 0;
            while (laserIndex < lasers.size()) {
                if ((Double)lasers.get(laserIndex) == 0.0) {
                    lasers.remove(laserIndex);
                    continue;
                }
                ++laserIndex;
            }
            for (int laser = 0; laser < lasers.size(); ++laser) {
                String id = MetadataTools.createLSID("LightSource", series, laser);
                this.store.setLaserID(id, series, laser);
                this.store.setLaserType(LaserType.OTHER, series, laser);
                this.store.setLaserLaserMedium(LaserMedium.OTHER, series, laser);
                Double wavelength = (Double)lasers.get(laser);
                Length wave = FormatTools.getWavelength(wavelength);
                if (wave == null) continue;
                this.store.setLaserWavelength(wave, series, laser);
            }
            HashSet<Integer> ignoredChannels = new HashSet<Integer>();
            ArrayList<Integer> validIntensities = new ArrayList<Integer>();
            int size = lasers.size();
            int channel = 0;
            HashSet<Integer> channels = new HashSet<Integer>();
            for (int laser = 0; laser < laserIntensities.size(); ++laser) {
                double intensity = (Double)laserIntensities.get(laser);
                channel = laser / size;
                if (intensity < 100.0) {
                    validIntensities.add(laser);
                    channels.add(channel);
                }
                ignoredChannels.add(channel);
            }
            ignoredChannels.removeAll(channels);
            int s2 = validIntensities.size();
            HashSet<Integer> toRemove = new HashSet<Integer>();
            int as = active.size();
            for (int j = 0; j < s2; ++j) {
                int jj;
                if (j < as && !((Boolean)active.get(j)).booleanValue()) {
                    toRemove.add((Integer)validIntensities.get(j));
                }
                if ((jj = j + 1) >= s2) continue;
                int v = (Integer)validIntensities.get(j) / size;
                int vv = (Integer)validIntensities.get(jj) / size;
                if (vv != v) continue;
                toRemove.add((Integer)validIntensities.get(j));
                toRemove.add((Integer)validIntensities.get(jj));
                ignoredChannels.add(j);
            }
            if (toRemove.size() > 0) {
                validIntensities.removeAll(toRemove);
            }
            boolean noNames = true;
            if (this.r.metaTemp.channelNames[index] != null) {
                for (String name : this.r.metaTemp.channelNames[index]) {
                    if (name == null || name.equals("")) continue;
                    noNames = false;
                    break;
                }
            }
            if (!noNames && frap != null) {
                for (int k = 0; k < frap.size(); ++k) {
                    if (((Boolean)frap.get(k)).booleanValue()) continue;
                    noNames = true;
                    break;
                }
            }
            int nextFilter = 0;
            int k = 0;
            while (k < validIntensities.size()) {
                int laserArrayIndex = (Integer)validIntensities.get(k);
                double intensity = (Double)laserIntensities.get(laserArrayIndex);
                int laser = laserArrayIndex % lasers.size();
                Double wavelength = (Double)lasers.get(laser);
                if (wavelength != 0.0) {
                    while (ignoredChannels.contains(this.nextChannel)) {
                        ++this.nextChannel;
                    }
                    while (this.r.metaTemp.channelNames != null && this.nextChannel < this.r.getEffectiveSizeC() && this.r.metaTemp.channelNames[index] != null && (this.r.metaTemp.channelNames[index][this.nextChannel] == null || this.r.metaTemp.channelNames[index][this.nextChannel].equals("")) && !noNames) {
                        ++this.nextChannel;
                    }
                    if (this.nextChannel < this.r.getEffectiveSizeC()) {
                        String id = MetadataTools.createLSID("LightSource", series, laser);
                        this.store.setChannelLightSourceSettingsID(id, series, this.nextChannel);
                        this.store.setChannelLightSourceSettingsAttenuation(new PercentFraction(Float.valueOf((float)intensity / 100.0f)), series, this.nextChannel);
                        Length ex = FormatTools.getExcitationWavelength(wavelength);
                        if (ex != null) {
                            this.store.setChannelExcitationWavelength(ex, series, this.nextChannel);
                        }
                        if (wavelength > 0.0 && this.r.metaTemp.cutIns.get(index) != null && nextFilter < this.r.metaTemp.cutIns.get(index).size()) {
                            Double cutIn = this.r.metaTemp.cutIns.get(index).get(nextFilter).value(UNITS.NANOMETER).doubleValue();
                            while (cutIn - wavelength > 20.0 && ++nextFilter < this.r.metaTemp.cutIns.get(index).size()) {
                                cutIn = this.r.metaTemp.cutIns.get(index).get(nextFilter).value(UNITS.NANOMETER).doubleValue();
                            }
                            if (nextFilter < this.r.metaTemp.cutIns.get(index).size()) {
                                ++nextFilter;
                            }
                        }
                    }
                }
                ++k;
                ++this.nextChannel;
            }
        }
    }

    public void initDetectorModels(int series) {
        int firstDetector;
        List detectors;
        int index = this.getTileIndex(series);
        List list = detectors = this.r.metaTemp.detectorModels.size() > index ? (List)this.r.metaTemp.detectorModels.get(index) : null;
        if (detectors != null) {
            this.nextChannel = 0;
            int start = detectors.size() - this.r.getEffectiveSizeC();
            if (start < 0) {
                start = 0;
            }
            for (int detector = start; detector < detectors.size(); ++detector) {
                int detectorIndex;
                int dIndex = detector - start;
                String detectorID = MetadataTools.createLSID("Detector", series, dIndex);
                this.store.setDetectorID(detectorID, series, dIndex);
                this.store.setDetectorModel((String)detectors.get(detector), series, dIndex);
                this.store.setDetectorZoom(this.r.metaTemp.zooms[index], series, dIndex);
                this.store.setDetectorType(DetectorType.PMT, series, dIndex);
                if (this.r.metaTemp.activeDetector.get(index) == null || (detectorIndex = this.r.metaTemp.activeDetector.get(index).size() - this.r.getEffectiveSizeC() + dIndex) < 0 || detectorIndex >= this.r.metaTemp.activeDetector.get(index).size() || !this.r.metaTemp.activeDetector.get(index).get(detectorIndex).booleanValue() || this.r.metaTemp.detectorOffsets[index] == null || this.nextChannel >= this.r.metaTemp.detectorOffsets[index].length) continue;
                this.store.setDetectorOffset(this.r.metaTemp.detectorOffsets[index][this.nextChannel++], series, dIndex);
            }
        }
        List activeDetectors = this.r.metaTemp.activeDetector.size() > index ? (List)this.r.metaTemp.activeDetector.get(index) : null;
        int nextDetector = firstDetector = activeDetectors == null ? 0 : activeDetectors.size() - this.r.getEffectiveSizeC();
        int nextFilter = 0;
        int nextFilterDetector = 0;
        if (activeDetectors != null && activeDetectors.size() > this.r.metaTemp.cutIns.get(index).size() && ((Boolean)activeDetectors.get(activeDetectors.size() - 1)).booleanValue() && ((Boolean)activeDetectors.get(activeDetectors.size() - 2)).booleanValue()) {
            nextFilterDetector = activeDetectors.size() - this.r.metaTemp.cutIns.get(index).size();
            if (this.r.metaTemp.cutIns.get(index).size() > this.r.metaTemp.filterModels.get(index).size()) {
                nextFilterDetector += this.r.metaTemp.filterModels.get(index).size();
                nextFilter += this.r.metaTemp.filterModels.get(index).size();
            }
        }
        for (int c = 0; c < this.r.getEffectiveSizeC(); ++c) {
            String filterID;
            Length ex;
            if (activeDetectors != null) {
                while (nextDetector >= 0 && nextDetector < activeDetectors.size() && !((Boolean)activeDetectors.get(nextDetector)).booleanValue()) {
                    ++nextDetector;
                }
                if (nextDetector < activeDetectors.size() && detectors != null && nextDetector - firstDetector < detectors.size()) {
                    String detectorID = MetadataTools.createLSID("Detector", series, nextDetector - firstDetector);
                    this.store.setDetectorSettingsID(detectorID, series, c);
                    ++nextDetector;
                    if (this.r.metaTemp.detectorOffsets[index] != null && c < this.r.metaTemp.detectorOffsets[index].length) {
                        this.store.setDetectorSettingsOffset(this.r.metaTemp.detectorOffsets[index][c], series, c);
                    }
                    if (this.r.metaTemp.gains[index] != null) {
                        this.store.setDetectorSettingsGain(this.r.metaTemp.gains[index][c], series, c);
                    }
                }
            }
            if (this.r.metaTemp.channelNames[index] != null) {
                this.store.setChannelName(this.r.metaTemp.channelNames[index][c], series, c);
            }
            if (this.r.metaTemp.pinholes[index] != null) {
                this.store.setChannelPinholeSize(new Length(this.r.metaTemp.pinholes[index], UNITS.MICROMETER), series, c);
            }
            if (this.r.metaTemp.exWaves[index] != null && this.r.metaTemp.exWaves[index][c] != null && this.r.metaTemp.exWaves[index][c] > 1.0 && (ex = FormatTools.getExcitationWavelength(this.r.metaTemp.exWaves[index][c])) != null) {
                this.store.setChannelExcitationWavelength(ex, series, c);
            }
            Color channelColor = this.r.metaTemp.channelColors.get(index).get(c);
            if (!this.r.isRGB()) {
                this.store.setChannelColor(channelColor, series, c);
            }
            if ((Integer)channelColor.getValue() == -1 || nextFilter < 0) continue;
            if (nextDetector - firstDetector != this.r.getSizeC() && this.r.metaTemp.cutIns.get(index) != null && nextDetector >= this.r.metaTemp.cutIns.get(index).size()) {
                while (nextFilterDetector < firstDetector) {
                    filterID = MetadataTools.createLSID("Filter", series, nextFilter);
                    this.store.setFilterID(filterID, series, nextFilter);
                    ++nextFilterDetector;
                    ++nextFilter;
                }
            }
            while (activeDetectors != null && nextFilterDetector < activeDetectors.size() && !((Boolean)activeDetectors.get(nextFilterDetector)).booleanValue()) {
                filterID = MetadataTools.createLSID("Filter", series, nextFilter);
                this.store.setFilterID(filterID, series, nextFilter);
                ++nextFilterDetector;
                ++nextFilter;
            }
            filterID = MetadataTools.createLSID("Filter", series, nextFilter);
            this.store.setFilterID(filterID, series, nextFilter);
            this.store.setLightPathEmissionFilterRef(filterID, series, c, 0);
            ++nextFilterDetector;
            ++nextFilter;
        }
    }

    public void initImageDetails(int series) {
        int index = this.getTileIndex(series);
        this.store.setImageDescription(this.r.metaTemp.descriptions[index], series);
        if (this.r.metaTemp.acquiredDate[index] > 0.0) {
            this.store.setImageAcquisitionDate(new Timestamp(DateTools.convertDate((long)(this.r.metaTemp.acquiredDate[index] * 1000.0), 1, "yyyy-MM-dd'T'HH:mm:ss", false)), series);
        }
        this.store.setImageName(this.r.metaTemp.imageNames[index].trim(), series);
        Length sizeX = FormatTools.getPhysicalSizeX(this.r.metaTemp.physicalSizeXs.get(index));
        Length sizeY = FormatTools.getPhysicalSizeY(this.r.metaTemp.physicalSizeYs.get(index));
        Length sizeZ = FormatTools.getPhysicalSizeZ(this.r.metaTemp.zSteps[index]);
        if (sizeX != null) {
            this.store.setPixelsPhysicalSizeX(sizeX, series);
        }
        if (sizeY != null) {
            this.store.setPixelsPhysicalSizeY(sizeY, series);
        }
        if (sizeZ != null) {
            this.store.setPixelsPhysicalSizeZ(sizeZ, series);
        }
        if (this.r.metaTemp.tSteps[index] != null) {
            this.store.setPixelsTimeIncrement(new Time(this.r.metaTemp.tSteps[index], UNITS.SECOND), series);
        }
        int roiCount = 0;
        for (int image = 0; image < this.r.getImageCount(); ++image) {
            int c;
            Length xPos = this.r.metaTemp.posX[index];
            Length yPos = this.r.metaTemp.posY[index];
            if (series < this.r.metaTemp.fieldPosX.size() && this.r.metaTemp.fieldPosX.get(series) != null) {
                xPos = this.r.metaTemp.fieldPosX.get(series);
            }
            if (series < this.r.metaTemp.fieldPosY.size() && this.r.metaTemp.fieldPosY.get(series) != null) {
                yPos = this.r.metaTemp.fieldPosY.get(series);
            }
            if (this.r.metaTemp.swapXY[index]) {
                Length temp = xPos;
                xPos = yPos;
                yPos = temp;
            }
            xPos = this.checkFlip(this.r.metaTemp.flipX[index], xPos);
            yPos = this.checkFlip(this.r.metaTemp.flipY[index], yPos);
            if (xPos != null) {
                this.store.setPlanePositionX(xPos, series, image);
            }
            if (yPos != null) {
                this.store.setPlanePositionY(yPos, series, image);
            }
            this.store.setPlanePositionZ(this.r.metaTemp.posZ[index], series, image);
            if (this.r.metaTemp.timestamps[index] != null && this.r.metaTemp.timestamps[index][image] != null) {
                double timestamp = this.r.metaTemp.timestamps[index][image];
                if (this.r.metaTemp.timestamps[index][0] == this.r.metaTemp.acquiredDate[index]) {
                    timestamp -= this.r.metaTemp.acquiredDate[index];
                } else if (timestamp == this.r.metaTemp.acquiredDate[index] && image > 0) {
                    timestamp = this.r.metaTemp.timestamps[index][0];
                }
                this.store.setPlaneDeltaT(new Time(timestamp, UNITS.SECOND), series, image);
            }
            if (this.r.metaTemp.expTimes[index] == null || this.r.metaTemp.expTimes[index][c = this.r.getZCTCoords(image)[1]] == null) continue;
            this.store.setPlaneExposureTime(new Time(this.r.metaTemp.expTimes[index][c], UNITS.SECOND), series, image);
        }
        if (this.r.metaTemp.imageROIs[index] != null) {
            for (int roi = 0; roi < this.r.metaTemp.imageROIs[index].length; ++roi) {
                if (this.r.metaTemp.imageROIs[index][roi] == null) continue;
                this.r.metaTemp.imageROIs[index][roi].storeROI(this.store, series, roiCount++, roi, this.r.getCore().get((int)series).sizeX, this.r.getCore().get((int)series).sizeY, this.r.metaTemp.alternateCenter, this.r.getMetadataOptions().getMetadataLevel());
            }
        }
    }

    public void initMetadataStore() throws FormatException, IOException {
        int i;
        for (i = 0; i < this.r.metaTemp.imageNames.length; ++i) {
            this.r.setSeries(i);
            this.r.addSeriesMeta("Image name", this.r.metaTemp.imageNames[i]);
        }
        this.r.setSeries(0);
        MetadataTools.populatePixels(this.store, this.r, true, false);
        for (i = 0; i < this.r.getSeriesCount(); ++i) {
            this.r.setSeries(i);
            this.initStandDetails(i);
            this.initFilterModels(i);
            this.initLasers(i);
            this.initDetectorModels(i);
            this.initImageDetails(i);
        }
    }

    public int getTileIndex(int coreIndex) {
        int count = 0;
        for (int tile = 0; tile < this.r.metaTemp.tileCount.length; ++tile) {
            if (coreIndex < count + this.r.metaTemp.tileCount[tile]) {
                return tile;
            }
            count += this.r.metaTemp.tileCount[tile];
        }
        return -1;
    }

    public Length checkFlip(boolean flip, Length pos) {
        if (flip && pos != null) {
            pos = new Length(-pos.value().doubleValue(), pos.unit());
        }
        return pos;
    }
}

