/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode;

import java.io.Serializable;
import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.BrentSolver;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.StepInterpolator;
import org.apache.commons.math.ode.SwitchingFunction;

class SwitchState
implements Serializable {
    private static final long serialVersionUID = -7307007422156119622L;
    private SwitchingFunction function;
    private double maxCheckInterval;
    private double convergence;
    private int maxIterationCount;
    private double t0;
    private double g0;
    private boolean g0Positive;
    private boolean pendingEvent;
    private double pendingEventTime;
    private double previousEventTime;
    private boolean increasing;
    private int nextAction;

    public SwitchState(SwitchingFunction function, double maxCheckInterval, double convergence, int maxIterationCount) {
        this.function = function;
        this.maxCheckInterval = maxCheckInterval;
        this.convergence = Math.abs(convergence);
        this.maxIterationCount = maxIterationCount;
        this.t0 = Double.NaN;
        this.g0 = Double.NaN;
        this.g0Positive = true;
        this.pendingEvent = false;
        this.pendingEventTime = Double.NaN;
        this.previousEventTime = Double.NaN;
        this.increasing = true;
        this.nextAction = 3;
    }

    public void reinitializeBegin(double t0, double[] y0) throws FunctionEvaluationException {
        this.t0 = t0;
        this.g0 = this.function.g(t0, y0);
        this.g0Positive = this.g0 >= 0.0;
    }

    public boolean evaluateStep(final StepInterpolator interpolator) throws DerivativeException, FunctionEvaluationException, ConvergenceException {
        try {
            double t1 = interpolator.getCurrentTime();
            int n = Math.max(1, (int)Math.ceil(Math.abs(t1 - this.t0) / this.maxCheckInterval));
            double h2 = (t1 - this.t0) / (double)n;
            double ta = this.t0;
            double ga = this.g0;
            double tb = this.t0 + (t1 > this.t0 ? this.convergence : -this.convergence);
            for (int i = 0; i < n; ++i) {
                interpolator.setInterpolatedTime(tb += h2);
                double gb = this.function.g(tb, interpolator.getInterpolatedState());
                if (this.g0Positive ^ gb >= 0.0) {
                    this.increasing = gb >= ga;
                    BrentSolver solver = new BrentSolver(new UnivariateRealFunction(){

                        public double value(double t2) throws FunctionEvaluationException {
                            try {
                                interpolator.setInterpolatedTime(t2);
                                return SwitchState.this.function.g(t2, interpolator.getInterpolatedState());
                            }
                            catch (DerivativeException e) {
                                throw new FunctionEvaluationException(t2, (Throwable)e);
                            }
                        }
                    });
                    solver.setAbsoluteAccuracy(this.convergence);
                    solver.setMaximalIterationCount(this.maxIterationCount);
                    double root = solver.solve(ta, tb);
                    if (!Double.isNaN(this.previousEventTime) && !(Math.abs(this.previousEventTime - root) > this.convergence)) continue;
                    this.pendingEventTime = root;
                    if (this.pendingEvent && Math.abs(t1 - this.pendingEventTime) <= this.convergence) {
                        return false;
                    }
                    this.pendingEvent = true;
                    return true;
                }
                ta = tb;
                ga = gb;
            }
            this.pendingEvent = false;
            this.pendingEventTime = Double.NaN;
            return false;
        }
        catch (FunctionEvaluationException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof DerivativeException) {
                throw (DerivativeException)cause;
            }
            throw e;
        }
    }

    public double getEventTime() {
        return this.pendingEventTime;
    }

    public void stepAccepted(double t2, double[] y) throws FunctionEvaluationException {
        this.t0 = t2;
        this.g0 = this.function.g(t2, y);
        if (this.pendingEvent) {
            this.previousEventTime = t2;
            this.g0Positive = this.increasing;
            this.nextAction = this.function.eventOccurred(t2, y);
        } else {
            this.g0Positive = this.g0 >= 0.0;
            this.nextAction = 3;
        }
    }

    public boolean stop() {
        return this.nextAction == 0;
    }

    public boolean reset(double t2, double[] y) {
        if (!this.pendingEvent) {
            return false;
        }
        if (this.nextAction == 1) {
            this.function.resetState(t2, y);
        }
        this.pendingEvent = false;
        this.pendingEventTime = Double.NaN;
        return this.nextAction == 1 || this.nextAction == 2;
    }
}

