/*
 * Decompiled with CFR 0.152.
 */
package com.bc.zarr;

import com.bc.zarr.Compressor;
import com.bc.zarr.CompressorFactory;
import com.bc.zarr.DataType;
import com.bc.zarr.DimensionSeparator;
import java.nio.ByteOrder;
import java.util.Arrays;

public class ArrayParams {
    private int[] shape;
    private int[] chunks;
    private boolean chunked = true;
    private DataType dataType = DataType.f8;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private Number fillValue = 0;
    private Compressor compressor = CompressorFactory.createDefaultCompressor();
    private DimensionSeparator separator = DimensionSeparator.DOT;

    public ArrayParams shape(int ... shape) {
        this.shape = shape;
        return this;
    }

    public ArrayParams chunks(int ... chunks) {
        this.chunks = chunks;
        return this;
    }

    public ArrayParams chunked(boolean chunked) {
        this.chunked = chunked;
        return this;
    }

    public ArrayParams dataType(DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public ArrayParams byteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        return this;
    }

    public ArrayParams fillValue(Number fillValue) {
        this.fillValue = fillValue;
        return this;
    }

    public ArrayParams compressor(Compressor compressor) {
        if (compressor == null) {
            compressor = CompressorFactory.nullCompressor;
        }
        this.compressor = compressor;
        return this;
    }

    public ArrayParams dimensionSeparator(DimensionSeparator sep) {
        this.separator = sep == null ? DimensionSeparator.DOT : sep;
        return this;
    }

    Params build() {
        int i;
        if (this.shape == null || this.shape.length == 0) {
            throw new IllegalArgumentException("Shape must be given.");
        }
        if (this.chunks == null) {
            if (this.chunked) {
                this.chunks = new int[this.shape.length];
                for (i = 0; i < this.shape.length; ++i) {
                    int shapeDim = this.shape[i];
                    int numChunks = shapeDim / 512;
                    if (numChunks > 0) {
                        int chunkDim = shapeDim / (numChunks + 1);
                        if (shapeDim % chunkDim == 0) {
                            this.chunks[i] = chunkDim;
                            continue;
                        }
                        this.chunks[i] = chunkDim + 1;
                        continue;
                    }
                    this.chunks[i] = shapeDim;
                }
            } else {
                this.chunks = Arrays.copyOf(this.shape, this.shape.length);
            }
        }
        if (this.shape.length != this.chunks.length) {
            throw new IllegalArgumentException("Chunks must have the same number of dimensions as shape. Expected: " + this.shape.length + " but was " + this.chunks.length + " !");
        }
        for (i = 0; i < this.chunks.length; ++i) {
            int chunkDim = this.chunks[i];
            if (chunkDim >= 1) continue;
            this.chunks[i] = this.shape[i];
        }
        return new Params(this.shape, this.chunks, this.dataType, this.byteOrder, this.fillValue, this.compressor, this.separator);
    }

    static /* synthetic */ int[] access$102(ArrayParams x0, int[] x1) {
        x0.shape = x1;
        return x1;
    }

    static /* synthetic */ int[] access$202(ArrayParams x0, int[] x1) {
        x0.chunks = x1;
        return x1;
    }

    public static final class Params {
        private final int[] shape;
        private final int[] chunks;
        private final DataType dataType;
        private final ByteOrder byteOrder;
        private final Number fillValue;
        private final Compressor compressor;
        private final DimensionSeparator separator;

        private Params(int[] shape, int[] chunks, DataType dataType, ByteOrder byteOrder, Number fillValue, Compressor compressor, DimensionSeparator separator) {
            this.shape = shape;
            this.chunks = chunks;
            this.dataType = dataType;
            this.byteOrder = byteOrder;
            this.fillValue = fillValue;
            this.compressor = compressor;
            this.separator = separator;
        }

        public int[] getShape() {
            return this.shape;
        }

        public int[] getChunks() {
            return this.chunks;
        }

        public boolean isChunked() {
            return !Arrays.equals(this.shape, this.chunks);
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public ByteOrder getByteOrder() {
            return this.byteOrder;
        }

        public Number getFillValue() {
            return this.fillValue;
        }

        public Compressor getCompressor() {
            return this.compressor;
        }

        public DimensionSeparator getDimensionSeparator() {
            return this.separator;
        }

        public ArrayParams toBuilder() {
            ArrayParams builder = new ArrayParams();
            ArrayParams.access$102(builder, this.getShape());
            ArrayParams.access$202(builder, this.getChunks());
            builder.chunked = this.isChunked();
            builder.dataType = this.getDataType();
            builder.byteOrder = this.getByteOrder();
            builder.fillValue = this.getFillValue();
            builder.compressor = this.getCompressor();
            builder.separator = this.getDimensionSeparator();
            return builder;
        }
    }
}

