/*
 * Decompiled with CFR 0.152.
 */
package com.bc.zarr.chunk;

import com.bc.zarr.Compressor;
import com.bc.zarr.chunk.ChunkReaderWriter;
import com.bc.zarr.storage.Store;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ucar.ma2.Array;
import ucar.ma2.DataType;

public class ChunkReaderWriterImpl_Byte
extends ChunkReaderWriter {
    public ChunkReaderWriterImpl_Byte(Compressor compressor, int[] chunkShape, Number fill, Store store) {
        super(null, compressor, chunkShape, fill, store);
    }

    @Override
    public Array read(String storeKey) throws IOException {
        try (InputStream is = this.store.getInputStream(storeKey);){
            if (is != null) {
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    this.compressor.uncompress(is, os);
                    byte[] b = os.toByteArray();
                    Array array = Array.factory(DataType.BYTE, this.chunkShape, (Object)b);
                    return array;
                }
            }
            Array array = this.createFilled(DataType.BYTE);
            return array;
        }
    }

    @Override
    public void write(String storeKey, Array array) throws IOException {
        byte[] bytes = (byte[])array.get1DJavaArray(DataType.BYTE);
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);
             OutputStream os = this.store.getOutputStream(storeKey);){
            this.compressor.compress(is, os);
        }
    }
}

