/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.ClassList;
import loci.formats.CoreMetadata;
import loci.formats.FileInfo;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.Modulo;
import loci.formats.UnknownFormatException;
import loci.formats.codec.Codec;
import loci.formats.codec.CodecOptions;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;
import loci.formats.meta.MetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageReader
implements IFormatReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageReader.class);
    private static ClassList<IFormatReader> defaultClasses;
    private IFormatReader[] readers;
    private String[] suffixes;
    private String currentId;
    private int current;
    private boolean allowOpen = true;
    private static AtomicBoolean raisedException;

    public static ClassList<IFormatReader> getDefaultReaderClasses() {
        if (defaultClasses == null) {
            try {
                defaultClasses = new ClassList<IFormatReader>("readers.txt", IFormatReader.class);
            }
            catch (IOException exc) {
                defaultClasses = new ClassList<IFormatReader>(IFormatReader.class);
                LOGGER.info("Could not parse class list; using default classes", (Throwable)exc);
            }
        }
        return defaultClasses;
    }

    private boolean isOmero(String id) {
        return id != null && id.toLowerCase().startsWith("omero:") && id.indexOf("\n") > 0;
    }

    public ImageReader() {
        this(ImageReader.getDefaultReaderClasses());
    }

    public ImageReader(ClassList<IFormatReader> classList) {
        ArrayList<IFormatReader> list = new ArrayList<IFormatReader>();
        Class<IFormatReader>[] c = classList.getClasses();
        DynamicMetadataOptions opt = new DynamicMetadataOptions();
        for (int i = 0; i < c.length; ++i) {
            IFormatReader reader = null;
            try {
                reader = c[i].getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                reader.setMetadataOptions(opt);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            if (reader == null) {
                LOGGER.error("{} cannot be instantiated.", (Object)c[i].getName());
                continue;
            }
            list.add(reader);
        }
        this.readers = new IFormatReader[list.size()];
        list.toArray(this.readers);
    }

    public void setAllowOpenFiles(boolean allowOpen) {
        this.allowOpen = allowOpen;
    }

    public String getFormat(String id) throws FormatException, IOException {
        return this.getReader(id).getFormat();
    }

    public IFormatReader getReader(String id) throws FormatException, IOException {
        boolean invalid;
        if (id.endsWith(File.separator)) {
            id = id.substring(0, id.length() - 1);
        }
        boolean fake = id != null && id.toLowerCase().endsWith(".fake");
        boolean omero = this.isOmero(id);
        boolean bl = invalid = id != null && id.toLowerCase().endsWith(".filepart");
        if (!fake && !omero) {
            Location.checkValidId((String)id);
            if (new Location(id).length() == 0L) {
                LOGGER.error("File has length 0 and may be corrupt");
            }
        }
        if (!id.equals(this.currentId)) {
            boolean success = false;
            if (!invalid) {
                for (int i = 0; i < this.readers.length; ++i) {
                    if (!this.isThisType(this.readers[i], id, this.allowOpen)) continue;
                    this.current = i;
                    this.currentId = id;
                    success = true;
                    break;
                }
            }
            if (!success) {
                throw new UnknownFormatException("Unknown file format: " + id);
            }
        }
        return this.getReader();
    }

    public IFormatReader getReader() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.readers[this.current];
    }

    public IFormatReader getReader(Class<? extends IFormatReader> c) {
        for (int i = 0; i < this.readers.length; ++i) {
            if (!this.readers[i].getClass().equals(c)) continue;
            return this.readers[i];
        }
        return null;
    }

    public IFormatReader[] getReaders() {
        IFormatReader[] r = new IFormatReader[this.readers.length];
        System.arraycopy(this.readers, 0, r, 0, this.readers.length);
        return r;
    }

    @Override
    public Set<MetadataLevel> getSupportedMetadataLevels() {
        return this.getReaders()[0].getSupportedMetadataLevels();
    }

    @Override
    public MetadataOptions getMetadataOptions() {
        return this.getReaders()[0].getMetadataOptions();
    }

    @Override
    public void setMetadataOptions(MetadataOptions options) {
        for (IFormatReader reader : this.readers) {
            reader.setMetadataOptions(options);
        }
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        for (int i = 0; i < this.readers.length; ++i) {
            if (!this.isThisType(this.readers[i], name, open)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isThisType(byte[] block) {
        for (int i = 0; i < this.readers.length; ++i) {
            if (!this.isThisType(this.readers[i], block)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        for (int i = 0; i < this.readers.length; ++i) {
            if (!this.isThisType(this.readers[i], stream)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getImageCount() {
        return this.getReader().getImageCount();
    }

    @Override
    public boolean isRGB() {
        return this.getReader().isRGB();
    }

    @Override
    public int getSizeX() {
        return this.getReader().getSizeX();
    }

    @Override
    public int getSizeY() {
        return this.getReader().getSizeY();
    }

    @Override
    public int getSizeC() {
        return this.getReader().getSizeC();
    }

    @Override
    public int getSizeZ() {
        return this.getReader().getSizeZ();
    }

    @Override
    public int getSizeT() {
        return this.getReader().getSizeT();
    }

    @Override
    public int getPixelType() {
        return this.getReader().getPixelType();
    }

    @Override
    public int getBitsPerPixel() {
        return this.getReader().getBitsPerPixel();
    }

    @Override
    public int getEffectiveSizeC() {
        return this.getReader().getEffectiveSizeC();
    }

    @Override
    public int getRGBChannelCount() {
        return this.getReader().getRGBChannelCount();
    }

    @Override
    public boolean isIndexed() {
        return this.getReader().isIndexed();
    }

    @Override
    public boolean isFalseColor() {
        return this.getReader().isFalseColor();
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        return this.getReader().get8BitLookupTable();
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        return this.getReader().get16BitLookupTable();
    }

    @Override
    public Modulo getModuloZ() {
        return this.getReader().getModuloZ();
    }

    @Override
    public Modulo getModuloC() {
        return this.getReader().getModuloC();
    }

    @Override
    public Modulo getModuloT() {
        return this.getReader().getModuloT();
    }

    @Override
    public int getThumbSizeX() {
        return this.getReader().getThumbSizeX();
    }

    @Override
    public int getThumbSizeY() {
        return this.getReader().getThumbSizeY();
    }

    @Override
    public boolean isLittleEndian() {
        return this.getReader().isLittleEndian();
    }

    @Override
    public String getDimensionOrder() {
        return this.getReader().getDimensionOrder();
    }

    @Override
    public boolean isOrderCertain() {
        return this.getReader().isOrderCertain();
    }

    @Override
    public boolean isThumbnailSeries() {
        return this.getReader().isThumbnailSeries();
    }

    @Override
    public boolean isInterleaved() {
        return this.getReader().isInterleaved();
    }

    @Override
    public boolean isInterleaved(int subC) {
        return this.getReader().isInterleaved(subC);
    }

    @Override
    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.getReader().openBytes(no);
    }

    @Override
    public byte[] openBytes(int no, int x, int y, int w, int h) throws FormatException, IOException {
        return this.getReader().openBytes(no, x, y, w, h);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.getReader().openBytes(no, buf);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        return this.getReader().openBytes(no, buf, x, y, w, h);
    }

    @Override
    public Object openPlane(int no, int x, int y, int w, int h) throws FormatException, IOException {
        return this.getReader().openPlane(no, x, y, w, h);
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        return this.getReader().openThumbBytes(no);
    }

    @Override
    public int getSeriesCount() {
        return this.getReader().getSeriesCount();
    }

    @Override
    public void setSeries(int no) {
        this.getReader().setSeries(no);
    }

    @Override
    public int getSeries() {
        return this.getReader().getSeries();
    }

    @Override
    public String[] getUsedFiles() {
        return this.getReader().getUsedFiles();
    }

    @Override
    public String[] getUsedFiles(boolean noPixels) {
        return this.getReader().getUsedFiles(noPixels);
    }

    @Override
    public String[] getSeriesUsedFiles() {
        return this.getReader().getSeriesUsedFiles();
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        return this.getReader().getSeriesUsedFiles(noPixels);
    }

    @Override
    public FileInfo[] getAdvancedUsedFiles(boolean noPixels) {
        return this.getReader().getAdvancedUsedFiles(noPixels);
    }

    @Override
    public FileInfo[] getAdvancedSeriesUsedFiles(boolean noPixels) {
        return this.getReader().getAdvancedSeriesUsedFiles(noPixels);
    }

    @Override
    public int getIndex(int z, int c, int t) {
        return this.getReader().getIndex(z, c, t);
    }

    @Override
    public int getIndex(int z, int c, int t, int moduloZ, int moduloC, int moduloT) {
        return this.getReader().getIndex(z, c, t, moduloZ, moduloC, moduloT);
    }

    @Override
    public int[] getZCTCoords(int index) {
        return this.getReader().getZCTCoords(index);
    }

    @Override
    public int[] getZCTModuloCoords(int index) {
        return this.getReader().getZCTModuloCoords(index);
    }

    @Override
    public Object getMetadataValue(String field) {
        return this.getReader().getMetadataValue(field);
    }

    @Override
    public Object getSeriesMetadataValue(String field) {
        return this.getReader().getSeriesMetadataValue(field);
    }

    @Override
    public Hashtable<String, Object> getGlobalMetadata() {
        return this.getReader().getGlobalMetadata();
    }

    @Override
    public Hashtable<String, Object> getSeriesMetadata() {
        return this.getReader().getSeriesMetadata();
    }

    @Override
    public List<CoreMetadata> getCoreMetadataList() {
        return this.getReader().getCoreMetadataList();
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].close(fileOnly);
        }
        if (!fileOnly) {
            this.currentId = null;
        }
    }

    @Override
    public void setGroupFiles(boolean group) {
        FormatTools.assertId(this.currentId, false, 2);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setGroupFiles(group);
        }
    }

    @Override
    public boolean isGroupFiles() {
        return this.readers[0].isGroupFiles();
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return this.getReader(id).fileGroupOption(id);
    }

    @Override
    public void setFillColor(Byte fill) {
        for (IFormatReader r : this.readers) {
            r.setFillColor(fill);
        }
    }

    @Override
    public Byte getFillColor() {
        return this.getReader().getFillColor();
    }

    @Override
    public boolean isMetadataComplete() {
        return this.getReader().isMetadataComplete();
    }

    @Override
    public void setNormalized(boolean normalize) {
        FormatTools.assertId(this.currentId, false, 2);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setNormalized(normalize);
        }
    }

    @Override
    public boolean isNormalized() {
        return this.readers[0].isNormalized();
    }

    @Override
    public void setOriginalMetadataPopulated(boolean populate) {
        FormatTools.assertId(this.currentId, false, 1);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setOriginalMetadataPopulated(populate);
        }
    }

    @Override
    public boolean isOriginalMetadataPopulated() {
        return this.readers[0].isOriginalMetadataPopulated();
    }

    @Override
    public String getCurrentFile() {
        if (this.currentId == null) {
            return null;
        }
        return this.getReader().getCurrentFile();
    }

    @Override
    public void setMetadataFiltered(boolean filter) {
        FormatTools.assertId(this.currentId, false, 2);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setMetadataFiltered(filter);
        }
    }

    @Override
    public boolean isMetadataFiltered() {
        return this.readers[0].isMetadataFiltered();
    }

    @Override
    public void setMetadataStore(MetadataStore store) {
        FormatTools.assertId(this.currentId, false, 2);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setMetadataStore(store);
        }
    }

    @Override
    public MetadataStore getMetadataStore() {
        return this.getReader().getMetadataStore();
    }

    @Override
    public Object getMetadataStoreRoot() {
        return this.getReader().getMetadataStoreRoot();
    }

    @Override
    public IFormatReader[] getUnderlyingReaders() {
        return this.getReaders();
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return this.getReader(id).isSingleFile(id);
    }

    @Override
    public int getRequiredDirectories(String[] files) throws FormatException, IOException {
        return this.getReader(files[0]).getRequiredDirectories(files);
    }

    @Override
    public String getDatasetStructureDescription() {
        return this.getReader().getDatasetStructureDescription();
    }

    @Override
    public boolean hasCompanionFiles() {
        return this.getReader().hasCompanionFiles();
    }

    @Override
    public String[] getPossibleDomains(String id) throws FormatException, IOException {
        return this.getReader(id).getPossibleDomains(id);
    }

    @Override
    public String[] getDomains() {
        return this.getReader().getDomains();
    }

    @Override
    public int getOptimalTileWidth() {
        return this.getReader().getOptimalTileWidth();
    }

    @Override
    public int getOptimalTileHeight() {
        return this.getReader().getOptimalTileHeight();
    }

    @Override
    public int getCoreIndex() {
        return this.getReader().getCoreIndex();
    }

    @Override
    public void setCoreIndex(int no) {
        this.getReader().setCoreIndex(no);
    }

    @Override
    public int seriesToCoreIndex(int series) {
        return this.getReader().seriesToCoreIndex(series);
    }

    @Override
    public int coreIndexToSeries(int index) {
        return this.getReader().coreIndexToSeries(index);
    }

    @Override
    public int getResolutionCount() {
        return this.getReader().getResolutionCount();
    }

    @Override
    public void setResolution(int no) {
        this.getReader().setResolution(no);
    }

    @Override
    public int getResolution() {
        return this.getReader().getResolution();
    }

    @Override
    public boolean hasFlattenedResolutions() {
        return this.readers[0].hasFlattenedResolutions();
    }

    @Override
    public void setFlattenedResolutions(boolean flattened) {
        for (IFormatReader reader : this.readers) {
            reader.setFlattenedResolutions(flattened);
        }
    }

    @Override
    public boolean isThisType(String name) {
        return this.isThisType(name, false) || this.isThisType(name, true);
    }

    @Override
    public String getFormat() {
        return this.getReader().getFormat();
    }

    @Override
    public String[] getSuffixes() {
        if (this.suffixes == null) {
            HashSet<String> suffixSet = new HashSet<String>();
            for (int i = 0; i < this.readers.length; ++i) {
                String[] suf = this.readers[i].getSuffixes();
                for (int j = 0; j < suf.length; ++j) {
                    suffixSet.add(suf[j]);
                }
            }
            this.suffixes = new String[suffixSet.size()];
            suffixSet.toArray(this.suffixes);
            Arrays.sort(this.suffixes);
        }
        return this.suffixes;
    }

    @Override
    public Class<?> getNativeDataType() {
        return this.getReader().getNativeDataType();
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        IFormatReader currentReader = this.getReader(id);
        if (!this.isOmero(id)) {
            LOGGER.info("{} initializing {}", (Object)currentReader.getClass().getSimpleName(), (Object)id);
        }
        currentReader.setId(id);
    }

    @Override
    public void reopenFile() throws IOException {
        this.getReader().reopenFile();
    }

    @Override
    public void close() throws IOException {
        this.close(false);
    }

    @Override
    public int getTileRows(int no) {
        return this.getReader().getTileRows(no);
    }

    @Override
    public int getTileColumns(int no) {
        return this.getReader().getTileColumns(no);
    }

    @Override
    public byte[] openCompressedBytes(int no, int x, int y) throws FormatException, IOException {
        return this.getReader().openCompressedBytes(no, x, y);
    }

    @Override
    public byte[] openCompressedBytes(int no, byte[] buf, int x, int y) throws FormatException, IOException {
        return this.getReader().openCompressedBytes(no, buf, x, y);
    }

    @Override
    public Codec getTileCodec(int no) throws FormatException, IOException {
        return this.getReader().getTileCodec(no);
    }

    @Override
    public CodecOptions getTileCodecOptions(int no, int x, int y) throws FormatException, IOException {
        return this.getReader().getTileCodecOptions(no, x, y);
    }

    private boolean isThisType(IFormatReader reader, String name, boolean allowOpen) {
        try {
            return reader.isThisType(name, allowOpen);
        }
        catch (Exception e) {
            this.logIsThisTypeError(reader, e);
            return false;
        }
    }

    private boolean isThisType(IFormatReader reader, byte[] block) {
        try {
            return reader.isThisType(block);
        }
        catch (Exception e) {
            this.logIsThisTypeError(reader, e);
            return false;
        }
    }

    private boolean isThisType(IFormatReader reader, RandomAccessInputStream rais) {
        try {
            return reader.isThisType(rais);
        }
        catch (Exception e) {
            this.logIsThisTypeError(reader, e);
            return false;
        }
    }

    private void logIsThisTypeError(IFormatReader reader, Exception e) {
        LOGGER.debug("{} raised on isThisType", (Object)reader, (Object)e);
        if (raisedException.compareAndSet(false, true)) {
            LOGGER.error(" *** One or more readers is misbehaving. See the debug output for more information. e.g.:\n     {} -> {}('{}') ***", new Object[]{reader, e.getClass().getName(), e.getMessage()});
        }
    }

    static {
        raisedException = new AtomicBoolean(false);
    }
}

