/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.util;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageStatistics;
import ij.process.LUT;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.List;
import loci.formats.IFormatReader;
import loci.plugins.util.BFVirtualStack;
import loci.plugins.util.RecordedImageProcessor;

public class VirtualImagePlus
extends ImagePlus {
    private IFormatReader r;
    private LUT[] luts;

    public VirtualImagePlus(String title, ImageStack stack) {
        super(title, stack);
        this.getStatistics();
    }

    public void setReader(IFormatReader r) {
        this.r = r;
    }

    public void setLUTs(LUT[] luts) {
        this.luts = luts;
    }

    public synchronized void setSlice(int index) {
        super.setSlice(index);
        BFVirtualStack stack = null;
        if (this.getStack() instanceof BFVirtualStack) {
            stack = (BFVirtualStack)this.getStack();
            RecordedImageProcessor proc = stack.getRecordedProcessor();
            List<RecordedImageProcessor.MethodEntry> methods = stack.getMethodStack();
            if (methods != null) {
                proc.applyMethodStack(methods);
            }
            proc.getChild().setMinAndMax(this.getDisplayRangeMin(), this.getDisplayRangeMax());
            this.setProcessor(this.getTitle(), proc.getChild());
            int channel = this.getChannel() - 1;
            if (channel >= 0 && this.luts != null && channel < this.luts.length) {
                this.getProcessor().setColorModel((ColorModel)this.luts[channel]);
            }
            this.ip = proc;
        }
    }

    public void close() {
        super.close();
        try {
            this.r.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ImageStatistics getStatistics(int mOptions, int nBins, double histMin, double histMax) {
        if (this.ip instanceof RecordedImageProcessor) {
            RecordedImageProcessor currentProc = (RecordedImageProcessor)this.ip;
            this.ip = currentProc.getChild();
            this.setProcessor(this.getTitle(), this.ip);
            ImageStatistics s = super.getStatistics(mOptions, nBins, histMin, histMax);
            this.ip = currentProc;
            return s;
        }
        return super.getStatistics(mOptions, nBins, histMin, histMax);
    }
}

