/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.CharacterEncoding;
import java.io.UnsupportedEncodingException;

public final class StringUtils {
    private StringUtils() {
    }

    public static byte[] toBytes0Term(String s2, int maxCharacters, CharacterEncoding encoding) {
        try {
            return (String.valueOf(StringUtils.cut(s2, maxCharacters)) + '\u0000').getBytes(encoding.getCharSetName());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return (String.valueOf(StringUtils.cut(s2, maxCharacters)) + '\u0000').getBytes();
        }
    }

    public static byte[] toBytes0Term(String s2, CharacterEncoding encoding) {
        try {
            return (String.valueOf(s2) + '\u0000').getBytes(encoding.getCharSetName());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return (String.valueOf(s2) + '\u0000').getBytes();
        }
    }

    static byte[] toBytes(String s2, int maxLength, CharacterEncoding encoding) {
        try {
            return StringUtils.cut(s2, maxLength).getBytes(encoding.getCharSetName());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return StringUtils.cut(s2, maxLength).getBytes();
        }
    }

    static byte[] toBytes(String s2, CharacterEncoding encoding) {
        try {
            return s2.getBytes(encoding.getCharSetName());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return s2.getBytes();
        }
    }

    static byte[] toBytes(String[] in, int maxLength, CharacterEncoding encoding) {
        int nelems = in.length;
        int realMaxLength = encoding.getMaxBytesPerChar() * maxLength;
        byte[] out = new byte[nelems * realMaxLength];
        int i = 0;
        while (i < nelems) {
            byte[] bytes = StringUtils.toBytes(in[i], maxLength, encoding);
            System.arraycopy(bytes, 0, out, i * realMaxLength, bytes.length);
            ++i;
        }
        return out;
    }

    static byte[] toBytes0Term(String[] in, int maxLength, CharacterEncoding encoding) {
        int nelems = in.length;
        int realMaxLength = encoding.getMaxBytesPerChar() * maxLength + 1;
        byte[] out = new byte[nelems * realMaxLength];
        int i = 0;
        while (i < nelems) {
            byte[] bytes = StringUtils.toBytes0Term(in[i], maxLength, encoding);
            System.arraycopy(bytes, 0, out, i * realMaxLength, bytes.length);
            ++i;
        }
        return out;
    }

    static String fromBytes0Term(byte[] data, CharacterEncoding encoding) {
        return StringUtils.fromBytes0Term(data, 0, data.length, encoding);
    }

    static String fromBytes0Term(byte[] data, int startIdx, int maxEndIdx, CharacterEncoding encoding) {
        int termIdx = startIdx;
        while (termIdx < maxEndIdx && data[termIdx] != 0) {
            ++termIdx;
        }
        try {
            return new String(data, startIdx, termIdx - startIdx, encoding.getCharSetName());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(data, startIdx, termIdx - startIdx);
        }
    }

    static String fromBytes(byte[] data, int length, CharacterEncoding encoding) {
        return StringUtils.fromBytes(data, 0, length, encoding);
    }

    static String fromBytes(byte[] data, CharacterEncoding encoding) {
        return StringUtils.fromBytes(data, 0, data.length, encoding);
    }

    static String fromBytes(byte[] data, int startIdx, int endIdx, CharacterEncoding encoding) {
        try {
            return new String(data, startIdx, endIdx - startIdx, encoding.getCharSetName());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(data, startIdx, endIdx - startIdx);
        }
    }

    private static String cut(String s2, int maxLength) {
        if (s2.length() > maxLength) {
            return s2.substring(0, maxLength);
        }
        return s2;
    }

    static byte[] cutOrPadBytes(byte[] value, int length) {
        if (value.length == length) {
            return value;
        }
        byte[] newValue = new byte[length];
        System.arraycopy(value, 0, newValue, 0, Math.min(value.length, length));
        return newValue;
    }
}

