/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.heif.boxes;

import com.drew.lang.SequentialReader;
import com.drew.metadata.heif.boxes.Box;
import com.drew.metadata.heif.boxes.FullBox;
import java.io.IOException;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;

public class ItemLocationBox
extends FullBox {
    int indexSize;
    int offsetSize;
    int lengthSize;
    int baseOffsetSize;
    long itemCount;
    long itemID;
    int constructionMethod;
    int dataReferenceIndex;
    long baseOffset;
    int extentCount;
    SortedSet<Extent> extents = new TreeSet<Extent>(new Comparator<Extent>(){

        @Override
        public int compare(Extent left, Extent right) {
            return left.offset < right.offset ? -1 : (left.offset == right.offset ? 0 : 1);
        }
    });

    public ItemLocationBox(SequentialReader reader, Box box) throws IOException {
        super(reader, box);
        int holder = reader.getUInt8();
        this.offsetSize = (holder & 0xF0) >> 4;
        this.lengthSize = holder & 0xF;
        holder = reader.getUInt8();
        this.baseOffsetSize = (holder & 0xF0) >> 4;
        if (this.version == 1 || this.version == 2) {
            this.indexSize = holder & 0xF;
        }
        if (this.version < 2) {
            this.itemCount = reader.getUInt16();
        } else if (this.version == 2) {
            this.itemCount = reader.getUInt32();
        }
        int i = 0;
        while ((long)i < this.itemCount) {
            if (this.version < 2) {
                this.itemID = reader.getUInt16();
            } else if (this.version == 2) {
                this.itemID = reader.getUInt32();
            }
            if (this.version == 1 || this.version == 2) {
                holder = reader.getUInt16();
                this.constructionMethod = holder & 0xF;
            }
            this.dataReferenceIndex = reader.getUInt16();
            this.baseOffset = this.baseOffsetSize == 4 ? (long)reader.getInt32() : (this.baseOffsetSize == 8 ? reader.getInt64() : 0L);
            this.extentCount = reader.getUInt16();
            Long extentIndex = null;
            for (int j = 0; j < this.extentCount; ++j) {
                if (this.version == 1 || this.version == 2 && this.indexSize > 0) {
                    extentIndex = this.getIntFromUnknownByte(this.indexSize, reader);
                }
                long extentOffset = this.getIntFromUnknownByte(this.offsetSize, reader);
                long extentLength = this.getIntFromUnknownByte(this.lengthSize, reader);
                this.extents.add(new Extent(this.itemID, extentIndex, extentOffset + this.baseOffset, extentLength));
            }
            ++i;
        }
    }

    public Long getIntFromUnknownByte(int variable, SequentialReader reader) throws IOException {
        switch (variable) {
            case 1: {
                return reader.getUInt8();
            }
            case 2: {
                return reader.getUInt16();
            }
            case 4: {
                return reader.getUInt32();
            }
            case 8: {
                return reader.getInt64();
            }
        }
        return null;
    }

    public SortedSet<Extent> getExtents() {
        return this.extents;
    }

    public static class Extent {
        long itemId;
        Long index;
        long offset;
        long length;

        public Extent(long itemId, Long index, long offset, long length) {
            this.itemId = itemId;
            this.index = index;
            this.offset = offset;
            this.length = length;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getLength() {
            return this.length;
        }

        public long getItemId() {
            return this.itemId;
        }
    }
}

