/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.base.exceptions.IErrorStrategy;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.hdf5.h5ar.IDirectoryIndex;
import ch.systemsx.cisd.hdf5.h5ar.IDirectoryIndexProvider;
import ch.systemsx.cisd.hdf5.h5ar.LinkRecord;
import ch.systemsx.cisd.hdf5.h5ar.Utils;
import java.io.File;

final class DirectoryIndexUpdater {
    private final IDirectoryIndexProvider indexProvider;
    private final IErrorStrategy errorStrategy;

    DirectoryIndexUpdater(IDirectoryIndexProvider indexProvider) {
        this.indexProvider = indexProvider;
        this.errorStrategy = indexProvider.getErrorStrategy();
    }

    void updateIndicesOnThePath(String rootDir, File path, int crc32, boolean immediateGroupOnly) throws IOExceptionUnchecked {
        String groupPath = rootDir.endsWith("/") ? rootDir.substring(0, rootDir.length() - 1) : rootDir;
        IDirectoryIndex index = this.indexProvider.get(groupPath, false);
        LinkRecord linkOrNull = LinkRecord.tryCreate(path, this.errorStrategy);
        if (linkOrNull == null) {
            throw new IOExceptionUnchecked("Cannot get link information for path '" + path + "'.");
        }
        linkOrNull.setCrc32(crc32);
        index.updateIndex(linkOrNull);
        if (!immediateGroupOnly) {
            String pathPrefixOnFSOrNull = this.tryGetPathPrefix(groupPath, path.getAbsolutePath());
            String groupName = Utils.getName(groupPath);
            groupPath = Utils.getParentPath(groupPath);
            while (groupName.length() > 0) {
                this.updateIndex(pathPrefixOnFSOrNull, groupPath, groupName);
                groupName = Utils.getName(groupPath);
                groupPath = Utils.getParentPath(groupPath);
            }
        }
    }

    private void updateIndex(String pathPrefixOnFSOrNull, String groupPath, String groupName) {
        IDirectoryIndex index = this.indexProvider.get(groupPath, false);
        if (pathPrefixOnFSOrNull == null) {
            index.updateIndex(new LinkRecord(groupName));
        } else {
            File groupPathFile = new File(pathPrefixOnFSOrNull, groupName);
            index.updateIndex(LinkRecord.tryCreate(groupPathFile, this.errorStrategy));
        }
    }

    private String tryGetPathPrefix(String root, String filePath) {
        String parentPath = Utils.getParentPath(filePath);
        if (!parentPath.endsWith(root)) {
            return null;
        }
        String pathPrefix = parentPath.substring(0, parentPath.length() - root.length());
        if (pathPrefix.length() == 0) {
            return "/";
        }
        return pathPrefix;
    }
}

