/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs;

import ome.codecs.CodecOptions;
import ome.codecs.LZ4Codec;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class LZ4CodecTest {
    LZ4Codec codec = new LZ4Codec();

    @Test
    public void testCompressShortUniqueSequence() throws Exception {
        byte[] expected = new byte[]{-96, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        byte[] in = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        CodecOptions options = new CodecOptions();
        byte[] comp = this.codec.compress(in, options);
        AssertJUnit.assertEquals((byte[])expected, (byte[])comp);
    }

    @Test
    public void testDecompressShortUniqueSequence() throws Exception {
        byte[] in = new byte[]{-96, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        byte[] expected = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        CodecOptions options = new CodecOptions();
        options.maxBytes = expected.length;
        byte[] comp = this.codec.decompress(in, options);
        AssertJUnit.assertEquals((byte[])expected, (byte[])comp);
    }

    @Test
    public void testCompressLongSeq() throws Exception {
        byte[] expected = new byte[]{21, 0, 1, 0, 21, 1, 1, 0, 21, 2, 1, 0, 21, 3, 1, 0, 21, 4, 1, 0, 21, 5, 1, 0, 21, 6, 1, 0, 21, 7, 1, 0, 21, 8, 1, 0, 21, 9, 1, 0, 21, 10, 1, 0, 21, 11, 1, 0, 21, 12, 1, 0, 21, 13, 1, 0, 21, 14, 1, 0, 21, 15, 1, 0, 21, 16, 1, 0, 21, 17, 1, 0, 21, 18, 1, 0, 21, 19, 1, 0, 21, 20, 1, 0, 21, 21, 1, 0, 21, 22, 1, 0, 21, 23, 1, 0, 21, 24, 1, 0, 21, 25, 1, 0, 21, 26, 1, 0, 21, 27, 1, 0, 21, 28, 1, 0, 21, 29, 1, 0, 21, 30, 1, 0, 21, 31, 1, 0, 21, 32, 1, 0, 21, 33, 1, 0, 21, 34, 1, 0, 21, 35, 1, 0, 21, 36, 1, 0, 21, 37, 1, 0, 21, 38, 1, 0, 21, 39, 1, 0, 21, 40, 1, 0, 21, 41, 1, 0, 21, 42, 1, 0, 21, 43, 1, 0, 21, 44, 1, 0, 21, 45, 1, 0, 21, 46, 1, 0, 21, 47, 1, 0, 21, 48, 1, 0, 21, 49, 1, 0, 21, 50, 1, 0, 21, 51, 1, 0, 21, 52, 1, 0, 21, 53, 1, 0, 21, 54, 1, 0, 21, 55, 1, 0, 21, 56, 1, 0, 21, 57, 1, 0, 21, 58, 1, 0, 21, 59, 1, 0, 21, 60, 1, 0, 21, 61, 1, 0, 21, 62, 1, 0, 21, 63, 1, 0, 21, 64, 1, 0, 21, 65, 1, 0, 21, 66, 1, 0, 21, 67, 1, 0, 21, 68, 1, 0, 21, 69, 1, 0, 21, 70, 1, 0, 21, 71, 1, 0, 21, 72, 1, 0, 21, 73, 1, 0, 21, 74, 1, 0, 21, 75, 1, 0, 21, 76, 1, 0, 21, 77, 1, 0, 21, 78, 1, 0, 21, 79, 1, 0, 21, 80, 1, 0, 21, 81, 1, 0, 21, 82, 1, 0, 21, 83, 1, 0, 21, 84, 1, 0, 21, 85, 1, 0, 21, 86, 1, 0, 21, 87, 1, 0, 21, 88, 1, 0, 21, 89, 1, 0, 21, 90, 1, 0, 21, 91, 1, 0, 21, 92, 1, 0, 21, 93, 1, 0, 21, 94, 1, 0, 21, 95, 1, 0, 21, 96, 1, 0, 21, 97, 1, 0, 21, 98, 1, 0, -96, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
        byte[] in = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
        CodecOptions options = new CodecOptions();
        byte[] comp = this.codec.compress(in, options);
        AssertJUnit.assertEquals((byte[])expected, (byte[])comp);
    }

    @Test
    public void testDecompressLongSeq() throws Exception {
        byte[] in = new byte[]{21, 0, 1, 0, 21, 1, 1, 0, 21, 2, 1, 0, 21, 3, 1, 0, 21, 4, 1, 0, 21, 5, 1, 0, 21, 6, 1, 0, 21, 7, 1, 0, 21, 8, 1, 0, 21, 9, 1, 0, 21, 10, 1, 0, 21, 11, 1, 0, 21, 12, 1, 0, 21, 13, 1, 0, 21, 14, 1, 0, 21, 15, 1, 0, 21, 16, 1, 0, 21, 17, 1, 0, 21, 18, 1, 0, 21, 19, 1, 0, 21, 20, 1, 0, 21, 21, 1, 0, 21, 22, 1, 0, 21, 23, 1, 0, 21, 24, 1, 0, 21, 25, 1, 0, 21, 26, 1, 0, 21, 27, 1, 0, 21, 28, 1, 0, 21, 29, 1, 0, 21, 30, 1, 0, 21, 31, 1, 0, 21, 32, 1, 0, 21, 33, 1, 0, 21, 34, 1, 0, 21, 35, 1, 0, 21, 36, 1, 0, 21, 37, 1, 0, 21, 38, 1, 0, 21, 39, 1, 0, 21, 40, 1, 0, 21, 41, 1, 0, 21, 42, 1, 0, 21, 43, 1, 0, 21, 44, 1, 0, 21, 45, 1, 0, 21, 46, 1, 0, 21, 47, 1, 0, 21, 48, 1, 0, 21, 49, 1, 0, 21, 50, 1, 0, 21, 51, 1, 0, 21, 52, 1, 0, 21, 53, 1, 0, 21, 54, 1, 0, 21, 55, 1, 0, 21, 56, 1, 0, 21, 57, 1, 0, 21, 58, 1, 0, 21, 59, 1, 0, 21, 60, 1, 0, 21, 61, 1, 0, 21, 62, 1, 0, 21, 63, 1, 0, 21, 64, 1, 0, 21, 65, 1, 0, 21, 66, 1, 0, 21, 67, 1, 0, 21, 68, 1, 0, 21, 69, 1, 0, 21, 70, 1, 0, 21, 71, 1, 0, 21, 72, 1, 0, 21, 73, 1, 0, 21, 74, 1, 0, 21, 75, 1, 0, 21, 76, 1, 0, 21, 77, 1, 0, 21, 78, 1, 0, 21, 79, 1, 0, 21, 80, 1, 0, 21, 81, 1, 0, 21, 82, 1, 0, 21, 83, 1, 0, 21, 84, 1, 0, 21, 85, 1, 0, 21, 86, 1, 0, 21, 87, 1, 0, 21, 88, 1, 0, 21, 89, 1, 0, 21, 90, 1, 0, 21, 91, 1, 0, 21, 92, 1, 0, 21, 93, 1, 0, 21, 94, 1, 0, 21, 95, 1, 0, 21, 96, 1, 0, 21, 97, 1, 0, 21, 98, 1, 0, -96, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
        byte[] expected = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
        CodecOptions options = new CodecOptions();
        options.maxBytes = expected.length;
        byte[] comp = this.codec.decompress(in, options);
        AssertJUnit.assertEquals((byte[])expected, (byte[])comp);
    }
}

