/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;

public enum IlluminationType implements Enumeration
{
    TRANSMITTED("Transmitted"),
    EPIFLUORESCENCE("Epifluorescence"),
    OBLIQUE("Oblique"),
    NONLINEAR("NonLinear"),
    OTHER("Other");

    private final String value;

    private IlluminationType(String value) {
        this.value = value;
    }

    public static IlluminationType fromString(String value) throws EnumerationException {
        if ("Transmitted".equals(value)) {
            return TRANSMITTED;
        }
        if ("Epifluorescence".equals(value)) {
            return EPIFLUORESCENCE;
        }
        if ("Oblique".equals(value)) {
            return OBLIQUE;
        }
        if ("NonLinear".equals(value)) {
            return NONLINEAR;
        }
        if ("Other".equals(value)) {
            return OTHER;
        }
        String s = String.format("'%s' not a supported value of '%s'", value, IlluminationType.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

