/*
 * Decompiled with CFR 0.152.
 */
package ome.units;

import java.math.BigInteger;
import ome.units.quantity.Angle;
import ome.units.quantity.ElectricPotential;
import ome.units.quantity.Frequency;
import ome.units.quantity.Length;
import ome.units.quantity.Power;
import ome.units.quantity.Pressure;
import ome.units.quantity.Quantity;
import ome.units.quantity.Temperature;
import ome.units.quantity.Time;
import ome.units.unit.Unit;

public final class UNITS {
    public static final Unit<Angle> RADIAN = Unit.CreateBaseUnit("SI.RADIAN", "rad");
    public static final Unit<ElectricPotential> VOLT = Unit.CreateBaseUnit("SI.VOLT", "V");
    public static final Unit<Frequency> HERTZ = Unit.CreateBaseUnit("SI.HERTZ", "Hz");
    public static final Unit<Length> METRE = Unit.CreateBaseUnit("SI.METRE", "m");
    public static final Unit<Length> INCH = METRE.multiply(0.0254).setSymbol("in");
    public static final Unit<Power> WATT = Unit.CreateBaseUnit("SI.WATT", "W");
    public static final Unit<Pressure> PASCAL = Unit.CreateBaseUnit("SI.PASCAL", "Pa");
    public static final Unit<Temperature> KELVIN = Unit.CreateBaseUnit("SI.KELVIN", "K");
    public static final Unit<Time> SECOND = Unit.CreateBaseUnit("SI.SECOND", "s");
    public static final Unit<Frequency> YOTTAHERTZ = UNITS.YOTTA(HERTZ);
    public static final Unit<Frequency> ZETTAHERTZ = UNITS.ZETTA(HERTZ);
    public static final Unit<Frequency> EXAHERTZ = UNITS.EXA(HERTZ);
    public static final Unit<Frequency> PETAHERTZ = UNITS.PETA(HERTZ);
    public static final Unit<Frequency> TERAHERTZ = UNITS.TERA(HERTZ);
    public static final Unit<Frequency> GIGAHERTZ = UNITS.GIGA(HERTZ);
    public static final Unit<Frequency> MEGAHERTZ = UNITS.MEGA(HERTZ);
    public static final Unit<Frequency> KILOHERTZ = UNITS.KILO(HERTZ);
    public static final Unit<Frequency> HECTOHERTZ = UNITS.HECTO(HERTZ);
    public static final Unit<Frequency> DECAHERTZ = UNITS.DECA(HERTZ);
    public static final Unit<Frequency> DECIHERTZ = UNITS.DECI(HERTZ);
    public static final Unit<Frequency> CENTIHERTZ = UNITS.CENTI(HERTZ);
    public static final Unit<Frequency> MILLIHERTZ = UNITS.MILLI(HERTZ);
    public static final Unit<Frequency> MICROHERTZ = UNITS.MICRO(HERTZ);
    public static final Unit<Frequency> NANOHERTZ = UNITS.NANO(HERTZ);
    public static final Unit<Frequency> PICOHERTZ = UNITS.PICO(HERTZ);
    public static final Unit<Frequency> FEMTOHERTZ = UNITS.FEMTO(HERTZ);
    public static final Unit<Frequency> ATTOHERTZ = UNITS.ATTO(HERTZ);
    public static final Unit<Frequency> ZEPTOHERTZ = UNITS.ZEPTO(HERTZ);
    public static final Unit<Frequency> YOCTOHERTZ = UNITS.YOCTO(HERTZ);
    @Deprecated
    public static final Unit<Frequency> YOTTAHZ = YOTTAHERTZ;
    @Deprecated
    public static final Unit<Frequency> ZETTAHZ = ZETTAHERTZ;
    @Deprecated
    public static final Unit<Frequency> EXAHZ = EXAHERTZ;
    @Deprecated
    public static final Unit<Frequency> PETAHZ = PETAHERTZ;
    @Deprecated
    public static final Unit<Frequency> TERAHZ = TERAHERTZ;
    @Deprecated
    public static final Unit<Frequency> GIGAHZ = GIGAHERTZ;
    @Deprecated
    public static final Unit<Frequency> MEGAHZ = MEGAHERTZ;
    @Deprecated
    public static final Unit<Frequency> KHZ = KILOHERTZ;
    @Deprecated
    public static final Unit<Frequency> HHZ = HECTOHERTZ;
    @Deprecated
    public static final Unit<Frequency> DAHZ = DECAHERTZ;
    @Deprecated
    public static final Unit<Frequency> HZ = HERTZ;
    @Deprecated
    public static final Unit<Frequency> DHZ = DECIHERTZ;
    @Deprecated
    public static final Unit<Frequency> CHZ = CENTIHERTZ;
    @Deprecated
    public static final Unit<Frequency> MHZ = MILLIHERTZ;
    @Deprecated
    public static final Unit<Frequency> MICROHZ = MICROHERTZ;
    @Deprecated
    public static final Unit<Frequency> NHZ = NANOHERTZ;
    @Deprecated
    public static final Unit<Frequency> PHZ = PICOHERTZ;
    @Deprecated
    public static final Unit<Frequency> FHZ = FEMTOHERTZ;
    @Deprecated
    public static final Unit<Frequency> AHZ = ATTOHERTZ;
    @Deprecated
    public static final Unit<Frequency> ZHZ = ZEPTOHERTZ;
    @Deprecated
    public static final Unit<Frequency> YHZ = YOCTOHERTZ;
    public static final Unit<Length> YOTTAMETRE = UNITS.YOTTA(METRE);
    public static final Unit<Length> ZETTAMETRE = UNITS.ZETTA(METRE);
    public static final Unit<Length> EXAMETRE = UNITS.EXA(METRE);
    public static final Unit<Length> PETAMETRE = UNITS.PETA(METRE);
    public static final Unit<Length> TERAMETRE = UNITS.TERA(METRE);
    public static final Unit<Length> GIGAMETRE = UNITS.GIGA(METRE);
    public static final Unit<Length> MEGAMETRE = UNITS.MEGA(METRE);
    public static final Unit<Length> KILOMETRE = UNITS.KILO(METRE);
    public static final Unit<Length> HECTOMETRE = UNITS.HECTO(METRE);
    public static final Unit<Length> DECAMETRE = UNITS.DECA(METRE);
    public static final Unit<Length> DECIMETRE = UNITS.DECI(METRE);
    public static final Unit<Length> CENTIMETRE = UNITS.CENTI(METRE);
    public static final Unit<Length> MILLIMETRE = UNITS.MILLI(METRE);
    public static final Unit<Length> MICROMETRE = UNITS.MICRO(METRE);
    public static final Unit<Length> NANOMETRE = UNITS.NANO(METRE);
    public static final Unit<Length> PICOMETRE = UNITS.PICO(METRE);
    public static final Unit<Length> FEMTOMETRE = UNITS.FEMTO(METRE);
    public static final Unit<Length> ATTOMETRE = UNITS.ATTO(METRE);
    public static final Unit<Length> ZEPTOMETRE = UNITS.ZEPTO(METRE);
    public static final Unit<Length> YOCTOMETRE = UNITS.YOCTO(METRE);
    public static final Unit<Length> YOTTAMETER = YOTTAMETRE;
    public static final Unit<Length> ZETTAMETER = ZETTAMETRE;
    public static final Unit<Length> EXAMETER = EXAMETRE;
    public static final Unit<Length> PETAMETER = PETAMETRE;
    public static final Unit<Length> TERAMETER = TERAMETRE;
    public static final Unit<Length> GIGAMETER = GIGAMETRE;
    public static final Unit<Length> MEGAMETER = MEGAMETRE;
    public static final Unit<Length> KILOMETER = KILOMETRE;
    public static final Unit<Length> HECTOMETER = HECTOMETRE;
    public static final Unit<Length> DECAMETER = DECAMETRE;
    public static final Unit<Length> METER = METRE;
    public static final Unit<Length> DECIMETER = DECIMETRE;
    public static final Unit<Length> CENTIMETER = CENTIMETRE;
    public static final Unit<Length> MILLIMETER = MILLIMETRE;
    public static final Unit<Length> MICROMETER = MICROMETRE;
    public static final Unit<Length> NANOMETER = NANOMETRE;
    public static final Unit<Length> PICOMETER = PICOMETRE;
    public static final Unit<Length> FEMTOMETER = FEMTOMETRE;
    public static final Unit<Length> ATTOMETER = ATTOMETRE;
    public static final Unit<Length> ZEPTOMETER = ZEPTOMETRE;
    public static final Unit<Length> YOCTOMETER = YOCTOMETRE;
    public static final Unit<Length> ANGSTROM = NANOMETRE.divide(10).setSymbol("\u00c5");
    public static final Unit<Length> THOU = UNITS.MILLI(INCH).setSymbol("thou");
    public static final Unit<Length> LINE = INCH.divide(12).setSymbol("li");
    public static final Unit<Length> FOOT = INCH.multiply(12).setSymbol("ft");
    public static final Unit<Length> YARD = FOOT.multiply(3).setSymbol("yd");
    public static final Unit<Length> MILE = YARD.multiply(1760).setSymbol("mi");
    public static final Unit<Length> ASTRONOMICALUNIT = UNITS.GIGA(METRE.multiply(149.5978707)).setSymbol("ua");
    public static final Unit<Length> LIGHTYEAR = UNITS.PETA(METRE.multiply(9.4607304725808)).setSymbol("ly");
    public static final Unit<Length> PARSEC = UNITS.GIGA(METRE.multiply(30856776)).setSymbol("pc");
    public static final Unit<Length> POINT = INCH.divide(72).setSymbol("pt");
    public static final Unit<Length> PIXEL = Unit.CreateBaseUnit("Pixel", "pixel");
    public static final Unit<Length> REFERENCEFRAME = Unit.CreateBaseUnit("ReferenceFrame", "reference frame");
    @Deprecated
    public static final Unit<Length> YOTTAM = YOTTAMETRE;
    @Deprecated
    public static final Unit<Length> ZETTAM = ZETTAMETRE;
    @Deprecated
    public static final Unit<Length> EXAM = EXAMETRE;
    @Deprecated
    public static final Unit<Length> PETAM = PETAMETRE;
    @Deprecated
    public static final Unit<Length> TERAM = TERAMETRE;
    @Deprecated
    public static final Unit<Length> GIGAM = GIGAMETRE;
    @Deprecated
    public static final Unit<Length> MEGAM = MEGAMETRE;
    @Deprecated
    public static final Unit<Length> KM = KILOMETRE;
    @Deprecated
    public static final Unit<Length> HM = HECTOMETRE;
    @Deprecated
    public static final Unit<Length> DAM = DECAMETRE;
    @Deprecated
    public static final Unit<Length> M = METRE;
    @Deprecated
    public static final Unit<Length> DM = DECIMETRE;
    @Deprecated
    public static final Unit<Length> CM = CENTIMETRE;
    @Deprecated
    public static final Unit<Length> MM = MILLIMETRE;
    @Deprecated
    public static final Unit<Length> MICROM = MICROMETRE;
    @Deprecated
    public static final Unit<Length> NM = NANOMETRE;
    @Deprecated
    public static final Unit<Length> PM = PICOMETRE;
    @Deprecated
    public static final Unit<Length> FM = FEMTOMETRE;
    @Deprecated
    public static final Unit<Length> AM = ATTOMETRE;
    @Deprecated
    public static final Unit<Length> ZM = ZEPTOMETRE;
    @Deprecated
    public static final Unit<Length> YM = YOCTOMETRE;
    @Deprecated
    public static final Unit<Length> LI = LINE;
    @Deprecated
    public static final Unit<Length> IN = INCH;
    @Deprecated
    public static final Unit<Length> FT = FOOT;
    @Deprecated
    public static final Unit<Length> YD = YARD;
    @Deprecated
    public static final Unit<Length> MI = MILE;
    @Deprecated
    public static final Unit<Length> UA = ASTRONOMICALUNIT;
    @Deprecated
    public static final Unit<Length> LY = LIGHTYEAR;
    @Deprecated
    public static final Unit<Length> PC = PARSEC;
    @Deprecated
    public static final Unit<Length> PT = POINT;
    public static final Unit<Power> YOTTAWATT = UNITS.YOTTA(WATT);
    public static final Unit<Power> ZETTAWATT = UNITS.ZETTA(WATT);
    public static final Unit<Power> EXAWATT = UNITS.EXA(WATT);
    public static final Unit<Power> PETAWATT = UNITS.PETA(WATT);
    public static final Unit<Power> TERAWATT = UNITS.TERA(WATT);
    public static final Unit<Power> GIGAWATT = UNITS.GIGA(WATT);
    public static final Unit<Power> MEGAWATT = UNITS.MEGA(WATT);
    public static final Unit<Power> KILOWATT = UNITS.KILO(WATT);
    public static final Unit<Power> HECTOWATT = UNITS.HECTO(WATT);
    public static final Unit<Power> DECAWATT = UNITS.DECA(WATT);
    public static final Unit<Power> DECIWATT = UNITS.DECI(WATT);
    public static final Unit<Power> CENTIWATT = UNITS.CENTI(WATT);
    public static final Unit<Power> MILLIWATT = UNITS.MILLI(WATT);
    public static final Unit<Power> MICROWATT = UNITS.MICRO(WATT);
    public static final Unit<Power> NANOWATT = UNITS.NANO(WATT);
    public static final Unit<Power> PICOWATT = UNITS.PICO(WATT);
    public static final Unit<Power> FEMTOWATT = UNITS.FEMTO(WATT);
    public static final Unit<Power> ATTOWATT = UNITS.ATTO(WATT);
    public static final Unit<Power> ZEPTOWATT = UNITS.ZEPTO(WATT);
    public static final Unit<Power> YOCTOWATT = UNITS.YOCTO(WATT);
    @Deprecated
    public static final Unit<Power> YOTTAW = YOTTAWATT;
    @Deprecated
    public static final Unit<Power> ZETTAW = ZETTAWATT;
    @Deprecated
    public static final Unit<Power> EXAW = EXAWATT;
    @Deprecated
    public static final Unit<Power> PETAW = PETAWATT;
    @Deprecated
    public static final Unit<Power> TERAW = TERAWATT;
    @Deprecated
    public static final Unit<Power> GIGAW = GIGAWATT;
    @Deprecated
    public static final Unit<Power> MEGAW = MEGAWATT;
    @Deprecated
    public static final Unit<Power> KW = KILOWATT;
    @Deprecated
    public static final Unit<Power> HW = HECTOWATT;
    @Deprecated
    public static final Unit<Power> DAW = DECAWATT;
    @Deprecated
    public static final Unit<Power> W = WATT;
    @Deprecated
    public static final Unit<Power> DW = DECIWATT;
    @Deprecated
    public static final Unit<Power> CW = CENTIWATT;
    @Deprecated
    public static final Unit<Power> MW = MILLIWATT;
    @Deprecated
    public static final Unit<Power> MICROW = MICROWATT;
    @Deprecated
    public static final Unit<Power> NW = NANOWATT;
    @Deprecated
    public static final Unit<Power> PW = PICOWATT;
    @Deprecated
    public static final Unit<Power> FW = FEMTOWATT;
    @Deprecated
    public static final Unit<Power> AW = ATTOWATT;
    @Deprecated
    public static final Unit<Power> ZW = ZEPTOWATT;
    @Deprecated
    public static final Unit<Power> YW = YOCTOWATT;
    public static final Unit<Pressure> YOTTAPASCAL = UNITS.YOTTA(PASCAL);
    public static final Unit<Pressure> ZETTAPASCAL = UNITS.ZETTA(PASCAL);
    public static final Unit<Pressure> EXAPASCAL = UNITS.EXA(PASCAL);
    public static final Unit<Pressure> PETAPASCAL = UNITS.PETA(PASCAL);
    public static final Unit<Pressure> TERAPASCAL = UNITS.TERA(PASCAL);
    public static final Unit<Pressure> GIGAPASCAL = UNITS.GIGA(PASCAL);
    public static final Unit<Pressure> MEGAPASCAL = UNITS.MEGA(PASCAL);
    public static final Unit<Pressure> KILOPASCAL = UNITS.KILO(PASCAL);
    public static final Unit<Pressure> HECTOPASCAL = UNITS.HECTO(PASCAL);
    public static final Unit<Pressure> DECAPASCAL = UNITS.DECA(PASCAL);
    public static final Unit<Pressure> DECIPASCAL = UNITS.DECI(PASCAL);
    public static final Unit<Pressure> CENTIPASCAL = UNITS.CENTI(PASCAL);
    public static final Unit<Pressure> MILLIPASCAL = UNITS.MILLI(PASCAL);
    public static final Unit<Pressure> MICROPASCAL = UNITS.MICRO(PASCAL);
    public static final Unit<Pressure> NANOPASCAL = UNITS.NANO(PASCAL);
    public static final Unit<Pressure> PICOPASCAL = UNITS.PICO(PASCAL);
    public static final Unit<Pressure> FEMTOPASCAL = UNITS.FEMTO(PASCAL);
    public static final Unit<Pressure> ATTOPASCAL = UNITS.ATTO(PASCAL);
    public static final Unit<Pressure> ZEPTOPASCAL = UNITS.ZEPTO(PASCAL);
    public static final Unit<Pressure> YOCTOPASCAL = UNITS.YOCTO(PASCAL);
    public static final Unit<Pressure> BAR = PASCAL.multiply(100000).setSymbol("bar");
    public static final Unit<Pressure> MEGABAR = UNITS.MEGA(BAR);
    public static final Unit<Pressure> KILOBAR = UNITS.KILO(BAR);
    public static final Unit<Pressure> DECIBAR = UNITS.DECI(BAR);
    public static final Unit<Pressure> CENTIBAR = UNITS.CENTI(BAR);
    public static final Unit<Pressure> MILLIBAR = UNITS.MILLI(BAR);
    public static final Unit<Pressure> ATMOSPHERE = PASCAL.multiply(101325).setSymbol("atm");
    public static final Unit<Pressure> PSI = PASCAL.multiply(6894.757293168362).setSymbol("psi");
    public static final Unit<Pressure> TORR = ATMOSPHERE.divide(760).setSymbol("Torr");
    public static final Unit<Pressure> MILLITORR = UNITS.MILLI(TORR);
    public static final Unit<Pressure> MMHG = PASCAL.multiply(133.322387415).setSymbol("mm Hg");
    @Deprecated
    public static final Unit<Pressure> YOTTAPA = YOTTAPASCAL;
    @Deprecated
    public static final Unit<Pressure> ZETTAPA = ZETTAPASCAL;
    @Deprecated
    public static final Unit<Pressure> EXAPA = EXAPASCAL;
    @Deprecated
    public static final Unit<Pressure> PETAPA = PETAPASCAL;
    @Deprecated
    public static final Unit<Pressure> TERAPA = TERAPASCAL;
    @Deprecated
    public static final Unit<Pressure> GIGAPA = GIGAPASCAL;
    @Deprecated
    public static final Unit<Pressure> MEGAPA = MEGAPASCAL;
    @Deprecated
    public static final Unit<Pressure> KPA = KILOPASCAL;
    @Deprecated
    public static final Unit<Pressure> HPA = HECTOPASCAL;
    @Deprecated
    public static final Unit<Pressure> DAPA = DECAPASCAL;
    @Deprecated
    public static final Unit<Pressure> PA = PASCAL;
    @Deprecated
    public static final Unit<Pressure> DPA = DECIPASCAL;
    @Deprecated
    public static final Unit<Pressure> CPA = CENTIPASCAL;
    @Deprecated
    public static final Unit<Pressure> MPA = MILLIPASCAL;
    @Deprecated
    public static final Unit<Pressure> MICROPA = MICROPASCAL;
    @Deprecated
    public static final Unit<Pressure> NPA = NANOPASCAL;
    @Deprecated
    public static final Unit<Pressure> PPA = PICOPASCAL;
    @Deprecated
    public static final Unit<Pressure> FPA = FEMTOPASCAL;
    @Deprecated
    public static final Unit<Pressure> APA = ATTOPASCAL;
    @Deprecated
    public static final Unit<Pressure> ZPA = ZEPTOPASCAL;
    @Deprecated
    public static final Unit<Pressure> YPA = YOCTOPASCAL;
    @Deprecated
    public static final Unit<Pressure> KBAR = KILOBAR;
    @Deprecated
    public static final Unit<Pressure> DBAR = DECIBAR;
    @Deprecated
    public static final Unit<Pressure> CBAR = CENTIBAR;
    @Deprecated
    public static final Unit<Pressure> MBAR = MILLIBAR;
    @Deprecated
    public static final Unit<Pressure> ATM = ATMOSPHERE;
    @Deprecated
    public static final Unit<Pressure> MTORR = MILLITORR;
    public static final Unit<Temperature> CELSIUS = KELVIN.add(273.15).setSymbol("\u00b0C");
    public static final Unit<Temperature> RANKINE = KELVIN.multiply(5).divide(9).setSymbol("\u00b0R");
    public static final Unit<Temperature> FAHRENHEIT = RANKINE.add(459.67).setSymbol("\u00b0F");
    @Deprecated
    public static final Unit<Temperature> DEGREEC = CELSIUS;
    @Deprecated
    public static final Unit<Temperature> K = KELVIN;
    @Deprecated
    public static final Unit<Temperature> DEGREER = RANKINE;
    @Deprecated
    public static final Unit<Temperature> DEGREEF = FAHRENHEIT;
    public static final Unit<Time> YOTTASECOND = UNITS.YOTTA(SECOND);
    public static final Unit<Time> ZETTASECOND = UNITS.ZETTA(SECOND);
    public static final Unit<Time> EXASECOND = UNITS.EXA(SECOND);
    public static final Unit<Time> PETASECOND = UNITS.PETA(SECOND);
    public static final Unit<Time> TERASECOND = UNITS.TERA(SECOND);
    public static final Unit<Time> GIGASECOND = UNITS.GIGA(SECOND);
    public static final Unit<Time> MEGASECOND = UNITS.MEGA(SECOND);
    public static final Unit<Time> KILOSECOND = UNITS.KILO(SECOND);
    public static final Unit<Time> HECTOSECOND = UNITS.HECTO(SECOND);
    public static final Unit<Time> DECASECOND = UNITS.DECA(SECOND);
    public static final Unit<Time> DECISECOND = UNITS.DECI(SECOND);
    public static final Unit<Time> CENTISECOND = UNITS.CENTI(SECOND);
    public static final Unit<Time> MILLISECOND = UNITS.MILLI(SECOND);
    public static final Unit<Time> MICROSECOND = UNITS.MICRO(SECOND);
    public static final Unit<Time> NANOSECOND = UNITS.NANO(SECOND);
    public static final Unit<Time> PICOSECOND = UNITS.PICO(SECOND);
    public static final Unit<Time> FEMTOSECOND = UNITS.FEMTO(SECOND);
    public static final Unit<Time> ATTOSECOND = UNITS.ATTO(SECOND);
    public static final Unit<Time> ZEPTOSECOND = UNITS.ZEPTO(SECOND);
    public static final Unit<Time> YOCTOSECOND = UNITS.YOCTO(SECOND);
    public static final Unit<Time> MINUTE = SECOND.multiply(60).setSymbol("min");
    public static final Unit<Time> HOUR = MINUTE.multiply(60).setSymbol("h");
    public static final Unit<Time> DAY = HOUR.multiply(24).setSymbol("d");
    @Deprecated
    public static final Unit<Time> YOTTAS = YOTTASECOND;
    @Deprecated
    public static final Unit<Time> ZETTAS = ZETTASECOND;
    @Deprecated
    public static final Unit<Time> EXAS = EXASECOND;
    @Deprecated
    public static final Unit<Time> PETAS = PETASECOND;
    @Deprecated
    public static final Unit<Time> TERAS = TERASECOND;
    @Deprecated
    public static final Unit<Time> GIGAS = GIGASECOND;
    @Deprecated
    public static final Unit<Time> MEGAS = MEGASECOND;
    @Deprecated
    public static final Unit<Time> KS = KILOSECOND;
    @Deprecated
    public static final Unit<Time> HS = HECTOSECOND;
    @Deprecated
    public static final Unit<Time> DAS = DECASECOND;
    @Deprecated
    public static final Unit<Time> S = SECOND;
    @Deprecated
    public static final Unit<Time> DS = DECISECOND;
    @Deprecated
    public static final Unit<Time> CS = CENTISECOND;
    @Deprecated
    public static final Unit<Time> MS = MILLISECOND;
    @Deprecated
    public static final Unit<Time> MICROS = MICROSECOND;
    @Deprecated
    public static final Unit<Time> NS = NANOSECOND;
    @Deprecated
    public static final Unit<Time> PS = PICOSECOND;
    @Deprecated
    public static final Unit<Time> FS = FEMTOSECOND;
    @Deprecated
    public static final Unit<Time> AS = ATTOSECOND;
    @Deprecated
    public static final Unit<Time> ZS = ZEPTOSECOND;
    @Deprecated
    public static final Unit<Time> YS = YOCTOSECOND;
    @Deprecated
    public static final Unit<Time> MIN = MINUTE;
    @Deprecated
    public static final Unit<Time> H = HOUR;
    @Deprecated
    public static final Unit<Time> D = DAY;
    public static final Unit<ElectricPotential> YOTTAVOLT = UNITS.YOTTA(VOLT);
    public static final Unit<ElectricPotential> ZETTAVOLT = UNITS.ZETTA(VOLT);
    public static final Unit<ElectricPotential> EXAVOLT = UNITS.EXA(VOLT);
    public static final Unit<ElectricPotential> PETAVOLT = UNITS.PETA(VOLT);
    public static final Unit<ElectricPotential> TERAVOLT = UNITS.TERA(VOLT);
    public static final Unit<ElectricPotential> GIGAVOLT = UNITS.GIGA(VOLT);
    public static final Unit<ElectricPotential> MEGAVOLT = UNITS.MEGA(VOLT);
    public static final Unit<ElectricPotential> KILOVOLT = UNITS.KILO(VOLT);
    public static final Unit<ElectricPotential> HECTOVOLT = UNITS.HECTO(VOLT);
    public static final Unit<ElectricPotential> DECAVOLT = UNITS.DECA(VOLT);
    public static final Unit<ElectricPotential> DECIVOLT = UNITS.DECI(VOLT);
    public static final Unit<ElectricPotential> CENTIVOLT = UNITS.CENTI(VOLT);
    public static final Unit<ElectricPotential> MILLIVOLT = UNITS.MILLI(VOLT);
    public static final Unit<ElectricPotential> MICROVOLT = UNITS.MICRO(VOLT);
    public static final Unit<ElectricPotential> NANOVOLT = UNITS.NANO(VOLT);
    public static final Unit<ElectricPotential> PICOVOLT = UNITS.PICO(VOLT);
    public static final Unit<ElectricPotential> FEMTOVOLT = UNITS.FEMTO(VOLT);
    public static final Unit<ElectricPotential> ATTOVOLT = UNITS.ATTO(VOLT);
    public static final Unit<ElectricPotential> ZEPTOVOLT = UNITS.ZEPTO(VOLT);
    public static final Unit<ElectricPotential> YOCTOVOLT = UNITS.YOCTO(VOLT);
    @Deprecated
    public static final Unit<ElectricPotential> YOTTAV = YOTTAVOLT;
    @Deprecated
    public static final Unit<ElectricPotential> ZETTAV = ZETTAVOLT;
    @Deprecated
    public static final Unit<ElectricPotential> EXAV = EXAVOLT;
    @Deprecated
    public static final Unit<ElectricPotential> PETAV = PETAVOLT;
    @Deprecated
    public static final Unit<ElectricPotential> TERAV = TERAVOLT;
    @Deprecated
    public static final Unit<ElectricPotential> GIGAV = GIGAVOLT;
    @Deprecated
    public static final Unit<ElectricPotential> MEGAV = MEGAVOLT;
    @Deprecated
    public static final Unit<ElectricPotential> KV = KILOVOLT;
    @Deprecated
    public static final Unit<ElectricPotential> HV = HECTOVOLT;
    @Deprecated
    public static final Unit<ElectricPotential> DAV = DECAVOLT;
    @Deprecated
    public static final Unit<ElectricPotential> V = VOLT;
    @Deprecated
    public static final Unit<ElectricPotential> DV = DECIVOLT;
    @Deprecated
    public static final Unit<ElectricPotential> CV = CENTIVOLT;
    @Deprecated
    public static final Unit<ElectricPotential> MV = MILLIVOLT;
    @Deprecated
    public static final Unit<ElectricPotential> MICROV = MICROVOLT;
    @Deprecated
    public static final Unit<ElectricPotential> NV = NANOVOLT;
    @Deprecated
    public static final Unit<ElectricPotential> PV = PICOVOLT;
    @Deprecated
    public static final Unit<ElectricPotential> FV = FEMTOVOLT;
    @Deprecated
    public static final Unit<ElectricPotential> AV = ATTOVOLT;
    @Deprecated
    public static final Unit<ElectricPotential> ZV = ZEPTOVOLT;
    @Deprecated
    public static final Unit<ElectricPotential> YV = YOCTOVOLT;
    public static final Unit<Angle> DEGREE = RADIAN.multiply(Math.PI).divide(180).setSymbol("deg");
    public static final Unit<Angle> GRADIAN = RADIAN.multiply(Math.PI).divide(200).setSymbol("gon");
    @Deprecated
    public static final Unit<Angle> DEG = DEGREE;
    @Deprecated
    public static final Unit<Angle> RAD = RADIAN;
    @Deprecated
    public static final Unit<Angle> GON = GRADIAN;

    public String getName() {
        return "OME-combined";
    }

    public static <T extends Quantity> Unit<T> YOTTA(Unit<T> inUnit) {
        return inUnit.prefixSymbol("Y").multiply(BigInteger.TEN.pow(24).doubleValue());
    }

    public static <T extends Quantity> Unit<T> ZETTA(Unit<T> inUnit) {
        return inUnit.prefixSymbol("Z").multiply(BigInteger.TEN.pow(21).doubleValue());
    }

    public static <T extends Quantity> Unit<T> EXA(Unit<T> inUnit) {
        return inUnit.prefixSymbol("E").multiply(BigInteger.TEN.pow(18).doubleValue());
    }

    public static <T extends Quantity> Unit<T> PETA(Unit<T> inUnit) {
        return inUnit.prefixSymbol("P").multiply(BigInteger.TEN.pow(15).doubleValue());
    }

    public static <T extends Quantity> Unit<T> TERA(Unit<T> inUnit) {
        return inUnit.prefixSymbol("T").multiply(BigInteger.TEN.pow(12).doubleValue());
    }

    public static <T extends Quantity> Unit<T> GIGA(Unit<T> inUnit) {
        return inUnit.prefixSymbol("G").multiply(BigInteger.TEN.pow(9).doubleValue());
    }

    public static <T extends Quantity> Unit<T> MEGA(Unit<T> inUnit) {
        return inUnit.prefixSymbol("M").multiply(BigInteger.TEN.pow(6).doubleValue());
    }

    public static <T extends Quantity> Unit<T> KILO(Unit<T> inUnit) {
        return inUnit.prefixSymbol("k").multiply(BigInteger.TEN.pow(3).doubleValue());
    }

    public static <T extends Quantity> Unit<T> HECTO(Unit<T> inUnit) {
        return inUnit.prefixSymbol("h").multiply(BigInteger.TEN.pow(2).doubleValue());
    }

    public static <T extends Quantity> Unit<T> DECA(Unit<T> inUnit) {
        return inUnit.prefixSymbol("da").multiply(BigInteger.TEN.pow(1).doubleValue());
    }

    public static <T extends Quantity> Unit<T> DECI(Unit<T> inUnit) {
        return inUnit.prefixSymbol("d").divide(BigInteger.TEN.pow(1).doubleValue());
    }

    public static <T extends Quantity> Unit<T> CENTI(Unit<T> inUnit) {
        return inUnit.prefixSymbol("c").divide(BigInteger.TEN.pow(2).doubleValue());
    }

    public static <T extends Quantity> Unit<T> MILLI(Unit<T> inUnit) {
        return inUnit.prefixSymbol("m").divide(BigInteger.TEN.pow(3).doubleValue());
    }

    public static <T extends Quantity> Unit<T> MICRO(Unit<T> inUnit) {
        return inUnit.prefixSymbol("\u00b5").divide(BigInteger.TEN.pow(6).doubleValue());
    }

    public static <T extends Quantity> Unit<T> NANO(Unit<T> inUnit) {
        return inUnit.prefixSymbol("n").divide(BigInteger.TEN.pow(9).doubleValue());
    }

    public static <T extends Quantity> Unit<T> PICO(Unit<T> inUnit) {
        return inUnit.prefixSymbol("p").divide(BigInteger.TEN.pow(12).doubleValue());
    }

    public static <T extends Quantity> Unit<T> FEMTO(Unit<T> inUnit) {
        return inUnit.prefixSymbol("f").divide(BigInteger.TEN.pow(15).doubleValue());
    }

    public static <T extends Quantity> Unit<T> ATTO(Unit<T> inUnit) {
        return inUnit.prefixSymbol("a").divide(BigInteger.TEN.pow(18).doubleValue());
    }

    public static <T extends Quantity> Unit<T> ZEPTO(Unit<T> inUnit) {
        return inUnit.prefixSymbol("z").divide(BigInteger.TEN.pow(21).doubleValue());
    }

    public static <T extends Quantity> Unit<T> YOCTO(Unit<T> inUnit) {
        return inUnit.prefixSymbol("y").divide(BigInteger.TEN.pow(24).doubleValue());
    }
}

