/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.math.ode.AbstractStepInterpolator;
import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.StepHandler;
import org.apache.commons.math.ode.StepInterpolator;

public class ContinuousOutputModel
implements StepHandler,
Serializable {
    private double initialTime;
    private double finalTime;
    private boolean forward;
    private int index;
    private ArrayList steps = new ArrayList();
    private static final long serialVersionUID = 2259286184268533249L;

    public ContinuousOutputModel() {
        this.reset();
    }

    public void append(ContinuousOutputModel model) throws DerivativeException {
        if (model.steps.size() == 0) {
            return;
        }
        if (this.steps.size() == 0) {
            this.initialTime = model.initialTime;
            this.forward = model.forward;
        } else {
            if (this.getInterpolatedState().length != model.getInterpolatedState().length) {
                throw new IllegalArgumentException("state vector dimension mismatch");
            }
            if (this.forward ^ model.forward) {
                throw new IllegalArgumentException("propagation direction mismatch");
            }
            StepInterpolator lastInterpolator = (StepInterpolator)this.steps.get(this.index);
            double current = lastInterpolator.getCurrentTime();
            double previous = lastInterpolator.getPreviousTime();
            double step = current - previous;
            double gap = model.getInitialTime() - current;
            if (Math.abs(gap) > 0.001 * Math.abs(step)) {
                throw new IllegalArgumentException("hole between time ranges");
            }
        }
        Iterator iter = model.steps.iterator();
        while (iter.hasNext()) {
            this.steps.add(((AbstractStepInterpolator)iter.next()).copy());
        }
        this.index = this.steps.size() - 1;
        this.finalTime = ((StepInterpolator)this.steps.get(this.index)).getCurrentTime();
    }

    public boolean requiresDenseOutput() {
        return true;
    }

    public void reset() {
        this.initialTime = Double.NaN;
        this.finalTime = Double.NaN;
        this.forward = true;
        this.index = 0;
        this.steps.clear();
    }

    public void handleStep(StepInterpolator interpolator, boolean isLast) throws DerivativeException {
        AbstractStepInterpolator ai = (AbstractStepInterpolator)interpolator;
        if (this.steps.size() == 0) {
            this.initialTime = interpolator.getPreviousTime();
            this.forward = interpolator.isForward();
        }
        this.steps.add(ai.copy());
        if (isLast) {
            this.finalTime = ai.getCurrentTime();
            this.index = this.steps.size() - 1;
        }
    }

    public double getInitialTime() {
        return this.initialTime;
    }

    public double getFinalTime() {
        return this.finalTime;
    }

    public double getInterpolatedTime() {
        return ((StepInterpolator)this.steps.get(this.index)).getInterpolatedTime();
    }

    public void setInterpolatedTime(double time) {
        try {
            StepInterpolator si;
            int iMin = 0;
            StepInterpolator sMin = (StepInterpolator)this.steps.get(iMin);
            double tMin = 0.5 * (sMin.getPreviousTime() + sMin.getCurrentTime());
            int iMax = this.steps.size() - 1;
            StepInterpolator sMax = (StepInterpolator)this.steps.get(iMax);
            double tMax = 0.5 * (sMax.getPreviousTime() + sMax.getCurrentTime());
            if (this.locatePoint(time, sMin) <= 0) {
                this.index = iMin;
                sMin.setInterpolatedTime(time);
                return;
            }
            if (this.locatePoint(time, sMax) >= 0) {
                this.index = iMax;
                sMax.setInterpolatedTime(time);
                return;
            }
            while (iMax - iMin > 5) {
                si = (StepInterpolator)this.steps.get(this.index);
                int location = this.locatePoint(time, si);
                if (location < 0) {
                    iMax = this.index;
                    tMax = 0.5 * (si.getPreviousTime() + si.getCurrentTime());
                } else if (location > 0) {
                    iMin = this.index;
                    tMin = 0.5 * (si.getPreviousTime() + si.getCurrentTime());
                } else {
                    si.setInterpolatedTime(time);
                    return;
                }
                int iMed = (iMin + iMax) / 2;
                StepInterpolator sMed = (StepInterpolator)this.steps.get(iMed);
                double tMed = 0.5 * (sMed.getPreviousTime() + sMed.getCurrentTime());
                if (Math.abs(tMed - tMin) < 1.0E-6 || Math.abs(tMax - tMed) < 1.0E-6) {
                    this.index = iMed;
                } else {
                    double d12 = tMax - tMed;
                    double d23 = tMed - tMin;
                    double d13 = tMax - tMin;
                    double dt1 = time - tMax;
                    double dt2 = time - tMed;
                    double dt3 = time - tMin;
                    double iLagrange = (dt2 * dt3 * d23 * (double)iMax - dt1 * dt3 * d13 * (double)iMed + dt1 * dt2 * d12 * (double)iMin) / (d12 * d23 * d13);
                    this.index = (int)Math.rint(iLagrange);
                }
                int low = Math.max(iMin + 1, (9 * iMin + iMax) / 10);
                int high = Math.min(iMax - 1, (iMin + 9 * iMax) / 10);
                if (this.index < low) {
                    this.index = low;
                    continue;
                }
                if (this.index <= high) continue;
                this.index = high;
            }
            this.index = iMin;
            while (this.index <= iMax && this.locatePoint(time, (StepInterpolator)this.steps.get(this.index)) > 0) {
                ++this.index;
            }
            si = (StepInterpolator)this.steps.get(this.index);
            si.setInterpolatedTime(time);
        }
        catch (DerivativeException de) {
            throw new RuntimeException("unexpected DerivativeException caught: " + de.getMessage());
        }
    }

    public double[] getInterpolatedState() {
        return ((StepInterpolator)this.steps.get(this.index)).getInterpolatedState();
    }

    private int locatePoint(double time, StepInterpolator interval) {
        if (this.forward) {
            if (time < interval.getPreviousTime()) {
                return -1;
            }
            if (time > interval.getCurrentTime()) {
                return 1;
            }
            return 0;
        }
        if (time > interval.getPreviousTime()) {
            return -1;
        }
        if (time < interval.getCurrentTime()) {
            return 1;
        }
        return 0;
    }
}

