/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import loci.common.services.ServiceFactory;
import loci.formats.ChannelMerger;
import loci.formats.IFormatReader;
import loci.formats.in.FakeReader;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.services.OMEXMLService;
import ome.xml.model.primitives.PositiveInteger;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ChannelMergerTest {
    private ChannelMerger reader;
    private OMEXMLService service;
    private MetadataRetrieve m;

    @BeforeMethod
    public void setUp() throws Exception {
        this.reader = new ChannelMerger((IFormatReader)new FakeReader());
        ServiceFactory sf = new ServiceFactory();
        this.service = (OMEXMLService)sf.getInstance(OMEXMLService.class);
        this.reader.setMetadataStore((MetadataStore)this.service.createOMEXMLMetadata());
        this.reader.setFlattenedResolutions(false);
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.reader.close();
    }

    @Test
    public void testSingleChannel() throws Exception {
        this.reader.setId("1C&sizeC=1.fake");
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertEquals((int)this.m.getChannelCount(0), (int)1);
        Assert.assertEquals((Object)this.m.getChannelSamplesPerPixel(0, 0), (Object)new PositiveInteger(Integer.valueOf(1)));
    }

    @Test
    public void testTwoChannels() throws Exception {
        this.reader.setId("2C&sizeC=2.fake");
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertEquals((int)this.m.getChannelCount(0), (int)1);
        Assert.assertEquals((Object)this.m.getChannelSamplesPerPixel(0, 0), (Object)new PositiveInteger(Integer.valueOf(2)));
    }

    @Test
    public void testThreeChannels() throws Exception {
        this.reader.setId("3C&sizeC=3.fake");
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertEquals((int)this.m.getChannelCount(0), (int)1);
        Assert.assertEquals((Object)this.m.getChannelSamplesPerPixel(0, 0), (Object)new PositiveInteger(Integer.valueOf(3)));
    }

    @Test
    public void testFourChannels() throws Exception {
        this.reader.setId("4C&sizeC=4.fake");
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertEquals((int)this.m.getChannelCount(0), (int)1);
        Assert.assertEquals((Object)this.m.getChannelSamplesPerPixel(0, 0), (Object)new PositiveInteger(Integer.valueOf(4)));
    }

    @Test
    public void testFiveChannels() throws Exception {
        this.reader.setId("5C&sizeC=5.fake");
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertEquals((int)this.m.getChannelCount(0), (int)5);
        Assert.assertEquals((Object)this.m.getChannelSamplesPerPixel(0, 0), (Object)new PositiveInteger(Integer.valueOf(1)));
        Assert.assertEquals((Object)this.m.getChannelSamplesPerPixel(0, 1), (Object)new PositiveInteger(Integer.valueOf(1)));
        Assert.assertEquals((Object)this.m.getChannelSamplesPerPixel(0, 2), (Object)new PositiveInteger(Integer.valueOf(1)));
        Assert.assertEquals((Object)this.m.getChannelSamplesPerPixel(0, 3), (Object)new PositiveInteger(Integer.valueOf(1)));
        Assert.assertEquals((Object)this.m.getChannelSamplesPerPixel(0, 4), (Object)new PositiveInteger(Integer.valueOf(1)));
    }

    @Test
    public void testSixChannels() throws Exception {
        this.reader.setId("6C&sizeC=6.fake");
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertEquals((int)this.m.getChannelCount(0), (int)6);
        Assert.assertEquals((Object)this.m.getChannelSamplesPerPixel(0, 0), (Object)new PositiveInteger(Integer.valueOf(1)));
        Assert.assertEquals((Object)this.m.getChannelSamplesPerPixel(0, 1), (Object)new PositiveInteger(Integer.valueOf(1)));
        Assert.assertEquals((Object)this.m.getChannelSamplesPerPixel(0, 2), (Object)new PositiveInteger(Integer.valueOf(1)));
        Assert.assertEquals((Object)this.m.getChannelSamplesPerPixel(0, 3), (Object)new PositiveInteger(Integer.valueOf(1)));
        Assert.assertEquals((Object)this.m.getChannelSamplesPerPixel(0, 4), (Object)new PositiveInteger(Integer.valueOf(1)));
        Assert.assertEquals((Object)this.m.getChannelSamplesPerPixel(0, 5), (Object)new PositiveInteger(Integer.valueOf(1)));
    }

    @Test
    public void testRGB() throws Exception {
        this.reader.setId("rgb&sizeC=3&rgb=3.fake");
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertEquals((int)this.m.getChannelCount(0), (int)1);
        Assert.assertEquals((Object)this.m.getChannelSamplesPerPixel(0, 0), (Object)new PositiveInteger(Integer.valueOf(3)));
    }

    @Test
    public void testTwoRGBChannels() throws Exception {
        this.reader.setId("rgb&sizeC=6&rgb=3.fake");
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertEquals((int)this.m.getChannelCount(0), (int)2);
        Assert.assertEquals((Object)this.m.getChannelSamplesPerPixel(0, 0), (Object)new PositiveInteger(Integer.valueOf(3)));
        Assert.assertEquals((Object)this.m.getChannelSamplesPerPixel(0, 1), (Object)new PositiveInteger(Integer.valueOf(3)));
    }
}

