/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.units.quantity.Power;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsPowerEnumHandler;
import ome.xml.model.primitives.PrimitiveNumber;

public enum UnitsPower implements Enumeration
{
    YOTTAWATT("YW"),
    ZETTAWATT("ZW"),
    EXAWATT("EW"),
    PETAWATT("PW"),
    TERAWATT("TW"),
    GIGAWATT("GW"),
    MEGAWATT("MW"),
    KILOWATT("kW"),
    HECTOWATT("hW"),
    DECAWATT("daW"),
    WATT("W"),
    DECIWATT("dW"),
    CENTIWATT("cW"),
    MILLIWATT("mW"),
    MICROWATT("\u00b5W"),
    NANOWATT("nW"),
    PICOWATT("pW"),
    FEMTOWATT("fW"),
    ATTOWATT("aW"),
    ZEPTOWATT("zW"),
    YOCTOWATT("yW");

    private final String value;

    private UnitsPower(String value) {
        this.value = value;
    }

    public static UnitsPower fromString(String value) throws EnumerationException {
        if ("YW".equals(value)) {
            return YOTTAWATT;
        }
        if ("ZW".equals(value)) {
            return ZETTAWATT;
        }
        if ("EW".equals(value)) {
            return EXAWATT;
        }
        if ("PW".equals(value)) {
            return PETAWATT;
        }
        if ("TW".equals(value)) {
            return TERAWATT;
        }
        if ("GW".equals(value)) {
            return GIGAWATT;
        }
        if ("MW".equals(value)) {
            return MEGAWATT;
        }
        if ("kW".equals(value)) {
            return KILOWATT;
        }
        if ("hW".equals(value)) {
            return HECTOWATT;
        }
        if ("daW".equals(value)) {
            return DECAWATT;
        }
        if ("W".equals(value)) {
            return WATT;
        }
        if ("dW".equals(value)) {
            return DECIWATT;
        }
        if ("cW".equals(value)) {
            return CENTIWATT;
        }
        if ("mW".equals(value)) {
            return MILLIWATT;
        }
        if ("\u00b5W".equals(value)) {
            return MICROWATT;
        }
        if ("nW".equals(value)) {
            return NANOWATT;
        }
        if ("pW".equals(value)) {
            return PICOWATT;
        }
        if ("fW".equals(value)) {
            return FEMTOWATT;
        }
        if ("aW".equals(value)) {
            return ATTOWATT;
        }
        if ("zW".equals(value)) {
            return ZEPTOWATT;
        }
        if ("yW".equals(value)) {
            return YOCTOWATT;
        }
        String s2 = String.format("'%s' not a supported value of '%s'", value, UnitsPower.class);
        throw new EnumerationException(s2);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public static <T extends PrimitiveNumber> Power create(T newValue, UnitsPower newUnit) {
        Power theQuantity = null;
        try {
            theQuantity = UnitsPowerEnumHandler.getQuantity(newValue, newUnit);
        }
        catch (EnumerationException enumerationException) {
            // empty catch block
        }
        return theQuantity;
    }

    public static <T extends Number> Power create(T newValue, UnitsPower newUnit) {
        Power theQuantity = null;
        try {
            theQuantity = UnitsPowerEnumHandler.getQuantity(newValue, newUnit);
        }
        catch (EnumerationException enumerationException) {
            // empty catch block
        }
        return theQuantity;
    }
}

