/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;

public class MetaEntityList
extends EntityList {
    public static final String VERSION_SRC = "versions.txt";
    public static final String ENTITY_SRC = "entities.txt";

    public MetaEntityList() throws IOException {
        super(VERSION_SRC, ENTITY_SRC);
    }

    public String className() {
        return this.value("className");
    }

    public String id() {
        return this.value("id");
    }

    public String basePackage() {
        return this.value("basePackage");
    }

    public String version() {
        return this.value("version");
    }

    public boolean spwImport() {
        return !"false".equals(this.value("spwImport"));
    }

    public String schema() {
        return "ome_xsd.html";
    }

    public String anchor() {
        String anchor = this.value("anchor");
        if (anchor == null) {
            anchor = this.ent + "_" + this.prop;
        }
        return anchor;
    }

    public boolean countable() {
        return "true".equals(this.value("countable"));
    }

    public String path() {
        return this.value("path");
    }

    public String defaultPath() {
        return this.value("path", null, this.ent, this.prop);
    }

    public String[] pathNodes() {
        return this.path().split("\\/");
    }

    public String last() {
        return this.last(this.path());
    }

    public String chop() {
        return this.chop(this.path());
    }

    public List<String> indices() {
        return this.indices(this.path());
    }

    public String argsList() {
        return this.argsList(this.defaultPath());
    }

    public String typesList() {
        return this.typesList(this.defaultPath());
    }

    public String varsList() {
        return this.varsList(this.path(), this.defaultPath());
    }

    public List<String> unique() {
        HashSet<String> set = new HashSet<String>();
        ArrayList<String> unique = new ArrayList<String>();
        for (String entity : this.entities.keySet()) {
            Entity e = (Entity)this.entities.get(entity);
            block1: for (String property : e.props.keySet()) {
                String path = this.value("path", this.ver, entity, property);
                if (path.equals("-")) continue;
                while (!set.contains(path)) {
                    set.add(path);
                    unique.add(path);
                    int slash = path.lastIndexOf("/");
                    if (slash < 0) continue block1;
                    path = path.substring(0, slash);
                }
            }
        }
        Collections.sort(unique);
        return unique;
    }

    public String type() {
        return this.value("type");
    }

    public String defaultType() {
        return this.value("type", null, this.ent, this.prop);
    }

    public String getter(String nodeVar) {
        String getter = this.value("getter");
        String s = getter == null ? "get" + this.name() : getter;
        s = nodeVar + "." + s;
        String type = this.type();
        String defaultType = this.defaultType();
        s = type.equals(defaultType) ? s + "()" : this.var(type) + "To" + defaultType + "(" + s + "())";
        return s;
    }

    public String setter(String nodeVar, String value) {
        String setter = this.value("setter");
        String s = setter == null ? "set" + this.name() : setter;
        String type = this.type();
        String defaultType = this.defaultType();
        s = type.equals(defaultType) ? s + "(" + value + ")" : s + "(" + this.var(defaultType) + "To" + type + "(" + value + "))";
        return nodeVar + "." + s;
    }

    public String enumeration() {
        return this.value("enumeration");
    }

    public String defaultValue() {
        return this.value("defaultValue");
    }

    public String description() {
        return this.value("description");
    }

    public String notes() {
        return this.value("notes");
    }

    public String doc() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.description());
        sb.append(".");
        String notes = this.notes();
        if (notes != null) {
            sb.append(" ");
            sb.append(notes);
        }
        return sb.toString();
    }

    public String var(String s) {
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (c[i] < 'A' || c[i] > 'Z') {
                if (i <= 1) break;
                int n = i - 1;
                c[n] = (char)(c[n] + -32);
                break;
            }
            int n = i++;
            c[n] = (char)(c[n] + 32);
        }
        return new String(c).replaceAll("[^\\w]", "");
    }

    public String ice(String s) {
        s = s.toLowerCase();
        s = s.replaceAll("\\[\\]", "Seq");
        s = s.replaceAll("integer", "int");
        if ((s = s.replaceAll("boolean", "bool")).endsWith("Seq")) {
            char[] c = s.toCharArray();
            if (c[0] >= 'a' && c[0] <= 'z') {
                c[0] = (char)(c[0] + -32);
            }
            s = new String(c);
        }
        return s;
    }

    public String primitive(String s) {
        if (s.equals("Boolean")) {
            return "boolean";
        }
        if (s.equals("Character")) {
            return "char";
        }
        if (s.equals("Byte")) {
            return "byte";
        }
        if (s.equals("Double")) {
            return "double";
        }
        if (s.equals("Float")) {
            return "float";
        }
        if (s.equals("Integer")) {
            return "int";
        }
        if (s.equals("Long")) {
            return "long";
        }
        if (s.equals("Short")) {
            return "short";
        }
        return s;
    }

    public String last(String path) {
        int first = path.lastIndexOf("/") + 1;
        return path.substring(first).replaceAll("\\+", "");
    }

    public String chop(String path) {
        int plus = path.lastIndexOf("+");
        if (plus < 0) {
            return null;
        }
        int slash = path.lastIndexOf("/", plus);
        return slash < 0 ? "" : path.substring(0, slash);
    }

    public List<String> indices(String path) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, "/");
        int tokens = st.countTokens();
        for (int i = 0; i < tokens; ++i) {
            String t = st.nextToken();
            if (!t.endsWith("+")) continue;
            list.add(t.replaceAll("\\+", ""));
        }
        return list;
    }

    public String argsList(String path) {
        return this.indicesList(path, path, true, true);
    }

    public String typesList(String path) {
        return this.indicesList(path, path, true, false);
    }

    public String varsList(String path) {
        return this.varsList(path, path);
    }

    public String varsList(String path, String defaultPath) {
        return this.indicesList(path, defaultPath, false, true);
    }

    private String indicesList(String path, String defaultPath, boolean doTypes, boolean doVars) {
        StringBuffer sb = new StringBuffer();
        List<String> indices = this.indices(path);
        List<String> defaultIndices = this.indices(defaultPath);
        while (defaultIndices.size() > indices.size()) {
            defaultIndices.remove(defaultIndices.size() - 1);
        }
        boolean first = true;
        for (String index : defaultIndices) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (doTypes) {
                sb.append("int");
            }
            if (doTypes && doVars) {
                sb.append(" ");
            }
            if (!doVars) continue;
            sb.append(this.var(index + "Index"));
        }
        return sb.toString();
    }
}

