/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.formats.IFormatHandler;

public class MetaSupportList {
    public static final String GROUPS_SRC = "meta-groups.txt";
    public static final String SUPPORT_SRC = "meta-support.txt";
    public static final String YES = "Yes";
    public static final String NO = "No";
    public static final String PARTIAL = "Partial";
    public static final String MISSING = "Missing";
    protected MetaEntityList entityList;
    protected HashMap<String, List<String>> groups = new HashMap();
    protected HashMap<String, HashMap<String, String>> supported = new HashMap();
    protected HashMap<String, String> pagenames = new HashMap();
    protected String version;
    protected String handlerName;

    public MetaSupportList(String version) throws IOException {
        this(version, GROUPS_SRC, SUPPORT_SRC);
    }

    public MetaSupportList(String version, String groupsPath, String supportPath) throws IOException {
        this.version = version;
        this.entityList = new MetaEntityList();
        this.entityList.setVersion(version);
        IniParser parser = new IniParser();
        IniList groupsList = parser.parseINI(groupsPath, MetaSupportList.class);
        IniList supportList = parser.parseINI(supportPath, MetaSupportList.class);
        HashMap groupHash = (HashMap)groupsList.get(0);
        for (String groupName : groupHash.keySet()) {
            String propString = (String)groupHash.get(groupName);
            StringTokenizer st = new StringTokenizer(propString, " ");
            ArrayList<String> propList = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String prop = st.nextToken();
                propList.add(prop);
            }
            Collections.sort(propList);
            this.groups.put(groupName, propList);
        }
        for (HashMap propHash : supportList) {
            String handler = (String)propHash.get("header");
            propHash.remove("header");
            this.supported.put(handler, propHash);
        }
    }

    public MetaEntityList entityList() {
        return this.entityList;
    }

    public String version() {
        return this.version;
    }

    public List<String> handlers() {
        ArrayList<String> handlers = new ArrayList<String>();
        for (String handler : this.supported.keySet()) {
            handlers.add(handler);
        }
        Collections.sort(handlers);
        return handlers;
    }

    public void setHandler(String name) {
        this.handlerName = name;
    }

    public String handler() {
        return this.handlerName;
    }

    public String format() {
        ReflectedUniverse r = new ReflectedUniverse();
        try {
            r.exec("import loci.formats.in." + this.handlerName);
        }
        catch (ReflectException reflectException) {
            // empty catch block
        }
        try {
            r.exec("import loci.formats.out." + this.handlerName);
        }
        catch (ReflectException reflectException) {
            // empty catch block
        }
        try {
            IFormatHandler handler = (IFormatHandler)r.exec("new " + this.handlerName + "()");
            return handler.getFormat();
        }
        catch (ReflectException reflectException) {
            return null;
        }
    }

    public String handlerType() {
        ReflectedUniverse r = new ReflectedUniverse();
        try {
            r.exec("import loci.formats.in." + this.handlerName);
            return "reader";
        }
        catch (ReflectException reflectException) {
            try {
                r.exec("import loci.formats.out." + this.handlerName);
                return "writer";
            }
            catch (ReflectException reflectException2) {
                return "handler";
            }
        }
    }

    public String getPageName() {
        return this.pagenames.get(this.handlerName);
    }

    public void setPageName(String pagename) {
        this.pagenames.put(this.handlerName, pagename);
    }

    public List<String> groups() {
        ArrayList<String> groupList = new ArrayList<String>();
        for (String group : this.groups.keySet()) {
            groupList.add(group);
        }
        Collections.sort(groupList);
        return groupList;
    }

    public List<String> groupMembers(String group) {
        return this.groups.get(group);
    }

    public List<String> yes() {
        return this.getSupportValue(YES);
    }

    public List<String> no() {
        return this.getSupportValue(NO);
    }

    public List<String> partial() {
        return this.getSupportValue(PARTIAL);
    }

    public List<String> missing() {
        return this.getSupportValue(MISSING);
    }

    public int yesHandlerCount(String entity, String prop) {
        return this.getHandlerCount(entity, prop, YES);
    }

    public int noHandlerCount(String entity, String prop) {
        return this.getHandlerCount(entity, prop, NO);
    }

    public int partialHandlerCount(String entity, String prop) {
        return this.getHandlerCount(entity, prop, PARTIAL);
    }

    public int missingHandlerCount(String entity, String prop) {
        return this.getHandlerCount(entity, prop, MISSING);
    }

    public String entity(String s) {
        int dot = s.indexOf(".");
        return s.substring(0, dot);
    }

    public String prop(String s) {
        int dot = s.indexOf(".");
        int space = s.indexOf(" ");
        return space < 0 ? s.substring(dot + 1) : s.substring(dot + 1, space);
    }

    public String comment(String s) {
        int space = s.indexOf(" ");
        if (space < 0) {
            return "";
        }
        return s.substring(space + 1).trim();
    }

    public String node(String entity) {
        this.entityList.setEntity(entity);
        return this.entityList.last();
    }

    protected List<String> getSupportValue(String supportValue) {
        ArrayList<String> props = new ArrayList<String>();
        HashMap<String, String> supportProps = this.supported.get(this.handlerName);
        boolean missing = MISSING.equals(supportValue);
        for (String entity : this.entityList.entities()) {
            int space;
            this.entityList.setEntity(entity);
            String entitySupportValue = supportProps.get(entity);
            String entitySince = null;
            int n = space = entitySupportValue == null ? -1 : entitySupportValue.indexOf(" ");
            if (space >= 0) {
                entitySince = entitySupportValue.substring(space).trim();
                entitySupportValue = entitySupportValue.substring(0, space).trim();
            }
            boolean all = supportValue.equals(entitySupportValue);
            boolean entityMissing = missing && entitySupportValue == null;
            for (String prop : this.entityList.props()) {
                String fqProp = entity + "." + prop;
                String propSupportValue = supportProps.get(fqProp);
                String comment = null;
                if (propSupportValue == null || entitySupportValue != null && entitySupportValue.equals(propSupportValue)) {
                    comment = entitySince;
                }
                int n2 = space = propSupportValue == null ? -1 : propSupportValue.indexOf(" ");
                if (space >= 0) {
                    comment = propSupportValue.substring(space).trim();
                    propSupportValue = propSupportValue.substring(0, space).trim();
                }
                if (!supportValue.equals(propSupportValue) && (!all || propSupportValue != null) && (!entityMissing || propSupportValue != null)) continue;
                props.add(comment == null ? fqProp : fqProp + " " + comment);
            }
        }
        Collections.sort(props);
        return props;
    }

    protected int getHandlerCount(String entity, String prop, String supportValue) {
        String fqProp = entity + "." + prop;
        boolean missing = MISSING.equals(supportValue);
        int handlerCount = 0;
        for (String handler : this.supported.keySet()) {
            String entitySupportValue;
            HashMap<String, String> supportProps = this.supported.get(handler);
            String propSupportValue = supportProps.get(fqProp);
            if (propSupportValue != null) {
                int space = propSupportValue.indexOf(" ");
                if (space >= 0) {
                    propSupportValue = propSupportValue.substring(0, space);
                }
                if (propSupportValue.equals(supportValue)) {
                    ++handlerCount;
                    continue;
                }
            }
            if ((entitySupportValue = supportProps.get(entity)) != null) {
                int space = entitySupportValue.indexOf(" ");
                if (space >= 0) {
                    entitySupportValue = entitySupportValue.substring(0, space);
                }
                if (entitySupportValue.equals(supportValue)) {
                    ++handlerCount;
                    continue;
                }
            }
            if (propSupportValue != null || entitySupportValue != null || !missing) continue;
            ++handlerCount;
        }
        return handlerCount;
    }
}

