/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import loci.common.DataTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;

public class MetadataRatings {
    private static final String METADATA = "meta-support.txt";
    private static final String FORMATS = "format-pages.txt";
    private static final String RATINGS_OUTPUT = System.getProperty("autogen.ratings");
    private static final String[] RATINGS = new String[]{"poor", "fair", "good", "very good", "outstanding"};
    private IniList metadata;
    private IniList formats;
    private File outputFile = new File(RATINGS_OUTPUT);

    public MetadataRatings() throws IOException {
        this.outputFile.getParentFile().mkdirs();
        IniParser parser = new IniParser();
        this.metadata = parser.parseINI(METADATA, MetadataRatings.class);
        this.formats = parser.parseINI(FORMATS, MetadataRatings.class);
    }

    public void updateRatings() throws IOException {
        String line;
        for (IniTable table : this.formats) {
            String readerName = (String)table.get((Object)"reader");
            String opennessRating = (String)table.get((Object)"opennessRating");
            String pixelsRating = (String)table.get((Object)"pixelsRating");
            String pyramid = (String)table.get((Object)"pyramid");
            int opennessIndex = DataTools.indexOf((Object[])RATINGS, (Object)opennessRating.toLowerCase());
            int pixelsIndex = DataTools.indexOf((Object[])RATINGS, (Object)pixelsRating.toLowerCase());
            int metadataIndex = Math.min(opennessIndex, pixelsIndex);
            for (IniTable metadataTable : this.metadata) {
                if (!((String)metadataTable.get((Object)"header")).equals(readerName)) continue;
                String instrument = (String)metadataTable.get((Object)"Instrument.ID");
                String instrumentRef = (String)metadataTable.get((Object)"Image.InstrumentRef");
                String emission = (String)metadataTable.get((Object)"Channel.EmissionWavelength");
                String excitation = (String)metadataTable.get((Object)"Channel.ExcitationWavelength");
                if (instrument != null && instrument.equalsIgnoreCase("yes") && instrumentRef != null && instrumentRef.equalsIgnoreCase("yes") || emission != null && emission.equalsIgnoreCase("yes") || excitation != null && excitation.equalsIgnoreCase("yes")) {
                    ++metadataIndex;
                }
                if (pyramid == null || !pyramid.equalsIgnoreCase("yes")) {
                    for (String key : metadataTable.keySet()) {
                        String value;
                        if (!key.startsWith("Plate.") && !key.startsWith("Screen.") && !key.startsWith("Well.") || (value = (String)metadataTable.get((Object)key)) == null || !value.equalsIgnoreCase("yes")) continue;
                        ++metadataIndex;
                    }
                    continue;
                }
                ++metadataIndex;
            }
            if (pixelsIndex >= opennessIndex && metadataIndex > pixelsIndex) {
                metadataIndex = pixelsIndex;
            }
            if (metadataIndex >= RATINGS.length) {
                metadataIndex = RATINGS.length - 1;
            }
            String rating = RATINGS[metadataIndex];
            String firstLetter = rating.substring(0, 1).toUpperCase();
            rating = firstLetter + rating.substring(1);
            table.put((Object)"metadataRating", (Object)rating);
        }
        BufferedReader reader = IniParser.openTextResource((String)FORMATS, MetadataRatings.class);
        ArrayList<String> lines = new ArrayList<String>();
        int ratingIndex = -1;
        while ((line = reader.readLine()) != null) {
            lines.add(line);
            line = line.trim();
            if (line.startsWith("reader =")) {
                String name = line.substring(line.indexOf("=") + 1).trim();
                String rating = null;
                for (IniTable table : this.formats) {
                    if (!name.equals(table.get((Object)"reader"))) continue;
                    rating = (String)table.get((Object)"metadataRating");
                    break;
                }
                if (ratingIndex < 0) continue;
                lines.set(ratingIndex, "metadataRating = " + rating);
                continue;
            }
            if (!line.startsWith("metadataRating =")) continue;
            ratingIndex = lines.size() - 1;
        }
        reader.close();
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), "UTF-8"));
        for (String line2 : lines) {
            out.write(line2);
            out.write("\n");
        }
        out.close();
    }

    public static void main(String[] args) throws IOException {
        MetadataRatings ratings = new MetadataRatings();
        ratings.updateRatings();
    }
}

