/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import loci.common.DataTools;
import loci.formats.FormatException;
import loci.formats.ImageReader;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;

public class OriginalMetadataAutogen {
    private static final String TEMPLATE = "templates/OriginalMetadataSupport.vm";
    private static final String RATINGS = System.getProperty("autogen.ratings");
    private static final String OUTPUT_DIR = System.getProperty("sphinx_builddir");
    private HashMap<String, HashMap<String, ArrayList>> metadata = new HashMap();
    private ImageReader reader = new ImageReader();

    public OriginalMetadataAutogen() throws FormatException, IOException {
        String[] files = DataTools.readFile((String)RATINGS).split("\n");
        for (int i = 0; i < files.length; ++i) {
            this.parseFile(files[i]);
            System.out.println("Parsed file #" + (i + 1) + " of " + files.length + " (" + (double)(i + 1) / (double)files.length * 100.0 + "%)");
        }
    }

    public void write() throws Exception {
        boolean success;
        boolean success2;
        File doc = new File(OUTPUT_DIR);
        if (!doc.exists() && !(success2 = doc.mkdir())) {
            throw new IOException("Could not create " + doc.getAbsolutePath());
        }
        File docMeta = new File(doc, "original_meta/");
        if (!docMeta.exists() && !(success = docMeta.mkdir())) {
            throw new IOException("Could not create " + docMeta.getAbsolutePath());
        }
        VelocityEngine engine = VelocityTools.createEngine();
        VelocityContext context = VelocityTools.createContext();
        for (String format : this.metadata.keySet()) {
            HashMap<String, ArrayList> meta = this.metadata.get(format);
            context.put("q", meta);
            context.put("format", (Object)format);
            String filename = format.replaceAll(" ", "_");
            filename = filename.replaceAll("/", "_");
            VelocityTools.processTemplate(engine, context, TEMPLATE, OUTPUT_DIR + "/original_meta/" + filename + ".txt");
        }
    }

    private void parseFile(String file) throws FormatException, IOException {
        try {
            this.reader.setId(file);
        }
        catch (Exception e) {
            return;
        }
        this.addMetadata(this.reader.getGlobalMetadata());
        for (int series = 0; series < this.reader.getSeriesCount(); ++series) {
            this.reader.setSeries(series);
            this.addMetadata(this.reader.getSeriesMetadata());
        }
        this.reader.close();
    }

    private void addMetadata(Hashtable<String, Object> readerMetadata) {
        String format = this.reader.getFormat();
        HashMap<String, ArrayList<Object>> meta = this.metadata.get(format);
        if (meta == null) {
            meta = new HashMap();
        }
        for (String key : readerMetadata.keySet()) {
            if (meta.containsKey(key) && !meta.get(key).contains(readerMetadata.get(key))) {
                meta.get(key).add(readerMetadata.get(key));
                continue;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(readerMetadata.get(key));
            meta.put(key, list);
        }
        this.metadata.put(format, meta);
    }

    public static void main(String[] args) throws Exception {
        OriginalMetadataAutogen autogen = new OriginalMetadataAutogen();
        autogen.write();
    }
}

