/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.WeibullDistribution;

public class WeibullDistributionImpl
extends AbstractContinuousDistribution
implements WeibullDistribution,
Serializable {
    private static final long serialVersionUID = 8589540077390120676L;
    private double alpha;
    private double beta;

    public WeibullDistributionImpl(double alpha, double beta) {
        this.setShape(alpha);
        this.setScale(beta);
    }

    public double cumulativeProbability(double x) {
        double ret = x <= 0.0 ? 0.0 : 1.0 - Math.exp(-Math.pow(x / this.getScale(), this.getShape()));
        return ret;
    }

    public double getShape() {
        return this.alpha;
    }

    public double getScale() {
        return this.beta;
    }

    public double inverseCumulativeProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("probability argument must be between 0 and 1 (inclusive)");
        }
        double ret = p == 0.0 ? 0.0 : (p == 1.0 ? Double.POSITIVE_INFINITY : this.getScale() * Math.pow(-Math.log(1.0 - p), 1.0 / this.getShape()));
        return ret;
    }

    public void setShape(double alpha) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("Shape must be positive.");
        }
        this.alpha = alpha;
    }

    public void setScale(double beta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("Scale must be positive.");
        }
        this.beta = beta;
    }

    protected double getDomainLowerBound(double p) {
        return 0.0;
    }

    protected double getDomainUpperBound(double p) {
        return Double.MAX_VALUE;
    }

    protected double getInitialDomain(double p) {
        return Math.pow(this.getScale() * Math.log(2.0), 1.0 / this.getShape());
    }
}

