/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.filter;

import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.filter.Enhancement;
import ucar.nc2.filter.FilterHelpers;

public class UnsignedConversion
implements Enhancement {
    private DataType outType;
    private DataType.Signedness signedness;

    public static UnsignedConversion createFromVar(VariableDS var) {
        String unsignedAtt;
        DataType origDataType = var.getDataType();
        if (!origDataType.isIntegral()) {
            return new UnsignedConversion(origDataType, DataType.Signedness.SIGNED);
        }
        DataType unsignedConversionType = origDataType;
        DataType.Signedness signedness = origDataType.getSignedness();
        if (signedness == DataType.Signedness.SIGNED && (unsignedAtt = var.attributes().findAttributeString("_Unsigned", null)) != null && unsignedAtt.equalsIgnoreCase("true")) {
            signedness = DataType.Signedness.UNSIGNED;
        }
        if (signedness == DataType.Signedness.UNSIGNED) {
            unsignedConversionType = FilterHelpers.nextLarger(origDataType).withSignedness(DataType.Signedness.UNSIGNED);
        }
        return new UnsignedConversion(unsignedConversionType, signedness);
    }

    public UnsignedConversion(DataType outType, DataType.Signedness signedness) {
        this.outType = outType;
        this.signedness = signedness;
    }

    public DataType getOutType() {
        return this.outType;
    }

    public DataType.Signedness getSignedness() {
        return this.signedness;
    }

    @Override
    public double convert(double value) {
        Number val;
        switch (this.outType) {
            case UBYTE: {
                val = new Byte((byte)value);
                break;
            }
            case USHORT: {
                val = new Byte((byte)value);
                break;
            }
            case UINT: {
                val = new Short((short)value);
                break;
            }
            case ULONG: {
                val = new Integer((int)value);
                break;
            }
            default: {
                val = new Double(value);
            }
        }
        return this.signedness == DataType.Signedness.UNSIGNED ? DataType.widenNumberIfNegative(val).doubleValue() : value;
    }

    public Array convertUnsigned(Array in) {
        if (this.signedness == DataType.Signedness.SIGNED) {
            return in;
        }
        Array out = Array.factory(this.outType, in.getShape());
        IndexIterator iterIn = in.getIndexIterator();
        IndexIterator iterOut = out.getIndexIterator();
        try {
            while (iterIn.hasNext()) {
                Number value = (Number)iterIn.getObjectNext();
                value = DataType.widenNumberIfNegative(value);
                iterOut.setObjectNext(value);
            }
        }
        catch (ClassCastException ex) {
            return in;
        }
        return out;
    }

    public static Number convertUnsigned(Number value, DataType dataType) {
        return dataType.isUnsigned() ? (Number)DataType.widenNumberIfNegative(value) : (Number)value;
    }
}

