/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image;

import jj2000.j2k.image.DataBlk;

public class DataBlkFloat
extends DataBlk {
    public float[] data;

    public DataBlkFloat() {
    }

    public DataBlkFloat(int ulx, int uly, int w, int h2) {
        this.ulx = ulx;
        this.uly = uly;
        this.w = w;
        this.h = h2;
        this.offset = 0;
        this.scanw = w;
        this.data = new float[w * h2];
    }

    public DataBlkFloat(DataBlkFloat src) {
        this.ulx = src.ulx;
        this.uly = src.uly;
        this.w = src.w;
        this.h = src.h;
        this.offset = 0;
        this.scanw = this.w;
        this.data = new float[this.w * this.h];
        for (int i = 0; i < this.h; ++i) {
            System.arraycopy(src.data, i * src.scanw, this.data, i * this.scanw, this.w);
        }
    }

    @Override
    public final int getDataType() {
        return 4;
    }

    @Override
    public final Object getData() {
        return this.data;
    }

    public final float[] getDataFloat() {
        return this.data;
    }

    @Override
    public final void setData(Object arr) {
        this.data = (float[])arr;
    }

    public final void setDataFloat(float[] arr) {
        this.data = arr;
    }

    @Override
    public String toString() {
        String str = super.toString();
        if (this.data != null) {
            str = str + ",data=" + this.data.length + " bytes";
        }
        return str;
    }
}

