/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.CellValueRecordInterface;
import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;

public class LabelSSTRecord
extends Record
implements CellValueRecordInterface,
Comparable {
    public static final short sid = 253;
    private int field_1_row;
    private short field_2_column;
    private short field_3_xf_index;
    private int field_4_sst_index;

    public LabelSSTRecord() {
    }

    public LabelSSTRecord(RecordInputStream in) {
        super(in);
    }

    @Override
    protected void validateSid(short id) {
        if (id != 253) {
            throw new RecordFormatException("NOT A valid LabelSST RECORD");
        }
    }

    @Override
    protected void fillFields(RecordInputStream in) {
        this.field_1_row = in.readUShort();
        this.field_2_column = in.readShort();
        this.field_3_xf_index = in.readShort();
        this.field_4_sst_index = in.readInt();
    }

    @Override
    public void setRow(int row) {
        this.field_1_row = row;
    }

    @Override
    public void setColumn(short col) {
        this.field_2_column = col;
    }

    @Override
    public void setXFIndex(short index) {
        this.field_3_xf_index = index;
    }

    public void setSSTIndex(int index) {
        this.field_4_sst_index = index;
    }

    @Override
    public int getRow() {
        return this.field_1_row;
    }

    @Override
    public short getColumn() {
        return this.field_2_column;
    }

    @Override
    public short getXFIndex() {
        return this.field_3_xf_index;
    }

    public int getSSTIndex() {
        return this.field_4_sst_index;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[LABELSST]\n");
        buffer.append("    .row            = ").append(Integer.toHexString(this.getRow())).append("\n");
        buffer.append("    .column         = ").append(Integer.toHexString(this.getColumn())).append("\n");
        buffer.append("    .xfindex        = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        buffer.append("    .sstindex       = ").append(Integer.toHexString(this.getSSTIndex())).append("\n");
        buffer.append("[/LABELSST]\n");
        return buffer.toString();
    }

    @Override
    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)253);
        LittleEndian.putShort(data, 2 + offset, (short)10);
        LittleEndian.putShort(data, 4 + offset, (short)this.getRow());
        LittleEndian.putShort(data, 6 + offset, this.getColumn());
        LittleEndian.putShort(data, 8 + offset, this.getXFIndex());
        LittleEndian.putInt(data, 10 + offset, this.getSSTIndex());
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        return 14;
    }

    @Override
    public short getSid() {
        return 253;
    }

    @Override
    public boolean isBefore(CellValueRecordInterface i) {
        if (this.getRow() > i.getRow()) {
            return false;
        }
        if (this.getRow() == i.getRow() && this.getColumn() > i.getColumn()) {
            return false;
        }
        return this.getRow() != i.getRow() || this.getColumn() != i.getColumn();
    }

    @Override
    public boolean isAfter(CellValueRecordInterface i) {
        if (this.getRow() < i.getRow()) {
            return false;
        }
        if (this.getRow() == i.getRow() && this.getColumn() < i.getColumn()) {
            return false;
        }
        return this.getRow() != i.getRow() || this.getColumn() != i.getColumn();
    }

    @Override
    public boolean isEqual(CellValueRecordInterface i) {
        return this.getRow() == i.getRow() && this.getColumn() == i.getColumn();
    }

    @Override
    public boolean isInValueSection() {
        return true;
    }

    @Override
    public boolean isValue() {
        return true;
    }

    public int compareTo(Object obj) {
        CellValueRecordInterface loc = (CellValueRecordInterface)obj;
        if (this.getRow() == loc.getRow() && this.getColumn() == loc.getColumn()) {
            return 0;
        }
        if (this.getRow() < loc.getRow()) {
            return -1;
        }
        if (this.getRow() > loc.getRow()) {
            return 1;
        }
        if (this.getColumn() < loc.getColumn()) {
            return -1;
        }
        if (this.getColumn() > loc.getColumn()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CellValueRecordInterface)) {
            return false;
        }
        CellValueRecordInterface loc = (CellValueRecordInterface)obj;
        return this.getRow() == loc.getRow() && this.getColumn() == loc.getColumn();
    }

    @Override
    public Object clone() {
        LabelSSTRecord rec = new LabelSSTRecord();
        rec.field_1_row = this.field_1_row;
        rec.field_2_column = this.field_2_column;
        rec.field_3_xf_index = this.field_3_xf_index;
        rec.field_4_sst_index = this.field_4_sst_index;
        return rec;
    }
}

