/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import loci.common.AbstractNIOHandle;

public class ByteArrayHandle
extends AbstractNIOHandle {
    protected static final int INITIAL_LENGTH = 1000000;
    protected ByteBuffer buffer;

    public ByteArrayHandle(byte[] bytes) {
        this.buffer = ByteBuffer.wrap(bytes);
    }

    public ByteArrayHandle(ByteBuffer bytes) {
        this.buffer = bytes;
    }

    public ByteArrayHandle(int capacity) {
        this.buffer = ByteBuffer.allocate(capacity);
        this.buffer.limit(capacity);
    }

    public ByteArrayHandle() {
        this.buffer = ByteBuffer.allocate(1000000);
        this.buffer.limit(0);
    }

    public byte[] getBytes() {
        return this.buffer.array();
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    @Override
    public void setLength(long length) throws IOException {
        if (length > (long)this.buffer.capacity()) {
            long fp = this.getFilePointer();
            ByteBuffer tmp = ByteBuffer.allocate((int)(length * 2L));
            ByteOrder order = this.buffer == null ? null : this.getOrder();
            this.seek(0L);
            this.buffer = tmp.put(this.buffer);
            if (order != null) {
                this.setOrder(order);
            }
            this.seek(fp);
        }
        this.buffer.limit((int)length);
    }

    @Override
    public void close() {
    }

    @Override
    public long getFilePointer() {
        return this.buffer.position();
    }

    @Override
    public long length() {
        return this.buffer.limit();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.getFilePointer() + (long)len > this.length()) {
            len = (int)(this.length() - this.getFilePointer());
        }
        this.buffer.get(b, off, len);
        return len;
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        return this.read(buf, 0, buf.capacity());
    }

    @Override
    public int read(ByteBuffer buf, int off, int len) throws IOException {
        if (buf.hasArray()) {
            this.buffer.get(buf.array(), off, len);
            return len;
        }
        byte[] b = new byte[len];
        this.read(b);
        buf.put(b, 0, len);
        return len;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos > this.length()) {
            this.setLength(pos);
        }
        this.buffer.position((int)pos);
    }

    @Override
    public ByteOrder getOrder() {
        return this.buffer.order();
    }

    @Override
    public void setOrder(ByteOrder order) {
        this.buffer.order(order);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.getFilePointer() + 1L > this.length()) {
            throw new EOFException("Attempting to read beyond end of file.");
        }
        try {
            return this.buffer.get();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException();
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public char readChar() throws IOException {
        if (this.getFilePointer() + 2L > this.length()) {
            throw new EOFException("Attempting to read beyond end of file.");
        }
        try {
            return this.buffer.getChar();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException();
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public double readDouble() throws IOException {
        if (this.getFilePointer() + 8L > this.length()) {
            throw new EOFException("Attempting to read beyond end of file.");
        }
        try {
            return this.buffer.getDouble();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException();
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public float readFloat() throws IOException {
        if (this.getFilePointer() + 4L > this.length()) {
            throw new EOFException("Attempting to read beyond end of file.");
        }
        try {
            return this.buffer.getFloat();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException();
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (this.getFilePointer() + (long)len > this.length()) {
            throw new EOFException("Attempting to read beyond end of file.");
        }
        try {
            this.buffer.get(b, off, len);
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException();
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public int readInt() throws IOException {
        if (this.getFilePointer() + 4L > this.length()) {
            throw new EOFException("Attempting to read beyond end of file.");
        }
        try {
            return this.buffer.getInt();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException();
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public String readLine() throws IOException {
        throw new IOException("Unimplemented");
    }

    @Override
    public long readLong() throws IOException {
        if (this.getFilePointer() + 8L > this.length()) {
            throw new EOFException("Attempting to read beyond end of file.");
        }
        try {
            return this.buffer.getLong();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException();
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public short readShort() throws IOException {
        if (this.getFilePointer() + 2L > this.length()) {
            throw new EOFException("Attempting to read beyond end of file.");
        }
        try {
            return this.buffer.getShort();
        }
        catch (BufferUnderflowException e) {
            EOFException eof = new EOFException();
            eof.initCause(e);
            throw eof;
        }
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public String readUTF() throws IOException {
        int length = this.readUnsignedShort();
        byte[] b = new byte[length];
        this.read(b);
        return new String(b, "UTF-8");
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.skipBytes((long)n);
    }

    @Override
    public long skipBytes(long n) throws IOException {
        long currentPosition = this.getFilePointer();
        if ((n = Math.min(n, this.length() - currentPosition)) <= 0L) {
            return 0L;
        }
        this.seek(currentPosition + n);
        return n;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.validateLength(len);
        this.buffer.put(b, off, len);
    }

    @Override
    public void write(ByteBuffer buf) throws IOException {
        this.write(buf, 0, buf.capacity());
    }

    @Override
    public void write(ByteBuffer buf, int off, int len) throws IOException {
        this.validateLength(len);
        buf.position(off);
        buf.limit(off + len);
        this.buffer.put(buf);
    }

    @Override
    public void write(int b) throws IOException {
        this.validateLength(1);
        this.buffer.put((byte)b);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeBytes(String s2) throws IOException {
        this.write(s2.getBytes("UTF-8"));
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.validateLength(2);
        this.buffer.putChar((char)v);
    }

    @Override
    public void writeChars(String s2) throws IOException {
        int len = 2 * s2.length();
        this.validateLength(len);
        char[] c = s2.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            this.writeChar(c[i]);
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.validateLength(8);
        this.buffer.putDouble(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.validateLength(4);
        this.buffer.putFloat(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.validateLength(4);
        this.buffer.putInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.validateLength(8);
        this.buffer.putLong(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.validateLength(2);
        this.buffer.putShort((short)v);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        byte[] b = str.getBytes("UTF-8");
        this.writeShort(b.length);
        this.write(b);
    }
}

