/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.io.File;
import loci.formats.FormatTools;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FormatToolsTest {
    @DataProvider(name="pixelTypes")
    public Object[][] createPixelTypes() {
        return new Object[][]{{0, -128L, 127L}, {2, -32768L, 32767L}, {4, Integer.MIN_VALUE, Integer.MAX_VALUE}, {1, 0L, 255L}, {3, 0L, 65535L}, {5, 0L, 0xFFFFFFFFL}, {6, Integer.MIN_VALUE, Integer.MAX_VALUE}, {7, Integer.MIN_VALUE, Integer.MAX_VALUE}};
    }

    @Test(dataProvider="pixelTypes")
    public void testDefaultMinMax(int type, long min, long max) {
        long[] lim = FormatTools.defaultMinMax((int)type);
        AssertJUnit.assertEquals((long)lim[0], (long)min);
        AssertJUnit.assertEquals((long)lim[1], (long)max);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testDefaultMinMaxInvalid() throws IllegalArgumentException {
        long[] lim = FormatTools.defaultMinMax((int)9999);
    }

    @DataProvider(name="physicalSizeNoUnit")
    public Object[][] createValueLengths() {
        return new Object[][]{{null, null}, {1.0E-6, null}, {0.0, null}, {Double.POSITIVE_INFINITY, null}, {1.0, new Length((Number)1.0, UNITS.MICROMETER)}, {0.1, new Length((Number)0.1, UNITS.MICROMETER)}};
    }

    @DataProvider(name="physicalSizeStringUnit")
    public Object[][] createValueStringLengths() {
        return new Object[][]{{null, "mm", null}, {1.0E-6, "mm", null}, {0.0, "mm", null}, {Double.POSITIVE_INFINITY, "mm", null}, {1.0, "microns", new Length((Number)1.0, UNITS.MICROMETER)}, {1.0, "mm", new Length((Number)1.0, UNITS.MILLIMETER)}, {0.1, "microns", new Length((Number)0.1, UNITS.MICROMETER)}, {0.1, "mm", new Length((Number)0.1, UNITS.MILLIMETER)}, {1.0, null, new Length((Number)1.0, UNITS.MICROMETER)}, {1.0, "foo", new Length((Number)1.0, UNITS.MICROMETER)}, {1.0, "s", new Length((Number)1.0, UNITS.MICROMETER)}};
    }

    @DataProvider(name="physicalSizeUnit")
    public Object[][] createValueUnitLengths() {
        return new Object[][]{{null, UNITS.MICROMETER, null}, {1.0E-6, UNITS.MICROMETER, null}, {0.0, UNITS.MICROMETER, null}, {Double.POSITIVE_INFINITY, UNITS.MICROMETER, null}, {1.0, UNITS.MICROMETER, new Length((Number)1.0, UNITS.MICROMETER)}, {1.0, UNITS.MILLIMETER, new Length((Number)1.0, UNITS.MILLIMETER)}, {0.1, UNITS.MICROMETER, new Length((Number)0.1, UNITS.MICROMETER)}, {0.1, UNITS.MILLIMETER, new Length((Number)0.1, UNITS.MILLIMETER)}};
    }

    @Test(dataProvider="physicalSizeNoUnit")
    public void testGetPhysicalSizeNoUnit(Double value, Length length) {
        AssertJUnit.assertEquals((Object)length, (Object)FormatTools.getPhysicalSizeX((Double)value));
        AssertJUnit.assertEquals((Object)length, (Object)FormatTools.getPhysicalSizeY((Double)value));
        AssertJUnit.assertEquals((Object)length, (Object)FormatTools.getPhysicalSizeZ((Double)value));
    }

    @Test(dataProvider="physicalSizeStringUnit")
    public void testGetPhysicalSizeStringUnit(Double value, String unit, Length length) {
        AssertJUnit.assertEquals((Object)length, (Object)FormatTools.getPhysicalSizeX((Double)value, (String)unit));
        AssertJUnit.assertEquals((Object)length, (Object)FormatTools.getPhysicalSizeY((Double)value, (String)unit));
        AssertJUnit.assertEquals((Object)length, (Object)FormatTools.getPhysicalSizeZ((Double)value, (String)unit));
    }

    @Test(dataProvider="physicalSizeUnit")
    public void testGetPhysicalSizeUnit(Double value, Unit<Length> unit, Length length) {
        AssertJUnit.assertEquals((Object)length, (Object)FormatTools.getPhysicalSizeX((Double)value, unit));
        AssertJUnit.assertEquals((Object)length, (Object)FormatTools.getPhysicalSizeY((Double)value, unit));
        AssertJUnit.assertEquals((Object)length, (Object)FormatTools.getPhysicalSizeZ((Double)value, unit));
    }

    @DataProvider(name="stagePositionStringUnit")
    public Object[][] createStagePositionStringUnit() {
        return new Object[][]{{null, "mm", null}, {0.0, "mm", new Length((Number)0.0, UNITS.MILLIMETER)}, {1.0, "mm", new Length((Number)1.0, UNITS.MILLIMETER)}, {0.1, "mm", new Length((Number)0.1, UNITS.MILLIMETER)}, {1.0E-6, "mm", new Length((Number)1.0E-6, UNITS.MILLIMETER)}, {-1.0E-6, "mm", new Length((Number)-1.0E-6, UNITS.MILLIMETER)}, {Double.POSITIVE_INFINITY, "mm", null}, {Double.NaN, "mm", null}, {1.0, null, new Length((Number)1.0, UNITS.REFERENCEFRAME)}, {1.0, "", new Length((Number)1.0, UNITS.REFERENCEFRAME)}, {1.0, "foo", new Length((Number)1.0, UNITS.REFERENCEFRAME)}, {1.0, "s", new Length((Number)1.0, UNITS.REFERENCEFRAME)}};
    }

    @DataProvider(name="stagePositionUnit")
    public Object[][] createStagePositionUnit() {
        return new Object[][]{{null, UNITS.MILLIMETER, null}, {0.0, UNITS.MILLIMETER, new Length((Number)0.0, UNITS.MILLIMETER)}, {1.0, UNITS.MILLIMETER, new Length((Number)1.0, UNITS.MILLIMETER)}, {0.1, UNITS.MILLIMETER, new Length((Number)0.1, UNITS.MILLIMETER)}, {1.0E-6, UNITS.MILLIMETER, new Length((Number)1.0E-6, UNITS.MILLIMETER)}, {-1.0E-6, UNITS.MILLIMETER, new Length((Number)-1.0E-6, UNITS.MILLIMETER)}, {Double.POSITIVE_INFINITY, UNITS.MILLIMETER, null}, {Double.NEGATIVE_INFINITY, UNITS.MILLIMETER, null}, {Double.NaN, UNITS.MILLIMETER, null}, {1.0, null, null}};
    }

    @DataProvider(name="lengthStringsWithDefault")
    public Object[][] createLengthStringsWithDefault() {
        return new Object[][]{{"invalidvalue", "", "m", null}, {"1.0", "", "", null}, {"1.0", "", "s", null}, {"1.0", "s", "m", null}, {"1e400", "m", "", null}, {"-1e400", "m", "", null}, {"e10", "m", "", null}, {"1.0", "invalidunit", "m", null}, {"-0.1", "m", "", new Length((Number)-0.1, UNITS.METER)}, {"0.0", "m", "", new Length((Number)0.0, UNITS.METER)}, {"1.0", "m", "", new Length((Number)1.0, UNITS.METER)}, {"1.0", "m", "m", new Length((Number)1.0, UNITS.METER)}, {"1.0", "m", "mm", new Length((Number)1.0, UNITS.METER)}, {"1.0", "mm", "mm", new Length((Number)1.0, UNITS.MILLIMETER)}, {"1.0", "", "m", new Length((Number)1.0, UNITS.METER)}, {"1.0", "", "mm", new Length((Number)1.0, UNITS.MILLIMETER)}};
    }

    @DataProvider(name="lengthStrings")
    public Object[][] createLengthStrings() {
        return new Object[][]{{"1.0", "", null}, {"invalidvalue", "", null}, {"1.0", "invalidunit", null}, {"1.0", "s", null}, {"1e400", "m", null}, {"-1e400", "m", null}, {"e10", "m", null}, {"-1e-3", "mm", new Length((Number)-0.001, UNITS.MILLIMETER)}, {"-0.1", "m", new Length((Number)-0.1, UNITS.METER)}, {"0.0", "m", new Length((Number)0.0, UNITS.METER)}, {"1.0", "m", new Length((Number)1.0, UNITS.METER)}, {"1.0", "mm", new Length((Number)1.0, UNITS.MILLIMETER)}};
    }

    @DataProvider(name="fileLists")
    public Object[][] createFileLists() {
        return new Object[][]{{null, 0}, {new String[0], 0}, {new String[]{"/dir1/dir2/test.tif"}, 0}, {new String[]{"test.tif"}, 0}, {new String[]{"/dir1/dir2/test.tif", "/dir1/dir2/test2.tif"}, 0}, {new String[]{"/dir1/test.tif", "/dir1/dir2/test2.tif"}, 1}, {new String[]{"test.tif", "dir2/test2.tif"}, 1}, {new String[]{"/test.tif", "/dir1/dir2/test2.tif"}, 2}, {new String[]{"/dir1/dir2/test.tif", "/dir3/dir4/dir5/test2.tif"}, 3}};
    }

    @DataProvider(name="wellNames")
    public Object[][] createWells() {
        return new Object[][]{{0, 0, "A", "A01"}, {10, 5, "K", "K06"}, {30, 99, "AE", "AE100"}};
    }

    @Test(dataProvider="stagePositionStringUnit")
    public void testGetStagePositionStringUnit(Double value, String unit, Length length) {
        AssertJUnit.assertEquals((Object)length, (Object)FormatTools.getStagePosition((Double)value, (String)unit));
    }

    @Test(dataProvider="stagePositionUnit")
    public void testGetStagePositionUnit(Double value, Unit<Length> unit, Length length) {
        AssertJUnit.assertEquals((Object)length, (Object)FormatTools.getStagePosition((Double)value, unit));
    }

    @Test(dataProvider="lengthStringsWithDefault")
    public void testParseLengthWithDefault(String value, String unit, String defaultUnit, Length length) {
        AssertJUnit.assertEquals((Object)length, (Object)FormatTools.parseLength((String)(value + unit), (String)defaultUnit));
        AssertJUnit.assertEquals((Object)length, (Object)FormatTools.parseLength((String)(value + " " + unit), (String)defaultUnit));
        AssertJUnit.assertEquals((Object)length, (Object)FormatTools.parseLength((String)(" " + value + unit), (String)defaultUnit));
        AssertJUnit.assertEquals((Object)length, (Object)FormatTools.parseLength((String)(value + unit + " "), (String)defaultUnit));
    }

    @Test(dataProvider="lengthStrings")
    public void testParseLength(String value, String unit, Length length) {
        AssertJUnit.assertEquals((Object)length, (Object)FormatTools.parseLength((String)(value + unit)));
        AssertJUnit.assertEquals((Object)length, (Object)FormatTools.parseLength((String)(value + " " + unit)));
        AssertJUnit.assertEquals((Object)length, (Object)FormatTools.parseLength((String)(" " + value + unit)));
        AssertJUnit.assertEquals((Object)length, (Object)FormatTools.parseLength((String)(value + unit + " ")));
    }

    @Test(dataProvider="fileLists")
    public void testGetRequiredDirectories(String[] files, int number) {
        String[] newfiles = null;
        if (files != null) {
            newfiles = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                newfiles[i] = files[i].replace('/', File.separatorChar);
            }
        }
        AssertJUnit.assertEquals((int)number, (int)FormatTools.getRequiredDirectories(newfiles));
    }

    @Test(dataProvider="wellNames")
    public void testWellNames(Integer row, Integer column, String rowName, String wellName) {
        AssertJUnit.assertEquals((String)FormatTools.getWellRowName((int)row), (String)rowName);
        AssertJUnit.assertEquals((String)FormatTools.getWellName((int)row, (int)column), (String)wellName);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidWellRow() {
        FormatTools.getWellRowName((int)-1);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidWellColumn() {
        FormatTools.getWellName((int)0, (int)-1);
    }
}

