/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import com.google.common.hash.Hashing;
import loci.formats.codec.CodecOptions;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffCompression;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class CompressDecompressTest {
    private void assertCompression(TiffCompression compression, boolean lossy) throws Exception {
        IFD ifd = new IFD();
        int w = 64;
        int h = 64;
        int bpp = 8;
        ifd.put((Object)256, (Object)w);
        ifd.put((Object)257, (Object)h);
        ifd.put((Object)258, (Object)new int[]{bpp});
        ifd.put((Object)277, (Object)1);
        ifd.put((Object)0, (Object)Boolean.TRUE);
        byte[] plane = new byte[w * h * (bpp / 8)];
        for (int i = 0; i < plane.length; ++i) {
            plane[i] = (byte)i;
        }
        CodecOptions options = compression.getCompressionCodecOptions(ifd);
        String beforeCompression = Hashing.md5().hashBytes(plane).toString();
        byte[] compressed = compression.compress(plane, options);
        String afterCompression = Hashing.md5().hashBytes(compressed).toString();
        if (compression.equals((Object)TiffCompression.UNCOMPRESSED)) {
            String afterDecompression;
            if (!beforeCompression.equals(afterCompression)) {
                AssertJUnit.fail((String)("Compression: " + compression.getCodecName() + " " + String.format("Compression MD5 %s != %s", beforeCompression, afterCompression)));
            }
            if (!beforeCompression.equals(afterDecompression = Hashing.md5().hashBytes(compression.decompress(compressed, options)).toString())) {
                AssertJUnit.fail((String)("Compression: " + compression.getCodecName() + " " + String.format("Decompression MD5 %s != %s", beforeCompression, afterDecompression)));
            }
        } else {
            if (beforeCompression.equals(afterCompression)) {
                AssertJUnit.fail((String)("Compression: " + compression.getCodecName() + " " + String.format("Compression MD5 %s != %s", beforeCompression, afterCompression)));
            }
            String afterDecompression = Hashing.md5().hashBytes(compression.decompress(compressed, options)).toString();
            if (!lossy && !beforeCompression.equals(afterDecompression)) {
                AssertJUnit.fail((String)("Compression: " + compression.getCodecName() + " " + String.format("Decompression MD5 %s != %s", beforeCompression, afterDecompression)));
            }
        }
    }

    @Test
    public void testCompressDecompressedJ2KLossless() throws Exception {
        this.assertCompression(TiffCompression.JPEG_2000, false);
    }

    @Test
    public void testCompressDecompressedJ2KLossy() throws Exception {
        this.assertCompression(TiffCompression.JPEG_2000_LOSSY, true);
    }

    @Test
    public void testCompressDecompressedJPEG() throws Exception {
        this.assertCompression(TiffCompression.JPEG, true);
    }

    @Test
    public void testCompressDecompressedDeflate() throws Exception {
        this.assertCompression(TiffCompression.DEFLATE, false);
    }

    @Test
    public void testCompressDecompressedUncompressed() throws Exception {
        this.assertCompression(TiffCompression.UNCOMPRESSED, false);
    }
}

