/*
 * Decompiled with CFR 0.152.
 */
package loci.tests.testng;

import java.io.IOException;
import java.util.ArrayList;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.tests.testng.TestTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class FileHandleTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileHandleTest.class);
    private String id;
    private IFormatReader reader;

    @Parameters(value={"id"})
    @BeforeClass
    public void init(String id) {
        this.id = id;
    }

    @Test
    public void testHandleCount() throws FormatException, IOException {
        String s;
        int i;
        ArrayList<String> initialHandles = TestTools.getHandles();
        this.reader = new ImageReader();
        this.reader.setId(this.id);
        ArrayList<String> intermediateHandles = TestTools.getHandles();
        this.reader.close();
        ArrayList<String> finalHandles = TestTools.getHandles();
        int intermediateHandleCount = intermediateHandles.size();
        for (i = 0; i < initialHandles.size(); ++i) {
            s = initialHandles.get(i);
            initialHandles.remove(s);
            finalHandles.remove(s);
            intermediateHandles.remove(s);
            --i;
        }
        for (i = 0; i < finalHandles.size(); ++i) {
            s = finalHandles.get(i);
            if (s.endsWith("libnio.so") || s.endsWith("resources.jar") || s.startsWith("/usr/lib") || s.startsWith("/opt/") || s.startsWith("/usr/share/locale") || s.startsWith("/lib") || s.indexOf("turbojpeg") > 0 || s.indexOf("/jre/") > 0 || s.indexOf("nativedata") > 0 || s.indexOf("jhdf") > 0) {
                finalHandles.remove(s);
                --i;
                continue;
            }
            LOGGER.warn(s);
        }
        AssertJUnit.assertEquals((int)finalHandles.size(), (int)initialHandles.size());
        AssertJUnit.assertTrue((intermediateHandles.size() >= initialHandles.size() ? 1 : 0) != 0);
        AssertJUnit.assertTrue((intermediateHandleCount < 1024 ? 1 : 0) != 0);
    }
}

