/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.conv;

import java.io.IOException;
import java.util.StringTokenizer;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.util.CancelTask;

public class MADISStation
extends CoordSystemBuilder {
    private static final String CONVENTION_NAME = "MADIS_Station_1.0";

    private MADISStation(NetcdfDataset.Builder datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = CONVENTION_NAME;
    }

    @Override
    public void augmentDataset(CancelTask cancelTask) throws IOException {
        String timeVars = this.rootGroup.getAttributeContainer().findAttValueIgnoreCase("timeVariables", "");
        StringTokenizer stoker = new StringTokenizer(timeVars, ", ");
        while (stoker.hasMoreTokens()) {
            String vname = stoker.nextToken();
            this.rootGroup.findVariable(vname).ifPresent(v -> v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString())));
        }
        String locVars = this.rootGroup.getAttributeContainer().findAttValueIgnoreCase("stationLocationVariables", "");
        stoker = new StringTokenizer(locVars, ", ");
        int count = 0;
        while (stoker.hasMoreTokens()) {
            String vname = stoker.nextToken();
            if (this.rootGroup.findVariable(vname).isPresent()) {
                Variable.Builder<?> v2 = this.rootGroup.findVariable(vname).get();
                AxisType atype = count == 0 ? AxisType.Lat : (count == 1 ? AxisType.Lon : AxisType.Height);
                v2.addAttribute(new Attribute("_CoordinateAxisType", atype.toString()));
            } else {
                this.parseInfo.format(" cant find time variable %s%n", vname);
            }
            ++count;
        }
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        public String getConventionName() {
            return MADISStation.CONVENTION_NAME;
        }

        @Override
        public boolean isMine(NetcdfFile ncfile) {
            String s2 = ncfile.getRootGroup().attributes().findAttValueIgnoreCase("Conventions", "none");
            return s2.startsWith("MADIS");
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder datasetBuilder) {
            return new MADISStation(datasetBuilder);
        }
    }
}

