/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class I2IReader
extends FormatReader {
    private static final int HEADER_SIZE = 1024;

    public I2IReader() {
        super("I2I", new String[]{"i2i"});
        this.domains = new String[]{"Light Microscopy"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)1024, (boolean)false)) {
            return false;
        }
        char pixelType = (char)stream.readByte();
        if (pixelType != 'I' && pixelType != 'R' && pixelType != 'C') {
            return false;
        }
        char check = (char)stream.readByte();
        if (check != ' ') {
            return false;
        }
        long pixelCount = this.getDimension(stream);
        pixelCount *= (long)this.getDimension(stream);
        return (pixelCount *= (long)this.getDimension(stream)) > 0L;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        long planeSize = FormatTools.getPlaneSize((IFormatReader)this);
        long offset = 1024L + (long)no * planeSize;
        if (offset + planeSize <= this.in.length() && offset >= 0L) {
            this.in.seek(offset);
            this.readPlane(this.in, x, y, w, h, buf);
        }
        return buf;
    }

    public void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        char pixelType = (char)this.in.readByte();
        switch (pixelType) {
            case 'I': {
                m.pixelType = 2;
                break;
            }
            case 'R': {
                m.pixelType = 6;
                break;
            }
            case 'C': {
                throw new FormatException("Complex pixel data not yet supported");
            }
            default: {
                throw new FormatException("Invalid pixel type: " + pixelType);
            }
        }
        if ((char)this.in.readByte() != ' ') {
            throw new FormatException("Expected space after pixel type character");
        }
        m.sizeX = this.getDimension(this.in);
        m.sizeY = this.getDimension(this.in);
        m.sizeZ = this.getDimension(this.in);
        m.littleEndian = (char)this.in.readByte() != 'B';
        this.in.order(this.isLittleEndian());
        short minPixelValue = this.in.readShort();
        short maxPixelValue = this.in.readShort();
        short xCoordinate = this.in.readShort();
        short yCoordinate = this.in.readShort();
        short n = this.in.readShort();
        this.in.skipBytes(33);
        for (int i = 0; i < 15; ++i) {
            String history = this.in.readString(64);
            this.addGlobalMetaList("Image history", history.trim());
        }
        this.addGlobalMeta("Minimum intensity value", minPixelValue);
        this.addGlobalMeta("Maximum intensity value", maxPixelValue);
        this.addGlobalMeta("Image position X", xCoordinate);
        this.addGlobalMeta("Image position Y", yCoordinate);
        if (n > 0) {
            m.sizeZ /= n;
        }
        m.sizeT = n;
        m.imageCount = this.getSizeZ() * this.getSizeT();
        m.sizeC = 1;
        m.rgb = false;
        m.dimensionOrder = "XYZTC";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
    }

    private int getDimension(RandomAccessInputStream stream) throws IOException {
        String dim = stream.readString(6).trim();
        Integer dimension = DataTools.parseInteger((String)dim);
        return dimension == null ? 0 : dimension;
    }
}

