/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.shortcut;

import ij.IJ;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import loci.plugins.shortcut.ShortcutPanel;

public class ShortcutTransferHandler
extends TransferHandler {
    protected ShortcutPanel shortcutPanel;

    public ShortcutTransferHandler(ShortcutPanel shortcutPanel) {
        this.shortcutPanel = shortcutPanel;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        return true;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t2) {
        try {
            DataFlavor[] flavors = t2.getTransferDataFlavors();
            int fileIndex = -1;
            int stringIndex = -1;
            int listIndex = -1;
            for (int i = 0; i < flavors.length && (fileIndex < 0 || stringIndex < 0 || listIndex < 0); ++i) {
                Class<?> c = flavors[i].getRepresentationClass();
                if (fileIndex < 0 && c == File.class) {
                    fileIndex = i;
                }
                if (stringIndex < 0 && c == String.class) {
                    stringIndex = i;
                }
                if (listIndex >= 0 || c != List.class) continue;
                listIndex = i;
            }
            List<Object> list = null;
            if (listIndex >= 0) {
                list = (List<String>)t2.getTransferData(flavors[listIndex]);
            } else if (fileIndex >= 0) {
                File f = (File)t2.getTransferData(flavors[fileIndex]);
                list = Arrays.asList(f);
            } else if (stringIndex >= 0) {
                String s2 = (String)t2.getTransferData(flavors[stringIndex]);
                list = Arrays.asList(s2.split("[ \t\n\r\f]"));
            }
            if (list == null) {
                return false;
            }
            final String[] ids = new String[list.size()];
            for (int i = 0; i < ids.length; ++i) {
                Object item = list.get(i);
                String id = null;
                if (item instanceof File) {
                    File f = (File)item;
                    id = f.getAbsolutePath();
                } else if (item instanceof String) {
                    id = (String)item;
                }
                if (id == null) {
                    System.err.println("Warning: ignoring item #" + i + ": " + item);
                    continue;
                }
                ids[i] = id.replaceAll("^file:/*", "/");
                if (new File(ids[i]).exists()) continue;
                ids[i] = URLDecoder.decode(ids[i], "UTF-8");
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < ids.length; ++i) {
                        ShortcutTransferHandler.this.shortcutPanel.open(ids[i]);
                    }
                }
            });
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
            DataFlavor[] df = t2.getTransferDataFlavors();
            System.err.println("Supported flavors:");
            for (int i = 0; i < df.length; ++i) {
                System.err.println("\t#" + i + ": " + df[i]);
            }
            IJ.error((String)e.toString());
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            IJ.error((String)e.toString());
            return false;
        }
        return true;
    }
}

